//古城
LootJS.modifiers(event => {//远古城市        
    //定义删除物品,[物品id]
    let removeLoot = [
        ['minecraft:coal'],//煤炭
        ['minecraft:book'],//书
        ['minecraft:bone'],//骨头
        ['minecraft:diamond_hoe'],//钻石锄
        ['minecraft:glow_berries'],//发光浆果
        ['minecraft:candle'],//蜡烛
        ['minecraft:soul_torch'],//灵魂火把
        ['minecraft:name_tag'],//命名牌
        ['minecraft:compass'],//指南针
        ['minecraft:lead'],//拴绳
        ['minecraft:amethyst_shard'],//紫水晶碎片
        ['minecraft:diamond_horse_armor'],//钻石马铠
        ['minecraft:disc_fragment_5'],//唱片碎片
        ['touhou_little_maid:power_point'],//P点
        ['minecraft:saddle'],//鞍 
        ['minecraft:potion'],//再生药水
        [Item.of('minecraft:iron_leggings')],//铁护腿
        [Item.of('minecraft:diamond_leggings')],//钻石护腿
        ['minecraft:experience_bottle'],//附魔之瓶
        ['galosphere:spectre_flare'],//幽荧照明弹
        ['minecraft:music_disc_13'],//13号唱片
        ['minecraft:music_disc_cat'],//猫唱片
        ['minecraft:music_disc_otherside'],//唱片
        ['minecraft:ward_armor_trim_smithing_template'],//锻造模板
        ['deeperdarker:warden_upgrade_smithing_template'],//锻造模板
    ]
    //定义添加权重物品[物品id,权重]
    let weightLootItem = [
        ['ltc2:sculk_mint', 3],//辣条工艺2 幽匿薄荷
        ['dungeonsdelight:wardenzola_crumbles', 1],//地牢乐事 幽匿蓝纹奶酪碎
        ['dungeonsdelight:sculk_apple', 3], //地牢乐事 幽匿苹果
        ['dungeonsdelight:sculk_mayo', 1],//地牢乐事 幽匿蛋黄酱
        ['silentsdelight:warden_ear', 3],//美味的寂静（幽匿乐事） 坚守者耳
        ['lightmanscurrency:coin_gold',1],//硬币与物品 金币  
    ]
    //定义添加权重物品[物品id,概率]
    let lootItem = [
        ['enigmaticlegacy:darkest_scroll', 0.1],//神秘遗物 至暗卷轴
        ['bountifulfares:hoary_apple', 0.15],//丰饶食记 朽老苹果
        ['lightmanscurrency:coin_emerald', 0.15],//硬币与物品 绿宝石币
        ['vintagedelight:century_egg', 0.05],//腌渍乐事 松花蛋（厨神之证）
        ['enigmaticlegacy:unholy_grail',0.1],//神秘遗物 不洁圣杯
        ['immortalers_delight:enchanted_golden_himekaido',0.2],//千古乐事 金魔法果
    ]
//遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('minecraft:chests/ancient_city')//远古城市
            //随机抽取2-3次weightLootItem里面的参数
            .addWeightedLoot([3, 3], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('minecraft:chests/ancient_city')
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('minecraft:chests/ancient_city')//远古城市
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})


//废弃矿井
LootJS.modifiers(event => {  //废弃矿井
    //定义删除物品,[物品id]
    let removeLoot = [
        ['minecraft:coal'],//煤炭
        ['minecraft:glow_berries'],//发光浆果
        ['minecraft:compass'],//指南针
        ['minecraft:beetroot_seeds'],//甜菜种子
        ['minecraft:melon_seeds'],//西瓜种子
        ['minecraft:rail'],//铁轨
        ['minecraft:powered_rail'],//动力铁轨
        ['minecraft:activator_rail'],//激活铁轨
        ['minecraft:detector_rail'],//探测铁轨
        ['minecraft:leather'],//皮革
        ['minecraft:iron_ingot'],//铁
        ['minecraft:gold_ingot'],//金
        ['minecraft:emerald'],//绿宝石
        ['minecraft:diamond'],//钻石
        ['minecraft:lapis_lazuli'],//青金石
        ['minecraft:redstone'],//红石
        ['additionaladditions:rope'],//绳子
        ['supplementaries:rope'],//绳索
        ['farmersdelight:rope'],//绳子
        ['additionaladditions:glow_stick'],//荧光棒
        ['muffins_thaidelight:pepper_seeds'],//辣椒种子
        ['minecraft:torch'],//火把
        ['dumplings_delight:chinese_cabbage_seeds'],//白菜种子
        [('minecraft:clock')],//钟
        [Item.of('minecraft:iron_axe')],//铁斧头
        ['farmersdelight:cabbage_seeds'],//卷心菜种子
        ['additionaladditions:rose_gold_upgrade'],//锻造模板
        ['minecraft:pumpkin_seeds'],//南瓜种子
        ['galosphere:silver_upgrade_smithing_template'],//锻造模板
        [Item.of('minecraft:potion', '{Potion:"ars_nouveau:mana_regen_potion_long"}')],//药水
        ['ars_nouveau:music_disc_aria_biblio'],//唱片
    ]

    //定义添加权重物品[物品id,权重]
    let weightLootItem = [
        ['bountifulfares:stone_stew', 2],//丰饶食记 石头炖
        ['vanillacookbook:miners_salad', 2],//原版烹饪书 矿工沙拉
        ['mineraldelight:geode_carrot', 1],//矿工乐事 晶簇胡萝卜
        ['mineraldelight:dazzling_candy', 2],//矿工乐事 炫目糖果
        ['mineraldelight:diamond_biscuit', 1],//矿工乐事 钻石饼干
        ['mineraldelight:amethyst_apple', 2],//矿工乐事 紫金苹果
        ['mineraldelight:lapis_mochi', 2],//矿工乐事 青金石团子
        ['mineraldelight:pebble_in_a_bowl', 2],//矿工乐事 碗装鹅卵石
        ['composite_material:dungeon_steel_ingot', 1],//复合材料 地牢钢锭
        ['mineraldelight:golden_dough', 1],//矿工乐事 金色面团
        ['lightmanscurrency:coin_gold',1],//硬币与物品 金币
    ]

    //定义添加权重物品[物品id,概率]
    let lootItem = [
        ['mineraldelight:shining_broth', 0.2],//矿工乐事 闪亮肉汤
        ['galospheric_delight:fruits_in_amethyst_dust', 0.1],//晶界飨宴 紫金渍果
        ['mineraldelight:amethyst_carrot', 0.1],//矿工乐事 紫金胡萝卜
        ['mineraldelight:diamond_jello', 0.2],//矿工乐事 钻石果冻
    ]
    
    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('minecraft:chests/abandoned_mineshaft')//废弃矿井
            //随机抽取1-4次weightLootItem里面的参数
            .addWeightedLoot([1, 4], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('minecraft:chests/abandoned_mineshaft')
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('minecraft:chests/abandoned_mineshaft')//废弃矿井
            .removeLoot(item)//删除遍历removeLoot的物品

     })
    })


//堡垒遗迹桥
LootJS.modifiers(event => {//堡垒遗迹桥
    //定义删除物品,[物品id]
    let removeLoot = [
        ['minecraft:string'],//线
        ['minecraft:arrow'],//箭
        ['minecraft:spectral_arrow'],//光灵箭
        ['minecraft:leather'],//皮革
        ['minecraft:gold_nugget'],//金粒
        ['minecraft:iron_nugget'],//铁粒
        [Item.of('minecraft:golden_leggings', '{Damage:0}')],//金护腿
        [Item.of('minecraft:golden_pickaxe', '{Damage:0}')],//金稿
        [Item.of('minecraft:golden_axe', '{Damage:0}')],//金斧
    ]
    //定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['mynethersdelight:hoglin_loin', 20],//下界乐事 疣猪兽腰肉
        ['mynethersdelight:ghasta', 30],//下界乐事 恶魂意面
        ['mynethersdelight:strider_rock', 20],//下界乐事 炽足兽岩壳蛋
        ['lightmanscurrency:coin_gold',10],//硬币与物品 金币
        ['minecraft:cooked_porkchop',30],//熟猪肉
    ]

    let lootItem = [
        ['minecraft:netherite_scrap', 0.3],//下界合金碎片
        ['mynethersdelight:hotdog_with_mixed_salad', 0.1],//下界乐事 混合沙拉热狗
        ['mynethersdelight:hotdog', 0.2],//下界乐事 热狗
        ['mynethersdelight:hotdog_with_nether_salad', 0.1],//下界乐事 下界沙拉热狗
        ['mynethersdelight:chilidog', 0.1],//火辣热狗
        ['mynethersdelight:resurgent_soil', 0.3],//下界乐事 复生沃土
    ]
    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('minecraft:chests/bastion_bridge')//堡垒遗迹桥
            //随机抽取2-4次weightLootItem里面的参数
            .addWeightedLoot([2, 4], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('minecraft:chests/bastion_bridge')
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('minecraft:chests/bastion_bridge')//堡垒遗迹桥
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})


//堡垒遗迹疣猪兽棚
LootJS.modifiers(event => {//堡垒遗迹疣猪兽棚
    //定义删除物品,[物品id]
    let removeLoot = [
        ['minecraft:string'],//线
        ['minecraft:arrow'],//箭
        ['minecraft:crimson_roots'],//绯红索菌
        ['minecraft:soul_sand'],//灵魂沙
        ['minecraft:crimson_nylium'],//绯红菌岩
        ['minecraft:glowstone'],//萤石
        ['minecraft:gold_nugget'],//金粒
        [Item.of('minecraft:golden_leggings', '{Damage:0}')],//金护腿
        [Item.of('minecraft:golden_pickaxe', '{Damage:0}')],//金稿
        [Item.of('minecraft:golden_axe', '{Damage:0}')],//金斧
    ]
    //定义添加权重物品[物品id,权重]
    let weightLootItem = [
        ['mynethersdelight:hoglin_loin', 2],//下界乐事 疣猪兽腰肉
        ['mynethersdelight:ghasta', 3],//下界乐事 恶魂意面
        ['mynethersdelight:strider_rock', 2],//下界乐事 炽足兽岩壳蛋
        ['lightmanscurrency:coin_gold',1],//硬币与物品 金币
        ['minecraft:cooked_porkchop',30],//熟猪肉
    ]
    let lootItem = [
        ['minecraft:netherite_scrap', 0.3],//下界合金碎片
        ['mynethersdelight:sausage_and_potatoes', 0.3],//下界乐事 香肠配土豆
        ['mynethersdelight:red_loin_on_a_stick', 0.3],//下界乐事 赤红腰肉烤串
        ['mynethersdelight:resurgent_soil', 0.3],//下界乐事 复生沃土
    ]
//遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('minecraft:chests/bastion_hoglin_stable')//堡垒遗迹疣猪兽棚
            //随机抽取1-4次weightLootItem里面的参数
            .addWeightedLoot([1, 4], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('minecraft:chests/bastion_hoglin_stable')
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('minecraft:chests/bastion_hoglin_stable')//堡垒遗迹疣猪兽棚
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})


//堡垒遗迹塔尖
LootJS.modifiers(event => {//堡垒遗迹塔尖
    //定义删除物品,[物品id]
    let removeLoot = [
        ['minecraft:string'],//线
        ['minecraft:arrow'],//箭
        ['minecraft:gold_nugget'],//金粒
        ['minecraft:spectral_arrow'],//光灵箭
        ['minecraft:iron_nugget'],//铁粒
        ['minecraft:chain'],//锁链
        ['minecraft:lava_bucket'],//熔岩桶
        ['minecraft:crossbow'],//弩
        ['minecraft:obsidian'],//黑曜石
        ['minecraft:bone_block'],//骨块
        [Item.of('minecraft:golden_leggings', '{Damage:0}')],//金护腿
        [Item.of('minecraft:golden_pickaxe', '{Damage:0}')],//金稿
        [Item.of('minecraft:golden_axe', '{Damage:0}')],//金斧
    ]
  //定义添加权重物品[物品id,权重]
    let weightLootItem = [
        ['mynethersdelight:hoglin_loin', 2],//下界乐事 疣猪兽腰肉
        ['mynethersdelight:ghasta', 3],//下界乐事 恶魂意面
        ['mynethersdelight:strider_rock', 2],//下界乐事 炽足兽岩壳蛋
        ['minecraft:cooked_porkchop',3],//熟猪肉
        ['lightmanscurrency:coin_gold',1],//硬币与物品 金币
    ]
     let lootItem = [
        ['minecraft:netherite_scrap', 0.3],//下界合金碎片
        ['mynethersdelight:spicy_skewer', 0.2],//下界乐事 辛辣烤串
        ['mynethersdelight:spicy_cotton', 0.2],//下界乐事 辛辣面花串
        ['mynethersdelight:resurgent_soil', 0.3],//下界乐事 复生沃土
     ]

//遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('minecraft:chests/bastion_other')//堡垒遗迹塔尖
            //随机抽取1-4次weightLootItem里面的参数
            .addWeightedLoot([1, 5], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('minecraft:chests/bastion_other')
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('minecraft:chests/bastion_other')//堡垒遗迹塔尖
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})


//堡垒遗迹宝藏室
LootJS.modifiers(event => {//堡垒遗迹宝藏室
    //定义删除物品,[物品id]
    let removeLoot = [
        ['minecraft:quartz'],//下界石英
        ['minecraft:gold_nugget'],//金粒
        ['minecraft:spectral_arrow'],//光灵箭
        ['minecraft:crying_obsidian'],//哭泣黑曜石
        ['touhou_little_maid:power_point'],//p点
        ['minecraft:netherite_upgrade_smithing_template'],//锻造模板
        [Item.of('minecraft:diamond_sword', '{Damage:0}')],//钻石剑
        [Item.of('farmersdelight:diamond_knife', '{Damage:0}')],//钻石刀
        ['minecraft:iron_ingot'],//铁
        ['sophisticatedbackpacks:gold_backpack'],//金背包
        ['minecraft:iron_block'],//铁块
        ['touhou_little_maid:shrine',],//神龛
        [Item.of('minecraft:diamond_chestplate', '{Damage:91}')],//钻石甲
        ['ars_nouveau:wixie_shards'],//药水
        ['nethervinery:crimson_grape_seeds'],//种子
        ['sophisticatedbackpacks:feeding_upgrade'],//喂食升级
        [Item.of('minecraft:diamond_helmet', '{Damage:13}')],//钻石头盔
        ['minecraft:gold_block'],//金块
        ['minecraft:gold_ingot'],//金子
        [Item.of('minecraft:potion', '{Potion:"ars_nouveau:mana_regen_potion_long"}')],//药水
        ['ars_nouveau:amplify_arrow'],//箭
    ]
    //定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['lightmanscurrency:coin_emerald', 2],//硬币与物品 绿宝石币
        ['composite_material:dungeon_steel_ingot', 3],//复合材料 地牢钢锭
        ['terramity:daemonium_chunk', 3],//terramity 恶魔碎块
        ['farmersdelight:ham',3],//农夫乐事 火腿
        ['immortalers_delight:golden_kwat_toast_slice',3],//千古乐事 金瓦斯麦吐司碎片
        ['midashunger:cooked_golden_porkchop',3],//食物与饮品 金熟猪排
    ]
    let lootItem = [
        ['minecraft:netherite_ingot', 0.3],//下界合金锭
        ['brewinandchewin:scarlet_cheese_wheel',0.2],//饮酒作乐 绯红奶酪轮
        [Item.of('minecraft:netherite_pickaxe', "{Damage:0,RepairCost:0,display:{Name:'{\"text\":\"jqka的馈赠\"}'}}").enchant('minecraft:unbreaking', 3).enchant('minecraft:efficiency', 4).enchant('minecraft:fortune', 1),0.3],//下界合金稿
    ]
    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('minecraft:chests/bastion_treasure')//堡垒遗迹宝藏室
            //随机抽取1-4次weightLootItem里面的参数
            .addWeightedLoot([2, 3], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('minecraft:chests/bastion_treasure')
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('minecraft:chests/bastion_treasure')//堡垒遗迹宝藏室
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})


//下界要塞
LootJS.modifiers(event => {//下界要塞
//定义删除物品,[物品id]
    let removeLoot = [
        ['minecraft:wither_rose'],//凋灵玫瑰
        ['minecraft:nether_wart'],//下界疣
        ['minecraft:lava_bucket'],//熔岩桶
        ['minecraft:flint_and_steel'],//打火石
        ['minecraft:golden_horse_armor'],//黄金马铠
        ['minecraft:diamond_horse_armor'],//钻石马铠
        ['minecraft:saddle'],//鞍
        ['minecraft:emerald'],//绿宝石
        ['ars_nouveau:sourceberry_bush'],//魔源浆果丛
        [Item.of('minecraft:golden_chestplate', '{Damage:0}')],//金胸甲
        [Item.of('minecraft:golden_sword', '{Damage:0}')],//金剑
        ['minecraft:iron_horse_armor'],//铁马恺
        [Item.of('minecraft:golden_shovel', '{Damage:0}')],//金铲
        ['composite_material:disenchanted_book'],//
        ['composite_material:enlightened_book'],//
        ['minecraft:iron_ingot'],//
        ['touhou_little_maid:power_point'],//
        [Item.of('minecraft:potion', '{Potion:"ars_nouveau:mana_regen_potion_long"}')],//
    ]

    //定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['netherdepthsupgrade:warped_kelp',10],//炽海生机 诡异海带
        ['netherdepthsupgrade:crimson_kelp',10],//炽海生机 绯红海带
        ['composite_material:dungeon_steel_ingot', 2],//复合材料 地牢钢锭
        ['mynethersdelight:strider_rock',10],//下界乐事 炽足兽岩壳蛋
        ['mynethersdelight:golden_egg',10],//下界乐事 金蛋
        ['lightmanscurrency:coin_gold',10],//硬币与物品 金币
    ]
    let lootItem = [
        ['minecraft:netherite_scrap', 0.3],//下界合金碎片
        ['enigmaticlegacy:darkest_scroll', 0.3],//神秘遗物 至暗卷轴
        ['mynethersdelight:enchanted_golden_egg', 0.2],//下界乐事 附魔金蛋
        ['mynethersdelight:nether_burger', 0.2],//下界乐事 下界汉堡
        ['mynethersdelight:strider_slice',0.4],//下界乐事 炽足兽肉片
    ]

    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('minecraft:chests/nether_bridge')//下界要塞
            //随机抽取2-4次weightLootItem里面的参数
            .addWeightedLoot([2, 4], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('minecraft:chests/nether_bridge')
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('minecraft:chests/nether_bridge')//下界要塞
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})

//沉船宝箱
LootJS.modifiers(event => {//沉船宝箱
//定义删除物品,[物品id]
    let removeLoot = [
        ['minecraft:iron_nugget'],//铁粒
        ['minecraft:gold_nugget'],//金粒
        ['minecraft:emerald'],//绿宝石
        ['minecraft:gold_ingot'],//金
        ['minecraft:iron_ingot'],//铁
        ['additionaladditions:rose_gold_upgrade'],//锻造模板
        [Item.of('beachparty:rubber_ring_pelican', '{Damage:0}')],//泳圈
        ['beachparty:overgrown_disc'],//唱片
        ['minecraft:coast_armor_trim_smithing_template'],//锻造模板
        ['minecraft:lapis_lazuli'],//青金石
        [Item.of('jellyfishing:jellyfish_net', '{Damage:0}')],//水母网
        ['supplementaries:globe'],//地球仪
        ['touhou_little_maid:power_point'],//p点
        ['supplementaries:globe'],//地球仪
    ]
//定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['alexsmobs:lobster_tail', 2],//龙虾尾
        ['crabbersdelight:clawster', 2],//龙虾
        ['crabbersdelight:crab', 2],//螃蟹
        ['minecraft:nautilus_shell',2],//鹦鹉螺壳
        ['bountifulfares:citrus_essence',2],//柑橘精华
        ['lightmanscurrency:coin_gold',1],//硬币与物品 金币
        ['minecraft:sea_pickle',2],//海泡菜
    ]
    let lootItem = [
        ['crabbersdelight:kelp_shake', 0.3],//蟹农乐事 海带奶昔
        ['collectorsreap:lunar_pearl',0.05],//collectors reap  月光珍珠
        ['crabbersdelight:sea_pickle_juice',0.3],//蟹农乐事 海泡菜汁
        ['vanillacookbook:stuffed_sea_pickle', 0.2],//原版烹饪书 填馅海泡菜
        ['confluence:ancient_chisel',0.1],//泰拉饰品 远古凿子

    ]
    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('minecraft:chests/shipwreck_treasure')//沉船宝箱
            //随机抽取2-4次weightLootItem里面的参数
            .addWeightedLoot([2, 3], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('minecraft:chests/shipwreck_treasure')
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('minecraft:chests/shipwreck_treasure')//沉船宝箱
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})


//小型水下废墟
LootJS.modifiers(event => {//小型水下废墟
        //定义删除物品,[物品id]
    let removeLoot = [
        ['minecraft:coal'],//煤炭
        ['minecraft:stone_axe'],//石斧
        ['minecraft:wheat'],//小麦
        ['minecraft:rotten_flesh'],//腐肉
        ['minecraft:leather_chestplate'],//皮革外套
        ['minecraft:leather'],//皮革
        ['minecraft:iron_nugget'],//铁粒
        ['minecraft:gold_nugget'],//金粒
        ['minecraft:emerald'],//绿宝石
        ['minecraft:gold_ingot'],//金
        ['minecraft:iron_ingot'],//铁
        ['additionaladditions:rose_gold_upgrade'],//锻造模板
        [Item.of('beachparty:rubber_ring_pelican', '{Damage:0}')],//泳圈
        ['beachparty:overgrown_disc'],//唱片
        ['minecraft:coast_armor_trim_smithing_template'],//锻造模板
        ['minecraft:lapis_lazuli'],//青金石
        ['rustic_engineer:book_abyssal_submarine'],//书
        ['ars_nouveau:pierce_arrow'],//箭
        [Item.of('minecraft:potion', '{Potion:"ars_nouveau:mana_regen_potion"}')],//药水
        ['ars_nouveau:amplify_arrow'],//强化箭
        ['supplementaries:globe'],//地球仪
    ]
    //定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['alexsmobs:lobster_tail', 3],//龙虾尾
        ['crabbersdelight:clawster', 3],//龙虾
        ['crabbersdelight:crab', 3],//螃蟹
        ['minecraft:nautilus_shell',3],//鹦鹉螺壳
        ['lightmanscurrency:coin_gold',3],//硬币与物品 金币
        ['minecraft:sea_pickle',5],//海泡菜
        ['kitchenkarrot:kelp_with_sunflower_seed',3],//胡萝卜厨房 爪子海带干
        ['kitchenkarrot:crispy_bread_with_kelp',1],//胡萝卜厨房 酥脆海带面包
        ['vanillacookbook:kelp_salad',1],//原版烹饪书 凉拌海带
    ]
    let lootItem = [
        ['crabbersdelight:kelp_shake', 0.3],//蟹农乐事 海带奶昔
        ['collectorsreap:lunar_pearl',0.1],//collectors reap  月光珍珠
        ['crabbersdelight:sea_pickle_juice',0.3],//蟹农乐事 海泡菜汁
        ['aquaculture:neptunium_ingot', 0.1],//水产 海王锭
        ['minecraft:turtle_egg',0.4]//海龟蛋

    ]
    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('minecraft:chests/underwater_ruin_small')//小型水下废墟
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([2, 3], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('minecraft:chests/underwater_ruin_small')
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('minecraft:chests/underwater_ruin_small')//小型水下废墟
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})
//大型水下废墟
LootJS.modifiers(event => {//大型水下废墟
    //定义删除物品,[物品id]
    let removeLoot = [
        ['minecraft:coal'],//煤炭
        ['minecraft:stone_axe'],//石斧
        ['minecraft:wheat'],//小麦
        ['minecraft:rotten_flesh'],//腐肉
        ['minecraft:leather_chestplate'],//皮革外套
        ['minecraft:leather'],//皮革
        ['minecraft:iron_nugget'],//铁粒
        ['minecraft:gold_nugget'],//金粒
        ['minecraft:emerald'],//绿宝石
        ['minecraft:gold_ingot'],//金
        ['minecraft:iron_ingot'],//铁
        ['additionaladditions:rose_gold_upgrade'],//锻造模板
        [Item.of('beachparty:rubber_ring_pelican', '{Damage:0}')],//泳圈
        ['beachparty:overgrown_disc'],//唱片
        ['minecraft:coast_armor_trim_smithing_template'],//锻造模板
        ['minecraft:lapis_lazuli'],//青金石
        ['rustic_engineer:book_abyssal_submarine'],//书
        ['ars_nouveau:pierce_arrow'],//箭
        [Item.of('minecraft:potion', '{Potion:"ars_nouveau:mana_regen_potion"}')],//药水
        ['ars_nouveau:amplify_arrow'],//强化箭
        ['supplementaries:globe'],//地球仪
    ]
    //定义添加权重物品[物品id,概率]
    let weightLootItem = [['alexsmobs:lobster_tail', 3],//龙虾尾
        ['crabbersdelight:clawster', 2],//龙虾
        ['crabbersdelight:crab', 3],//螃蟹
        ['minecraft:nautilus_shell',3],//鹦鹉螺壳
        ['lightmanscurrency:coin_gold',2],//硬币与物品 金币
        ['minecraft:sea_pickle',5],//海泡菜
        ['kitchenkarrot:kelp_with_sunflower_seed',3],//胡萝卜厨房 爪子海带干
        ['kitchenkarrot:crispy_bread_with_kelp',1],//胡萝卜厨房 酥脆海带面包
        ['vanillacookbook:kelp_salad',1],//原版烹饪书 凉拌海带
    ]
    let lootItem = [
        ['crabbersdelight:kelp_shake', 0.3],//蟹农乐事 海带奶昔
        ['collectorsreap:lunar_pearl',0.1],//collectors reap  月光珍珠
        ['crabbersdelight:sea_pickle_juice',0.3],//蟹农乐事 海泡菜汁
        ['aquaculture:neptunium_ingot', 0.1],//水产 海王锭
        ['minecraft:turtle_egg',0.4]//海龟蛋

    ]
    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('minecraft:chests/underwater_ruin_big')//大型水下废墟
            //随机抽取2-3次weightLootItem里面的参数
            .addWeightedLoot([3, 4], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('minecraft:chests/underwater_ruin_big')
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('minecraft:chests/underwater_ruin_big')//大型水下废墟
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})


//沙漠神殿
LootJS.modifiers(event => {//沙漠神殿
    //定义删除物品,[物品id]
    let removeLoot = [
        ['minecraft:sand'],//沙子
        ['minecraft:leather'],//皮革
        ['minecraft:rotten_flesh'],//腐肉
        ['minecraft:arrow'],//箭
        ['minecraft:bone'],//骨头
        ['minecraft:gunpowder'],//火药
        ['minecraft:spider_eye'],//蜘蛛眼
        ['minecraft:string'],//线
        ['minecraft:pumpkin_pie'],//南瓜派
        ['minecraft:gold_ingot'],//金
        [Item.of('minecraft:potion', '{Potion:"ars_nouveau:mana_regen_potion_long"}')],//药水
    ]
    //定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['beachparty:icecream_cactus', 2],//海滩派对 仙人掌棒冰 
        ['delightful:cactus_flesh', 3],//农夫乐事 仙人掌肉
        ['vanillacookbook:cactus_soda', 1],//原版烹饪书 仙人掌汽水
        ['delightful:prickly_pear_juice', 1],//农夫乐事 仙人掌果汁
        ['lightmanscurrency:coin_gold',1],//硬币与物品 金币
        ['ecologics:prickly_pear',3],//丰富生态 仙人掌果
    ]
    let lootItem = [
        ['natures_spirit:desert_turnip',0.2],//自然之灵 沙漠芜菁
        ['delightful:cactus_chili',0.1],//农夫乐事 辣子仙人掌
        ['delightful:cactus_soup',0.1],//农夫乐事 仙人掌汤
        ['enigmaticlegacy:darkest_scroll', 0.1],//神秘遗物 至暗卷轴
    ]

    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('minecraft:chests/desert_pyramid')//沙漠神殿
            //随机抽取2-3次weightLootItem里面的参数
            .addWeightedLoot([2, 3], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('minecraft:chests/desert_pyramid')
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('minecraft:chests/desert_pyramid')//沙漠神殿
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})


//末地城
LootJS.modifiers(event => {//末地城
    //定义删除物品,[物品id]
    let removeLoot = [
        ['minecraft:beetroot_seeds'],//甜菜种子
        ['minecraft:iron_ingot'],//铁锭
        ['minecraft:gold_ingot'],//金锭
        ['minecraft:iron_horse_armor'],//铁马铠
        ['minecraft:golden_carrot'],//金胡萝卜
        ['minecraft:glistering_melon_slice'],//金西瓜
        ['touhou_little_maid:power_point'],//P点
        ['minecraft:saddle'],//鞍
        ['minecraft:cake'],//蛋糕
        ['minecraft:iron_pickaxe'],//铁镐
        ['minecraft:iron_shovel'],//铁铲
        ['minecraft:iron_sword'],//铁剑
        ['minecraft:iron_helmet'],//铁头盔
        ['minecraft:iron_chestplate'],//铁胸甲
        ['minecraft:iron_leggings'],//铁护腿
        ['minecraft:iron_boots'],//铁靴
        ['minecraft:enchanting_table'],//附魔台
        ['minecraft:ender_eye'],//末影之眼
        ['minecraft:ender_pearl'],//末影珍珠
        ['touhou_little_maid:shrine'],//神龛
        ['simplyswords:runic_tablet'],//符文石板
        ['enigmaticlegacy:recall_potion'],//召回药水
        ['minecraft:phantom_membrane'],//幻翼膜
        ['minecraft:diamond_horse_armor'],//钻石马铠
        ['enigmaticlegacy:lore_inscriber'],//设计师的墨水
        ['minecraft:golden_horse_armor'],//金马铠
        ['enigmaticlegacy:void_pearl'],
        ['enigmaticlegacy:eye_of_nebula'],
        ['simplyswords:sword_on_a_stick'],//一把奇怪的武器
        ['minecraft:diamond_helmet'],//钻石头盔
        ['minecraft:diamond_chestplate'],//钻石胸甲
        ['minecraft:diamond_leggings'],//钻石护腿
        ['minecraft:diamond_boots'],//钻石靴
        ['minecraft:diamond_pickaxe'],//钻石镐
        ['minecraft:diamond_shovel'],//钻石铲
        ['minecraft:diamond_sword'],//钻石剑
        ['ars_nouveau:pierce_arrow'],//法术箭
        ['minecraft:diamond']//钻石
    ]

    //定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['minecraft:chorus_fruit',20],//紫颂果
        ['enigmaticlegacy:astral_dust', 5],//神秘遗物 星尘
        ['exquisito:chorus_gummy',5],//食物与饮品 紫颂果软糖
        ['exquisito:chorus_ice_cream',5],//食物与饮品 紫颂果冰激凌
        ['ends_delight:chorus_succulent',20],//末地乐事 末地多肉植物
        ['ends_delight:chorus_cookie',10],//末地乐事 紫颂曲奇
        ['lightmanscurrency:coin_gold',10],//硬币与物品 金币
    ]
    let lootItem = [
        ['enigmaticlegacy:etherium_ore', 0.2],//神秘遗物 以太矿石
        ['ends_delight:dragon_breath_and_chorus_soup',0.2],//末地乐事 龙息紫颂汤
        ['kitchenkarrot:chorus_mousse',0.2],//胡罗卜厨房 紫颂果慕斯
        ['minecraft:dragon_breath',0.4],//龙息
        ['terramity:raw_cosmilite',0.2],
        ['terramity:untapped_dimlite',0.2],
        ['terramity:gaianite_cluster',0.2],
    ]
    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('minecraft:chests/end_city_treasure')//末地城
            //随机抽取1-3次weightLootItem里面的参数
            .addWeightedLoot([2, 3], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('minecraft:chests/end_city_treasure')
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('minecraft:chests/end_city_treasure')//末地城
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})


//雪屋
LootJS.modifiers(event => {//雪屋
    //定义删除物品,[物品id]
    let removeLoot = [
        ['minecraft:string'],//线
        ['minecraft:arrow'],//箭
        ['minecraft:gold_nugget'],//金粒
        ['minecraft:spectral_arrow'],//光灵箭
        ['minecraft:iron_nugget'],//铁粒
        ['minecraft:chain'],//锁链
        ['minecraft:lava_bucket'],//熔岩桶
        ['minecraft:crossbow'],//弩
        ['minecraft:obsidian'],//黑曜石
        ['minecraft:bone_block'],//骨块
        ['minecraft:coal'],//煤炭
        ['minecraft:leather'],//皮革
        ['minecraft:wheat'],//小麦
    ]
    //定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['farmersdelight:melon_popsicle', 2],//西瓜冰棍
        ['aquamirae:wisteria_niveis', 2],
        ['aquamirae:oxygelium', 2],
        ['farmersdelight:melon_juice', 2],//西瓜汁
        ['twilightdelight:twilight_spring', 1],//暮色山泉
        ['lightmanscurrency:coin_gold',1],//硬币与物品 金币
    ]

    let lootItem = [
        ['manors_bounty:vanilla_chocolate_ice_cream', 0.2],//庄园馀事 经典双拼冰激凌
        ['manors_bounty:starfruit_ice_cream', 0.2],//庄园馀事 杨桃冰激凌
        ['manors_bounty:vanilla_ice_cream',0.2],//庄园馀事 香草冰激凌
        ['manors_bounty:chocolate_ice_cream',0.2],//庄园馀事 巧克力冰激凌
        ['manors_bounty:blueberry_ice_cream',0.2],//庄园馀事 蓝莓冰激凌
        ['manors_bounty:cherries_ice_cream',0.2],//庄园馀事 车厘子冰激凌
        ['manors_bounty:jalapeno_ice_cream',0.2],//庄园馀事 墨西哥辣椒冰激凌
        ['manors_bounty:blueberry_cherries_ice_cream',0.2],//庄园馀事 莓果双拼冰激凌
        ['manors_bounty:starfruit_jalapeno_ice_cream',0.2],//庄园馀事 命运双拼冰激凌
    ]
    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('minecraft:chests/igloo_chest')//雪屋
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([2, 3], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('minecraft:chests/igloo_chest')
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('minecraft:chests/igloo_chest')//雪屋
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})


//极光宫殿
LootJS.modifiers(event => {//极光宫殿
    //定义删除物品,[物品id]
    let removeLoot = [
        ['minecraft:coal'],//煤炭
        ['touhou_little_maid:shrine'],//神龛
        ['touhou_little_maid:power_point'],//P点
        ['minecraft:stick'],//木棍
        ['minecraft:arrow'],//箭
        ['minecraft:sugar_cane'],//甘蔗
        ['minecraft:packed_ice'],//浮冰
        ['minecraft:ice'],//冰
        ['minecraft:sand'],//沙子
        ['twilightforest:firefly'],//萤火虫
        ['minecraft:wheat_seeds'],//小麦种子
        ['minecraft:bone_meal'],//骨粉
        ['minecraft:flint'],//燧石
    ]
        //定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['16x twilightforest:aurora_block', 5],//暮色森林 极光方块
        ['aquamirae:wisteria_niveis', 5],
        ['aquamirae:oxygelium', 5],
        ['twilightdelight:twilight_spring', 3],//暮色乐事 暮色山泉
        ['twilightdelight:glacier_ice_tea',1],//暮色乐事 冰川冰茶
        ['twilightdelight:glacier_milkshake',1],//暮色乐事 冰川奶昔
        ['lightmanscurrency:coin_gold',1],//硬币与物品 金币
    ]
    let lootItem = [
        ['twilightdelight:aurora_cake_slice',0.05],//暮色乐事 极光蛋糕切片
        ['twilightdelight:aurora_ice_cream',0.2],//暮色乐事 极光冰激凌
        ['arsdelight:arch_sauce',0.1],//新生乐事 至高酱
    ]

    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('twilightforest:chests/aurora_cache')//极光宫殿
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([2, 3], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('twilightforest:chests/aurora_cache')
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('twilightforest:chests/aurora_cache')//极光宫殿
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})


//极光宫殿2
LootJS.modifiers(event => {//极光宫殿
        //定义删除物品,[物品id]
    let removeLoot = [
        ['minecraft:coal'],//煤炭
        ['touhou_little_maid:shrine'],//神龛
        ['touhou_little_maid:power_point'],//P点
        ['minecraft:stick'],//木棍
        ['minecraft:arrow'],//箭
        ['minecraft:sugar_cane'],//甘蔗
        ['minecraft:packed_ice'],//浮冰
        ['minecraft:ice'],//冰
        ['minecraft:sand'],//沙子
        ['twilightforest:firefly'],//萤火虫
        ['minecraft:wheat_seeds'],//小麦种子
        ['minecraft:bone_meal'],//骨粉
        ['minecraft:flint'],//燧石
        ['twilightforest:arctic_helmet'],//极地帽子
        ['twilightforest:arctic_leggings'],//极地护腿
        ['twilightforest:arctic_boots'],//极地靴子
    ]
       
        //定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['16x twilightforest:aurora_block', 5],//暮色森林 极光方块
        ['twilightdelight:twilight_spring', 3],//暮色乐事 暮色山泉
        ['twilightdelight:glacier_ice_tea',1],//暮色乐事 冰川冰茶
        ['twilightdelight:glacier_milkshake',1],//暮色乐事 冰川奶昔
        ['lightmanscurrency:coin_gold',1],//硬币与物品 金币
    ]
    let lootItem = [
        ['twilightdelight:aurora_cake_slice',0.05],//暮色乐事 极光蛋糕切片
        ['twilightdelight:aurora_ice_cream',0.2],//暮色乐事 极光冰激凌
        ['arsdelight:arch_sauce',0.1],//新生乐事 至高酱
    ]

    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('twilightforest:chests/aurora_room')//极光宫殿2
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([2, 3], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('twilightforest:chests/aurora_room')
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('twilightforest:chests/aurora_room')//极光宫殿2
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})


//幽冥高塔
LootJS.modifiers(event => {//幽冥高塔
    //定义删除物品,[物品id]
    let removeLoot = [
        ['minecraft:coal'],//煤炭
        ['touhou_little_maid:shrine'],//神龛
        ['touhou_little_maid:power_point'],//P点
        ['minecraft:stick'],//木棍
        ['minecraft:arrow'],//箭
        ['minecraft:sugar_cane'],//甘蔗
        ['minecraft:packed_ice'],//浮冰
        ['minecraft:ice'],//冰
        ['minecraft:sand'],//沙子
        ['twilightforest:firefly'],//萤火虫
        ['minecraft:wheat_seeds'],//小麦种子
        ['minecraft:bone_meal'],//骨粉
        ['minecraft:flint'],//燧石
        ['twilightforest:arctic_helmet'],//极地帽子
        ['twilightforest:arctic_leggings'],//极地护腿
        ['twilightforest:arctic_boots'],//极地靴子
        ['minecraft:red_wool'],//红色羊毛
        ['minecraft:charcoal'],//木炭
        ['minecraft:redstone'],//红石粉
        ['minecraft:dandelion'],//蒲公英
        ['minecraft:redstone_lamp'],//红石灯
    ]
    //定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['mynethersdelight:ghasta', 3],//下界乐事 恶魂意面
        ['twilightforest:borer_essence', 5],//暮色森林 蛀虫精华
        ['mynethersdelight:ghasmati', 3],//下界乐事 恶魂长米
        ['twilightforest:experiment_115',1],//暮色乐事 试验品115
        ['twilightdelight:experiment_113',1],//暮色乐事 试验品113
        ['lightmanscurrency:coin_gold',1],//硬币与物品 金币
    ]
   let lootItem = [
        ['twilightdelight:glow_113', 0.2],//暮色乐事 113蘸荧光堡
        ['twilightdelight:milky_113', 0.2],//暮色乐事 113蘸炼乳
        ['twilightdelight:chocolate_113', 0.2],//暮色乐事 113蘸巧克力
        ['twilightdelight:honey_113', 0.2],//暮色乐事 113蘸蜂蜜
        ['twilightdelight:experiment_110', 0.05],//暮色乐事 试验品110
        ['dungeonsdelight:ghastly_spirits', 0.3],//地牢乐事 恶魂烈酒
        ['twilightdelight:tear_drink', 0.2],//暮色乐事 营泪之饮
        ['arsdelight:arch_sauce',0.1],//新生乐事 至高酱
        ['dungeonsdelight:tower_boreito',0.1],//地牢乐事 高塔蛀虫卷饼
    ]
    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('twilightforest:chests/darktower_cache')//幽冥高塔
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([2, 3], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('twilightforest:chests/darktower_cache')
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('twilightforest:chests/darktower_cache')//幽冥高塔
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})


//树篱迷宫
LootJS.modifiers(event => {//树篱迷宫
    //定义删除物品,[物品id]
    let removeLoot = [
        ['touhou_little_maid:shrine'],//神龛
        ['touhou_little_maid:power_point'],//P点
        ['minecraft:stick'],//木棍
        ['minecraft:arrow'],//箭
        ['twilightforest:firefly'],//萤火虫
        ['minecraft:wheat_seeds'],//小麦种子
        ['minecraft:dandelion'],//蒲公英
        ['minecraft:shears'],//剪刀
        ['minecraft:melon_seeds'],//西瓜种子
        ['minecraft:pumpkin_seeds'],//南瓜种子
        ['minecraft:cactus'],//仙人掌
        ['minecraft:poppy'],//虞美人
        ['minecraft:oak_planks'],//橡木木板
        ['minecraft:red_mushroom'],//红蘑菇
        ['minecraft:brown_mushroom'],//棕蘑菇
        ['minecraft:wheat'],//小麦
        ['minecraft:bow'],//弓
        ['minecraft:saddle'],//马鞍
        ['minecraft:apple'],//苹果
        ['minecraft:melon_slice'],//西瓜
        ['minecraft:mushroom_stew'],//蘑菇煲
        ['minecraft:flower_pot'],//花盆
        ['minecraft:cobweb'],//蜘蛛网
        ['minecraft:sugar_cane'],//甘蔗
    ]
//定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['minecraft:torchflower_seeds', 5],//火把花种子
        ['dungeonsdelight:spider_meat',3],//地牢乐事 蜘蛛肉
        ['dungeonsdelight:bug_chops',3],//地牢乐事 虫肉排
        ['twilightdelight:raw_insect',3],//暮色乐事 生虫肉
        ['lightmanscurrency:coin_gold',1],//硬币与物品 金币
    ]
    let lootItem = [
        ['twilightdelight:berry_stick', 0.3],//暮色乐事 浆果串
        ['dungeonsdelight:spider_extract', 0.4],//地牢乐事 蜘蛛提取物
        ['dungeonsdelight:spider_donut', 0.3],//地牢乐事 蜘蛛甜甜圈
        ['arsdelight:arch_sauce',0.1],//新生乐事 至高酱
        ['dungeonsdelight:maze_roll',0.2]//地牢乐事 迷宫寿司
    ]
    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('twilightforest:chests/hedge_maze')//树篱迷宫
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([3, 4], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('twilightforest:chests/hedge_maze')
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('twilightforest:chests/hedge_maze')//树篱迷宫
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})


//幻影骑士要塞
LootJS.modifiers(event => {//幻影骑士要塞
    //定义删除物品,[物品id]
    let removeLoot = [
        ['touhou_little_maid:shrine'],//神龛
        ['touhou_little_maid:power_point'],//P点
        ['minecraft:stick'],//木棍
        ['minecraft:arrow'],//箭
        ['twilightforest:firefly'],//萤火虫
        ['minecraft:bow'],//弓
        ['minecraft:coal'],//煤炭
        ['twilightforest:steeleaf_sword'],//钢叶剑
        ['minecraft:bucket'],//桶
        ['minecraft:blue_wool'],//蓝色羊毛
        ['minecraft:iron_ingot'],//铁锭
        ['minecraft:iron_sword'],//铁剑
        ['twilightforest:ironwood_sword'],//铁木剑
    ]
    //定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['minecraft:torchflower_seeds', 5],//火把花种子
        ['dungeonsdelight:spider_meat',3],//地牢乐事 蜘蛛肉
        ['dungeonsdelight:bug_chops',3],//地牢乐事 虫肉排
        ['twilightdelight:raw_insect',3],//暮色乐事 生虫肉
        ['twilightforest:steeleaf_ingot',2],//暮色森林 钢叶
        ['twilightforest:knightmetal_ingot',1],//暮色森林 骑士金属锭
        ['lightmanscurrency:coin_gold',1],//硬币与物品 金币
    ]
    let lootItem = [
        ['dungeonsdelight:maze_roll', 0.2],//地牢乐事 迷宫寿司
        ['arsdelight:arch_sauce',0.1],//新生乐事 至高酱
        ['twilightdelight:mushgloom_sauce', 0.2],//暮色乐事 荧光蘑菇酱   
    ]

    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('twilightforest:chests/stronghold_cache')//幻影骑士要塞
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([2, 3], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('twilightforest:chests/stronghold_cache')
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('twilightforest:chests/stronghold_cache')//幻影骑士要塞
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})
//幻影骑士要塞2
LootJS.modifiers(event => {//幻影骑士要塞2
    //定义删除物品,[物品id]
    let removeLoot = [
        ['touhou_little_maid:shrine'],//神龛
        ['touhou_little_maid:power_point'],//P点
        ['minecraft:stick'],//木棍
        ['minecraft:arrow'],//箭
        ['twilightforest:firefly'],//萤火虫
        ['minecraft:bow'],//弓
        ['minecraft:coal'],//煤炭
        ['twilightforest:steeleaf_sword'],//钢叶剑
        ['minecraft:bucket'],//桶
        ['minecraft:blue_wool'],//蓝色羊毛
        ['minecraft:iron_ingot'],//铁锭
        ['minecraft:iron_sword'],//铁剑
        ['twilightforest:ironwood_sword'],//铁木剑
        ['minecraft:dandelion'],//蒲公英
        ['minecraft:gunpowder'],//火药
        ['minecraft:milk_bucket'],//奶桶
        ['twilightforest:ironwood_chestplate'],//铁木胸甲
        ['twilightforest:steeleaf_pickaxe'],//钢叶稿
        ['twilightforest:steeleaf_helmet'],//钢叶头盔
        ['twilightforest:steeleaf_chestplate'],//钢叶胸甲
        ['twilightforest:steeleaf_leggings'],//钢叶护腿
        ['twilightforest:steeleaf_boots'],//钢叶靴子
        ['minecraft:diamond_sword'],//钻石剑
        ['minecraft:sugar_cane'],//甘蔗
        ['minecraft:bone_meal'],//骨粉
        ['minecraft:flint'],//燧石
        ['minecraft:flint'],//小麦种子
        ['minecraft:sand'],//沙子
        ['minecraft:poppy'],//虞美人
    ]
    //定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['minecraft:torchflower_seeds', 5],//火把花种子
        ['dungeonsdelight:spider_meat',3],//地牢乐事 蜘蛛肉
        ['dungeonsdelight:bug_chops',3],//地牢乐事 虫肉排
        ['twilightdelight:raw_insect',3],//暮色乐事 生虫肉
        ['twilightforest:steeleaf_ingot',2],//暮色森林 钢叶
        ['twilightforest:knightmetal_ingot',1],//暮色森林 骑士金属锭
        ['lightmanscurrency:coin_gold',1],//硬币与物品 金币
    ]
    let lootItem = [
        ['dungeonsdelight:maze_roll', 0.1],//地牢乐事 迷宫寿司
        ['arsdelight:arch_sauce',0.1],//新生乐事 至高酱
        ['twilightdelight:mushgloom_sauce', 0.2],//暮色乐事 荧光蘑菇酱   
    ]
    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('twilightforest:chests/stronghold_room')//幻影骑士要塞2
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([2, 3], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('twilightforest:chests/stronghold_room')
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('twilightforest:chests/stronghold_room')//幻影骑士要塞2
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})


//牛头人迷宫
LootJS.modifiers(event => {//牛头人迷宫
    //定义删除物品,[物品id]
    let removeLoot = [
        ['touhou_little_maid:shrine'],//神龛
        ['touhou_little_maid:power_point'],//P点
        ['minecraft:stick'],//木棍
        ['minecraft:arrow'],//箭
        ['twilightforest:firefly'],//萤火虫
        ['minecraft:bow'],//弓
        ['minecraft:coal'],//煤炭
        ['twilightforest:steeleaf_sword'],//钢叶剑
        ['minecraft:bucket'],//桶
        ['minecraft:blue_wool'],//蓝色羊毛
        ['minecraft:iron_ingot'],//铁锭
        ['minecraft:iron_sword'],//铁剑
        ['twilightforest:ironwood_sword'],//铁木剑
        ['minecraft:dandelion'],//蒲公英
        ['minecraft:gunpowder'],//火药
        ['minecraft:milk_bucket'],//奶桶
        ['twilightforest:ironwood_chestplate'],//铁木胸甲
        ['twilightforest:steeleaf_pickaxe'],//钢叶稿
        ['twilightforest:steeleaf_helmet'],//钢叶头盔
        ['twilightforest:steeleaf_chestplate'],//钢叶胸甲
        ['twilightforest:steeleaf_leggings'],//钢叶护腿
        ['twilightforest:steeleaf_boots'],//钢叶靴子
        ['minecraft:diamond_sword'],//钻石剑
        ['minecraft:sugar_cane'],//甘蔗
        ['minecraft:bone_meal'],//骨粉
        ['minecraft:flint'],//燧石
        ['minecraft:flint'],//小麦种子
        ['minecraft:sand'],//沙子
        ['minecraft:poppy'],//虞美人
        ['minecraft:mushroom_stew'],//蘑菇包
        ['minecraft:paper'],//纸
        ['twilightforest:red_thread'],//红线
        ['minecraft:leather'],//皮革
        ['twilightforest:steeleaf_axe'],//钢叶斧
        ['twilightforest:steeleaf_shovel'],//钢叶铲
        ['minecraft:ender_chest'],//末影箱
        ['minecraft:tnt'],//TNT
        ['minecraft:cactus'],//仙人掌
    ]
    //定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['twilightforest:mushgloom', 3],//暮色森林 荧光蘑菇
        ['minecraft:brown_mushroom', 5],//棕色蘑菇
        ['minecraft:red_mushroom', 5],//红色蘑菇
        ['twilightdelight:raw_tomahawk_smeak', 1],//暮色乐事 生战斧牛头人肋排
        ['twilightforest:raw_meef', 3],//暮色森林 生牛头人肉
        ['lightmanscurrency:coin_gold',1],//硬币与物品 金币
    ]
    let lootItem = [
        ['twilightdelight:mushgloom_sauce', 0.2],//暮色乐事 荧光蘑菇酱
        ['farmersdelight:mushroom_rice', 0.2],//农夫乐事 蘑菇饭
        ['arsdelight:arch_sauce',0.1],//新生乐事 至高酱
        ['dungeonsdelight:maze_roll',0.1],//地牢乐事 迷宫寿司
    ]
    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('twilightforest:chests/labyrinth_dead_end')//牛头人迷宫
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([2, 3], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('twilightforest:chests/labyrinth_dead_end')
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('twilightforest:chests/labyrinth_dead_end')//牛头人迷宫
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})


//牛头人迷宫2
LootJS.modifiers(event => {//牛头人迷宫2
    //定义删除物品,[物品id]
    let removeLoot = [
        ['touhou_little_maid:shrine'],//神龛
        ['touhou_little_maid:power_point'],//P点
        ['minecraft:stick'],//木棍
        ['minecraft:arrow'],//箭
        ['twilightforest:firefly'],//萤火虫
        ['minecraft:bow'],//弓
        ['minecraft:coal'],//煤炭
        ['twilightforest:steeleaf_sword'],//钢叶剑
        ['minecraft:bucket'],//桶
        ['minecraft:blue_wool'],//蓝色羊毛
        ['minecraft:iron_ingot'],//铁锭
        ['minecraft:iron_sword'],//铁剑
        ['twilightforest:ironwood_sword'],//铁木剑
        ['minecraft:dandelion'],//蒲公英
        ['minecraft:gunpowder'],//火药
        ['minecraft:milk_bucket'],//奶桶
        ['twilightforest:ironwood_chestplate'],//铁木胸甲
        ['twilightforest:steeleaf_pickaxe'],//钢叶稿
        ['twilightforest:steeleaf_helmet'],//钢叶头盔
        ['twilightforest:steeleaf_chestplate'],//钢叶胸甲
        ['twilightforest:steeleaf_leggings'],//钢叶护腿
        ['twilightforest:steeleaf_boots'],//钢叶靴子
        ['minecraft:diamond_sword'],//钻石剑
        ['minecraft:sugar_cane'],//甘蔗
        ['minecraft:bone_meal'],//骨粉
        ['minecraft:flint'],//燧石
        ['minecraft:flint'],//小麦种子
        ['minecraft:sand'],//沙子
        ['minecraft:poppy'],//虞美人
        ['minecraft:mushroom_stew'],//蘑菇包
        ['minecraft:paper'],//纸
        ['twilightforest:red_thread'],//红线
        ['minecraft:leather'],//皮革
        ['twilightforest:steeleaf_axe'],//钢叶斧
        ['twilightforest:steeleaf_shovel'],//钢叶铲
        ['minecraft:ender_chest'],//末影箱
        ['minecraft:tnt'],//TNT
        ['minecraft:cactus'],//仙人掌
    ]
    //定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['twilightforest:mushgloom', 3],//暮色森林 荧光蘑菇
        ['minecraft:brown_mushroom', 5],//棕色蘑菇
        ['minecraft:red_mushroom', 5],//红色蘑菇
        ['twilightdelight:raw_tomahawk_smeak', 1],//暮色乐事 生战斧牛头人肋排
        ['twilightforest:raw_meef', 3],//暮色森林 生牛头人肉
        ['lightmanscurrency:coin_gold',1],//硬币与物品 金币
    ]
    let lootItem = [
        ['twilightdelight:mushgloom_sauce', 0.3],//暮色乐事 荧光蘑菇酱
        ['farmersdelight:mushroom_rice', 0.3],//农夫乐事 蘑菇饭
        ['arsdelight:arch_sauce',0.1],//新生乐事 至高酱
        ['dungeonsdelight:maze_roll',0.2],//地牢乐事 迷宫寿司
    ]
    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('twilightforest:chests/labyrinth_room')//牛头人迷宫2
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([2, 3], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('twilightforest:chests/labyrinth_room')
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('twilightforest:chests/labyrinth_room')//牛头人迷宫2
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})


//牛头人迷宫3
LootJS.modifiers(event => {//牛头人迷宫3
    //定义删除物品,[物品id]
    let removeLoot = [
        ['touhou_little_maid:shrine'],//神龛
        ['touhou_little_maid:power_point'],//P点
        ['minecraft:stick'],//木棍
        ['minecraft:arrow'],//箭
        ['twilightforest:firefly'],//萤火虫
        ['minecraft:bow'],//弓
        ['minecraft:coal'],//煤炭
        ['twilightforest:steeleaf_sword'],//钢叶剑
        ['minecraft:bucket'],//桶
        ['minecraft:blue_wool'],//蓝色羊毛
        ['minecraft:iron_ingot'],//铁锭
        ['minecraft:iron_sword'],//铁剑
        ['twilightforest:ironwood_sword'],//铁木剑
        ['minecraft:dandelion'],//蒲公英
        ['minecraft:gunpowder'],//火药
        ['minecraft:milk_bucket'],//奶桶
        ['twilightforest:ironwood_chestplate'],//铁木胸甲
        ['twilightforest:steeleaf_pickaxe'],//钢叶稿
        ['twilightforest:steeleaf_helmet'],//钢叶头盔
        ['twilightforest:steeleaf_chestplate'],//钢叶胸甲
        ['twilightforest:steeleaf_leggings'],//钢叶护腿
        ['twilightforest:steeleaf_boots'],//钢叶靴子
        ['minecraft:diamond_sword'],//钻石剑
        ['minecraft:sugar_cane'],//甘蔗
        ['minecraft:bone_meal'],//骨粉
        ['minecraft:flint'],//燧石
        ['minecraft:flint'],//小麦种子
        ['minecraft:sand'],//沙子
        ['minecraft:poppy'],//虞美人
        ['minecraft:mushroom_stew'],//蘑菇包
        ['minecraft:paper'],//纸
        ['twilightforest:red_thread'],//红线
        ['minecraft:leather'],//皮革
        ['twilightforest:steeleaf_axe'],//钢叶斧
        ['twilightforest:steeleaf_shovel'],//钢叶铲
        ['minecraft:ender_chest'],//末影箱
        ['minecraft:tnt'],//TNT
        ['minecraft:cactus'],//仙人掌
    ]
    //定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['twilightforest:mushgloom', 3],//暮色森林 荧光蘑菇
        ['minecraft:brown_mushroom', 5],//棕色蘑菇
        ['minecraft:red_mushroom', 5],//红色蘑菇
        ['twilightdelight:raw_tomahawk_smeak', 1],//暮色乐事 生战斧牛头人肋排
        ['twilightforest:raw_meef', 3],//暮色森林 生牛头人肉
        ['lightmanscurrency:coin_gold',1],//硬币与物品 金币
    ]
    let lootItem = [
        ['twilightdelight:mushgloom_sauce', 0.3],//暮色乐事 荧光蘑菇酱
        ['farmersdelight:mushroom_rice', 0.3],//农夫乐事 蘑菇饭
        ['arsdelight:arch_sauce',0.1],//新生乐事 至高酱
        ['dungeonsdelight:maze_roll',0.2],//地牢乐事 迷宫寿司
    ]
    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('twilightforest:chests/labyrinth_vault')//牛头人迷宫3
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([2, 3], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('twilightforest:chests/labyrinth_vault')
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('twilightforest:chests/labyrinth_vault')//牛头人迷宫3
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})


//亡灵矿山
LootJS.modifiers(event => {//亡灵矿山
    //定义删除物品,[物品id]
    let removeLoot = [
        ['touhou_little_maid:shrine'],//神龛
        ['touhou_little_maid:power_point'],//P点
        ['minecraft:arrow'],//箭
        ['minecraft:dandelion'],//蒲公英
        ['minecraft:gunpowder'],//火药
        ['minecraft:sugar_cane'],//甘蔗
        ['minecraft:bone_meal'],//骨粉
        ['minecraft:flint'],//小麦种子
        ['minecraft:sand'],//沙子
        ['minecraft:torch'],//火把
        ['twilightforest:ironwood_pickaxe'],//铁木稿
        ['minecraft:pumpkin_pie'],//南瓜派
        ['twilightforest:steeleaf_ingot'],//钢叶
        ['minecraft:potato'],//马铃薯
        ['minecraft:gold_nugget'],//金粒
        ['minecraft:feather'],//羽毛
        ['minecraft:cod'],//鱼
        ['minecraft:wheat_seeds'],//小麦种子
        ['minecraft:cactus'],//仙人掌
        ['minecraft:flower_pot'],//花盆
    ]
     //定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['farmersdelight:bone_broth',5],//农夫乐事 大骨汤
        ['kaleidoscope_cookery:pork_bone_soup',3],//森罗物语 大骨汤
        ['terramity:daemonium_chunk',5],//terramity 恶魔碎块
        ['lightmanscurrency:coin_gold',1],//硬币与物品 金币
        ['lightmanscurrency:coin_iron',2],//硬币与物品 银币
        ['lightmanscurrency:coin_copper',3],//硬币与物品 铜币
    ]
    let lootItem = [
        ['confluence:royal_gel', 0.15],//皇家凝胶
        ['confluence:vitamins', 0.15],//维生素
        ['confluence:magiluminescence', 0.15],//魔光护符
        ['confluence:anklet_of_the_wind', 0.15],//疾风脚镯
        ['confluence:shark_tooth_necklace', 0.15],//鲨鱼项链
        ['confluence:bezoar', 0.15],//牛黄
        ['confluence:flashlight', 0.15],//手电筒
        ['confluence:blindfold', 0.15],//蒙眼布
        ['confluence:energy_bar', 0.15],//能量棒
        ['confluence:magma_skull', 0.15],//岩浆骷髅头
    ]
    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('twilightforest:chests/hill_3')//亡灵矿山
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([2, 3], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('twilightforest:chests/hill_3')
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('twilightforest:chests/hill_3')//亡灵矿山
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})


//巫妖塔
LootJS.modifiers(event => {//巫妖塔
    //定义删除物品,[物品id]
    let removeLoot = [
        ['touhou_little_maid:shrine'],//神龛
        ['touhou_little_maid:power_point'],//P点
        ['minecraft:arrow'],//箭
        ['minecraft:dandelion'],//蒲公英
        ['minecraft:gunpowder'],//火药
        ['minecraft:sugar_cane'],//甘蔗
        ['minecraft:bone_meal'],//骨粉
        ['minecraft:flint'],//小麦种子
        ['minecraft:sand'],//沙子
        ['minecraft:torch'],//火把
        ['twilightforest:ironwood_pickaxe'],//铁木稿
        ['minecraft:pumpkin_pie'],//南瓜派
        ['twilightforest:steeleaf_ingot'],//钢叶
        ['minecraft:potato'],//马铃薯
        ['minecraft:gold_nugget'],//金粒
        ['minecraft:feather'],//羽毛
        ['minecraft:cod'],//鱼
        ['minecraft:wheat_seeds'],//小麦种子
        ['minecraft:cactus'],//仙人掌
        ['minecraft:flower_pot'],//花盆
        ['minecraft:bow'],//弓
        ['minecraft:stone_sword'],//石剑
        ['minecraft:wooden_sword'],//木剑
        ['minecraft:iron_sword'],//铁剑
        ['minecraft:iron_leggings'],//铁护腿
        ['minecraft:paper'],//纸
        ['minecraft:ladder'],//梯子
        ['minecraft:fire_charge'],//火焰弹
        ['minecraft:map'],//地图
        ['minecraft:bone'],//骨头
        ['minecraft:clay_ball'],//黏土
        ['minecraft:glass_bottle'],//玻璃瓶
        ['minecraft:book'],//书
        ['minecraft:potion'],//水瓶
        ['minecraft:golden_pickaxe'],//金稿
    ]

     //定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['twilightforest:torchberries',5],//暮色森林 火炬浆果
        ['twilightforest:fiddlehead',2],//暮色森林 暮色蕨
        ['twilightdelight:torchberry_cookie',1],//暮色乐事 火炬浆果曲奇
        ['lightmanscurrency:coin_gold',1],//硬币与物品 金币
        ['arsdelight:neutralized_bombegrante_jam',1],//新生乐事 果酱
        ['arsdelight:activated_mendosteen_jam',1],//新生乐事 果酱
        ['arsdelight:activated_bastion_jam',1],//新生乐事 果酱
        ['arsdelight:neutralized_frostaya_jam',1],//新生乐事 果酱
    ]
    let lootItem = [
        ['twilightdelight:torchberry_cake_slice',0.3],//暮色乐事 火炬浆果蛋糕切片
        ['twilightdelight:torchberry_pie_slice',0.3],//暮色乐事 火炬浆果派切片
        ['arsdelight:arch_sauce',0.1],//新生乐事 至高酱
    ]
    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('twilightforest:chests/tower_library')//巫妖怪塔
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([2, 4], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('twilightforest:chests/tower_library')
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('twilightforest:chests/tower_library')//巫妖怪塔
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})


//工兵矿山   暮色森林
LootJS.modifiers(event => {//工兵矿山
    //定义删除物品,[物品id]
    let removeLoot = [
        ['touhou_little_maid:shrine'],//神龛
        ['touhou_little_maid:power_point'],//P点
        ['minecraft:arrow'],//箭
        ['minecraft:dandelion'],//蒲公英
        ['minecraft:gunpowder'],//火药
        ['minecraft:sugar_cane'],//甘蔗
        ['minecraft:bone_meal'],//骨粉
        ['minecraft:flint'],//小麦种子
        ['minecraft:sand'],//沙子
        ['minecraft:torch'],//火把
        ['twilightforest:ironwood_pickaxe'],//铁木稿
        ['minecraft:pumpkin_pie'],//南瓜派
        ['twilightforest:steeleaf_ingot'],//钢叶
        ['minecraft:potato'],//马铃薯
        ['minecraft:gold_nugget'],//金粒
        ['minecraft:feather'],//羽毛
        ['minecraft:cod'],//鱼
        ['minecraft:wheat_seeds'],//小麦种子
        ['minecraft:cactus'],//仙人掌
        ['minecraft:flower_pot'],//花盆
        ['minecraft:carrot'],//胡萝卜
        ['minecraft:baked_potato'],//烤马铃薯
        ['minecraft:bucket'],//桶
        ['minecraft:poppy'],//虞美人
        ['minecraft:ladder'],//梯子
    ]
     //定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['farmersdelight:bone_broth',2],//农夫乐事 大骨汤
        ['kaleidoscope_cookery:pork_bone_soup',1],//森罗物语 大骨汤
        ['terramity:daemonium_chunk',5],//terramity 恶魔碎块
        ['lightmanscurrency:coin_gold',1],//硬币与物品 金币
        ['lightmanscurrency:coin_iron',2],//硬币与物品 银币
        ['lightmanscurrency:coin_copper',3],//硬币与物品 铜币
    ]
    let lootItem = [
        ['confluence:royal_gel', 0.12],//皇家凝胶
        ['confluence:vitamins', 0.12],//维生素
        ['confluence:magiluminescence', 0.12],//魔光护符
        ['confluence:anklet_of_the_wind', 0.12],//疾风脚镯
        ['confluence:shark_tooth_necklace', 0.12],//鲨鱼项链
        ['confluence:bezoar', 0.12],//牛黄
        ['confluence:flashlight', 0.12],//手电筒
        ['confluence:blindfold', 0.12],//蒙眼布
        ['confluence:energy_bar', 0.12],//能量棒
        ['confluence:magma_skull', 0.12],//岩浆骷髅头
    ]
    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('twilightforest:chests/hill_2')//工兵矿山
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([2, 3], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('twilightforest:chests/hill_2')
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('twilightforest:chests/hill_2')//工兵矿山
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})


//空心矿山  暮色森林
LootJS.modifiers(event => {//空心矿山
     //定义删除物品,[物品id]
    let removeLoot = [
        ['touhou_little_maid:shrine'],//神龛
        ['touhou_little_maid:power_point'],//P点
        ['minecraft:arrow'],//箭
        ['minecraft:dandelion'],//蒲公英
        ['minecraft:gunpowder'],//火药
        ['minecraft:sugar_cane'],//甘蔗
        ['minecraft:bone_meal'],//骨粉
        ['minecraft:flint'],//小麦种子
        ['minecraft:sand'],//沙子
        ['minecraft:torch'],//火把
        ['twilightforest:ironwood_pickaxe'],//铁木稿
        ['minecraft:pumpkin_pie'],//南瓜派
        ['twilightforest:steeleaf_ingot'],//钢叶
        ['minecraft:potato'],//马铃薯
        ['minecraft:gold_nugget'],//金粒
        ['minecraft:feather'],//羽毛
        ['minecraft:cod'],//鱼
        ['minecraft:wheat_seeds'],//小麦种子
        ['minecraft:cactus'],//仙人掌
        ['minecraft:flower_pot'],//花盆
        ['minecraft:carrot'],//胡萝卜
        ['minecraft:baked_potato'],//烤马铃薯
        ['minecraft:bucket'],//桶
        ['minecraft:poppy'],//虞美人
        ['minecraft:ladder'],//梯子
    ]
    //定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['farmersdelight:bone_broth',2],//农夫乐事 大骨汤
        ['kaleidoscope_cookery:pork_bone_soup',1],//森罗物语 大骨汤
        ['terramity:daemonium_chunk',5],//terramity 恶魔碎块
        ['lightmanscurrency:coin_gold',1],//硬币与物品 金币
        ['lightmanscurrency:coin_iron',2],//硬币与物品 银币
        ['lightmanscurrency:coin_copper',3],//硬币与物品 铜币
    ]
    let lootItem = [
        ['confluence:royal_gel', 0.1],//皇家凝胶
        ['confluence:vitamins', 0.1],//维生素
        ['confluence:magiluminescence', 0.1],//魔光护符
        ['confluence:anklet_of_the_wind', 0.1],//疾风脚镯
        ['confluence:shark_tooth_necklace', 0.1],//鲨鱼项链
        ['confluence:bezoar', 0.1],//牛黄
        ['confluence:flashlight', 0.1],//手电筒
        ['confluence:blindfold', 0.1],//蒙眼布
        ['confluence:energy_bar', 0.1],//能量棒
        ['confluence:magma_skull', 0.1],//岩浆骷髅头
    ]
    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('twilightforest:chests/hill_2')//工兵矿山
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([2, 3], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('twilightforest:chests/hill_2')
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('twilightforest:chests/hill_2')//工兵矿山
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})


//巨魔洞穴  暮色森林
LootJS.modifiers(event => {//巨魔洞穴
     //定义删除物品,[物品id]
    let removeLoot = [
        ['touhou_little_maid:shrine'],//神龛
        ['touhou_little_maid:power_point'],//P点
        ['minecraft:arrow'],//箭
        ['minecraft:dandelion'],//蒲公英
        ['minecraft:gunpowder'],//火药
        ['minecraft:sugar_cane'],//甘蔗
        ['minecraft:bone_meal'],//骨粉
        ['minecraft:flint'],//小麦种子
        ['minecraft:sand'],//沙子
        ['minecraft:torch'],//火把
        ['twilightforest:ironwood_pickaxe'],//铁木稿
        ['minecraft:pumpkin_pie'],//南瓜派
        ['twilightforest:steeleaf_ingot'],//钢叶
        ['minecraft:potato'],//马铃薯
        ['minecraft:gold_nugget'],//金粒
        ['minecraft:feather'],//羽毛
        ['minecraft:cod'],//鱼
        ['minecraft:wheat_seeds'],//小麦种子
        ['minecraft:cactus'],//仙人掌
        ['minecraft:flower_pot'],//花盆
        ['minecraft:carrot'],//胡萝卜
        ['minecraft:baked_potato'],//烤马铃薯
        ['minecraft:bucket'],//桶
        ['minecraft:poppy'],//虞美人
        ['minecraft:ladder'],//梯子
        ['minecraft:melon_seeds'],//西瓜种子
        ['minecraft:red_mushroom'],//红蘑菇
        ['minecraft:brown_mushroom'],//棕蘑菇
    ]
    //定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['twilightforest:magic_beans', 100],//暮色森林 魔豆
        ['twilightforest:transformation_powder',5],//暮色森林 转换粉
        ['twilightforest:liveroot',5],//暮色森林 活根
        ['lightmanscurrency:coin_gold',10],//硬币与物品 金币
        ['twilightforest:hydra_chop',1],//暮色森林 九头蛇肉排
        ['twilightforest:fiery_tears',1],//暮色森林 炽热之泪
        ['twilightforest:ice_bomb',1],//暮色森林 冰霜炸弹
    ]
    let lootItem = [
        ['arsdelight:arch_sauce',0.1],//新生乐事 至高酱
    ]
     //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('twilightforest:chests/troll_garden')//巨魔洞穴
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([1, 2], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('twilightforest:chests/troll_garden')
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('twilightforest:chests/troll_garden')//巨魔洞穴
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})


//巨魔洞穴2   暮色森林
LootJS.modifiers(event => {//巨魔洞穴2
    //定义删除物品,[物品id]
    let removeLoot = [
        ['touhou_little_maid:shrine'],//神龛
        ['touhou_little_maid:power_point'],//P点
        ['minecraft:arrow'],//箭
        ['minecraft:dandelion'],//蒲公英
        ['minecraft:gunpowder'],//火药
        ['minecraft:sugar_cane'],//甘蔗
        ['minecraft:bone_meal'],//骨粉
        ['minecraft:flint'],//小麦种子
        ['minecraft:sand'],//沙子
        ['minecraft:torch'],//火把
        ['twilightforest:ironwood_pickaxe'],//铁木稿
        ['minecraft:pumpkin_pie'],//南瓜派
        ['twilightforest:steeleaf_ingot'],//钢叶
        ['minecraft:potato'],//马铃薯
        ['minecraft:gold_nugget'],//金粒
        ['minecraft:feather'],//羽毛
        ['minecraft:cod'],//鱼
        ['minecraft:wheat_seeds'],//小麦种子
        ['minecraft:cactus'],//仙人掌
        ['minecraft:flower_pot'],//花盆
        ['minecraft:carrot'],//胡萝卜
        ['minecraft:baked_potato'],//烤马铃薯
        ['minecraft:bucket'],//桶
        ['minecraft:poppy'],//虞美人
        ['minecraft:ladder'],//梯子
        ['twilightforest:uncrafting_table'],//拆解台
        ['minecraft:melon_seeds'],//西瓜种子
        ['minecraft:red_mushroom'],//红蘑菇
        ['minecraft:brown_mushroom'],//棕蘑菇
        ['minecraft:emerald'],//绿宝石
        ['minecraft:obsidian'],//黑曜石
        ['twilightforest:torchberries'],//火炬浆果
        ['minecraft:coal'],//煤炭
        ['twilightforest:trollsteinn'],//巨魔岩石
    ]
     //定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['twilightforest:magic_beans', 100],//暮色森林 魔豆
        ['twilightforest:transformation_powder',5],//暮色森林 转换粉
        ['twilightforest:liveroot',5],//暮色森林 活根
        ['lightmanscurrency:coin_gold',10],//硬币与物品 金币
        ['twilightforest:hydra_chop',1],//暮色森林 九头蛇肉排
        ['twilightforest:fiery_tears',1],//暮色森林 炽热之泪
        ['twilightforest:ice_bomb',1],//暮色森林 冰霜炸弹
    ]
    let lootItem = [
        ['arsdelight:arch_sauce',0.1],//新生乐事 至高酱
    ]
    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('twilightforest:chests/troll_vault')//巨魔洞穴2
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([2, 3], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('twilightforest:chests/troll_vault')
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('twilightforest:chests/troll_vault')//巨魔洞穴2
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})


//巨魔洞穴3  暮色森林
LootJS.modifiers(event => {//巨魔洞穴3
    //定义删除物品,[物品id]
    let removeLoot = [
        ['touhou_little_maid:shrine'],//神龛
        ['touhou_little_maid:power_point'],//P点
        ['minecraft:arrow'],//箭
        ['minecraft:dandelion'],//蒲公英
        ['minecraft:gunpowder'],//火药
        ['minecraft:sugar_cane'],//甘蔗
        ['minecraft:bone_meal'],//骨粉
        ['minecraft:flint'],//小麦种子
        ['minecraft:sand'],//沙子
        ['minecraft:torch'],//火把
        ['twilightforest:ironwood_pickaxe'],//铁木稿
        ['minecraft:pumpkin_pie'],//南瓜派
        ['twilightforest:steeleaf_ingot'],//钢叶
        ['minecraft:potato'],//马铃薯
        ['minecraft:gold_nugget'],//金粒
        ['minecraft:feather'],//羽毛
        ['minecraft:cod'],//鱼
        ['minecraft:wheat_seeds'],//小麦种子
        ['minecraft:cactus'],//仙人掌
        ['minecraft:flower_pot'],//花盆
        ['minecraft:carrot'],//胡萝卜
        ['minecraft:baked_potato'],//烤马铃薯
        ['minecraft:bucket'],//桶
        ['minecraft:poppy'],//虞美人
        ['minecraft:ladder'],//梯子
        ['twilightforest:uncrafting_table'],//拆解台
        ['minecraft:melon_seeds'],//西瓜种子
        ['minecraft:red_mushroom'],//红蘑菇
        ['minecraft:brown_mushroom'],//棕蘑菇
        ['minecraft:emerald'],//绿宝石
        ['minecraft:obsidian'],//黑曜石
        ['twilightforest:torchberries'],//火炬浆果
        ['minecraft:coal'],//煤炭
        ['twilightforest:trollsteinn'],//巨魔岩石
    ]
    //定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['twilightforest:hydra_chop',10],//暮色森林 九头蛇肉排
        ['twilightforest:fiery_tears',10],//暮色森林 炽热之泪
        ['twilightforest:ice_bomb',10],//暮色森林 冰霜炸弹
        ['twilightforest:transformation_powder',5],//暮色森林 转换粉
        ['lightmanscurrency:coin_gold',1],//硬币与物品 金币
        ['twilightforest:liveroot',5]//暮色森林 活根
    ]
    let lootItem = [
        ['arsdelight:arch_sauce',0.4],//新生乐事 至高酱
        ['pasterdream:legend_dragon_horn_ice_cream',0.1],//帕斯特之梦 传说龙角冰激凌
    ]
     //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('twilightforest:chests/troll_vault_with_lamp')//巨魔洞穴3
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([2, 3], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('twilightforest:chests/troll_vault_with_lamp')
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('twilightforest:chests/troll_vault_with_lamp')//巨魔洞穴3
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})



//古陵  eeeab's mods
LootJS.modifiers(event => {//古陵
    //定义删除物品,[物品id]
    let removeLoot = [
        ['minecraft:arrow'],//箭
        ['minecraft:book'],//书
        ['minecraft:brown_mushroom'],//蘑菇
        ['minecraft:leather_horse_armor'],//皮革马凯
        ['minecraft:apple'],//苹果
        ['minecraft:poisonous_potato'],//毒马铃薯
        ['minecraft:wheat'],//小麦
        ['minecraft:red_mushroom'],//红色蘑菇
        ['minecraft:coal'],//煤炭
        ['minecraft:iron_sword'],//铁剑
        ['touhou_little_maid:power_point'],//P点
        ['touhou_little_maid:shrine'],//神龛
        ['eeeabsmobs:immortal_debris'],//盔甲残骸

    ]

    //定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['vefc:soulspores', 4],//香草纪元 魂光孢子
        ['eeeabsmobs:immortal_bone', 1],//eeeab 不朽之骨
        ['quark:ancient_fruit',3],//夸克 远古水果
    ]

    let lootItem = [
        ['enigmaticlegacy:darkest_scroll', 0.2],//神秘遗物 至暗卷轴
        ['bountifulfares:hoary_apple', 0.15],//丰饶食记 朽老苹果
        ['lightmanscurrency:coin_emerald', 0.15],//硬币与物品 绿宝石币
        ['vintagedelight:century_egg', 0.05],//腌渍乐事 松花蛋（厨神之证）
        ['enigmaticlegacy:unholy_grail',0.1],//神秘遗物 不洁圣杯
    ]
//遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('eeeabsmobs:chests/epic_ancient_tomb')//古陵
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([2, 2], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('eeeabsmobs:chests/epic_ancient_tomb')
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('eeeabsmobs:chests/epic_ancient_tomb')//古陵
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})


//古陵2 eeeab's mods
LootJS.modifiers(event => {//古陵2
    //定义删除物品,[物品id]
    let removeLoot = [
        ['enigmaticlegacy:iron_ring'],//铁指环
        ['minecraft:bow'],//弓
        ['minecraft:golden_horse_armor'],//金马凯
        ['minecraft:iron_horse_armor'],//铁马凯
        ['minecraft:iron_helmet'],//铁头盔
        ['minecraft:iron_chestplate'],//铁胸甲
        ['minecraft:iron_leggings'],//铁护腿
        ['minecraft:iron_boots'],//铁靴子
        ['minecraft:iron_sword'],//铁剑
        ['minecraft:iron_axe'],//铁斧
        ['minecraft:saddle'],//马鞍
        ['minecraft:clock'],//钟
        ['minecraft:sand'],//沙子
    ]
    //定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['immortalers_delight:sealed_ancient_rations',1],//千古乐事 古代口粮包
        ['lightmanscurrency:coin_emerald',1],//硬币与物品 绿宝石币
        ['quark:ancient_fruit',3],//夸克 远古水果
        ['vefc:soulspores', 4],//香草纪元 魂光孢子
    ]
    let lootItem = [
        ['confluence:royal_gel', 0.3],//皇家凝胶
        ['confluence:vitamins', 0.3],//维生素
        ['confluence:magiluminescence', 0.3],//魔光护符
        ['confluence:anklet_of_the_wind', 0.3],//疾风脚镯
        ['confluence:shark_tooth_necklace', 0.3],//鲨鱼项链
        ['confluence:bezoar', 0.3],//牛黄
        ['confluence:flashlight', 0.3],//手电筒
        ['confluence:blindfold', 0.3],//蒙眼布
        ['confluence:energy_bar', 0.3],//能量棒
        ['confluence:magma_skull', 0.3],//岩浆骷髅头 
    ]
    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('eeeabsmobs:chests/rare_ancient_tomb')//古陵2
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([2, 3], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('eeeabsmobs:chests/rare_ancient_tomb')
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('eeeabsmobs:chests/rare_ancient_tomb')//古陵2
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})


//简单地牢
LootJS.modifiers(event => {  //简单地牢
    //定义删除物品,[物品id]
    let removeLoot = [
        ['minecraft:coal'],//煤炭
        ['minecraft:glow_berries'],//发光浆果
        ['minecraft:compass'],//指南针
        ['minecraft:beetroot_seeds'],//甜菜种子
        ['minecraft:melon_seeds'],//西瓜种子
        ['minecraft:rail'],//铁轨
        ['minecraft:powered_rail'],//动力铁轨
        ['minecraft:activator_rail'],//激活铁轨
        ['minecraft:detector_rail'],//探测铁轨
        ['minecraft:leather'],//皮革
        ['minecraft:iron_ingot'],//铁
        ['minecraft:gold_ingot'],//金
        ['minecraft:emerald'],//绿宝石
        ['minecraft:diamond'],//钻石
        ['minecraft:lapis_lazuli'],//青金石
        ['minecraft:redstone'],//红石
        ['additionaladditions:rope'],//绳子
        ['supplementaries:rope'],//绳索
        ['farmersdelight:rope'],//绳子
        ['additionaladditions:glow_stick'],//荧光棒
        ['muffins_thaidelight:pepper_seeds'],//辣椒种子
        ['minecraft:torch'],//火把
        ['dumplings_delight:chinese_cabbage_seeds'],//白菜种子
        [('minecraft:clock')],//钟
        [Item.of('minecraft:iron_axe')],//铁斧头
        ['farmersdelight:cabbage_seeds'],//卷心菜种子
        ['additionaladditions:rose_gold_upgrade'],//锻造模板
        ['additionaladditions:music_disc_1507'],//唱片
        ['additionaladditions:music_disc_1007'],//唱片
        ['additionaladditions:music_disc_0308'],//唱片
        ['minecraft:gunpowder'],//火药
        ['enigmaticlegacy:iron_ring'],//铁指环
        ['minecraft:string'],//线
        ['minecraft:pumpkin_seeds'],//南瓜种子
        ['minecraft:wheat'],//小麦
        ['minecraft:music_disc_otherside'],//唱片
        ['minecraft:iron_horse_armor'],//铁马恺
        [Item.of('beachparty:rubber_ring_axolotl', '{Damage:0}')],//泳圈
        ['ars_nouveau:split_arrow'],//箭
        ['minecraft:slime_ball'],//粘液球
        ['minecraft:golden_horse_armor'],//金马凯
        [Item.of('beachparty:rubber_ring_pelican', '{Damage:0}')],//泳圈
        ['farmersdelight:tomato_seeds'],//番茄种子
        ['beachparty:overgrown_disc'],//唱片
        ['minecraft:bone'],//骨头
        ['minecraft:music_disc_cat'],//唱片
        [Item.of('minecraft:potion', '{Potion:"ars_nouveau:mana_regen_potion"}')],//药水
        ['quark:smithing_template_rune'],//锻造模板
        ['ars_nouveau:amplify_arrow'],//箭
    ]
    //定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['lightmanscurrency:coin_gold',10],//硬币与物品 金币
        ['dungeonsdelight:rubaboo',1],//地牢乐事 腐肉饼汤
        ['minecraft:poisonous_potato',5],//毒马铃薯
        ['farmersdelight:rotten_tomato',5],//农夫乐事 烂番茄
    ]
    let lootItem = [
        ['enigmaticaddons:artificial_flower',0.1],//神秘遗物扩展 魔法石英花
        ['enigmaticaddons:void_tome',0.05],//神秘遗物扩展 虚无之书
        ['enigmaticlegacy:forbidden_fruit',0.05],//神秘佳肴 禁忌之果
        ['enigmaticlegacy:unholy_grail',0.05],//神秘佳肴 不洁圣杯
        ['immortalers_delight:stuffed_poisonous_potato',0.2],//千古乐事 填馅毒马铃薯
        ['immortalers_delight:meaty_rotten_tomato_broth',0.2],//千古乐事 烂茄肉汤
    ]
     //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('minecraft:chests/simple_dungeon')//简单地牢
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([2, 3], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('minecraft:chests/simple_dungeon')
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('minecraft:chests/simple_dungeon')//简单地牢
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})


//浮云神殿
LootJS.modifiers(event => {///浮云神殿
     //定义删除物品,[物品id]
    let removeLoot = [
        ['minecraft:string'],//线
        ['minecraft:feather'],//羽毛
    ]
    //定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['lightmanscurrency:coin_gold',3],//硬币与物品 金币
        ['minecraft:diamond', 2],//钻石
        ['delighto_flight:clear_cloudshroom',1],//云端之乐 云蘑菇
    ]
    let lootItem = [
        ['enigmaticdelicacy:enigmatic_seed', 0.2],//神秘佳肴 神秘种子
        ['confluence:shot_put', 0.2],//泰拉饰品 铅球
        ['delighto_flight:cloud_bread',0.3],//云端之乐 云朵面包
        ['confluence:cloud_in_a_bottle',0.2],//泰拉饰品 云朵瓶
    ]

    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('legendary_monsters:chests/cloudy_temple_loot_table')//浮云神殿
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([1, 2], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('legendary_monsters:chests/cloudy_temple_loot_table')
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('legendary_monsters:chests/cloudy_temple_loot_table')//浮云神殿
            .removeLoot(item)//删除遍历removeLoot的物品 

     })
})


//荒古要塞
LootJS.modifiers(event => {///荒古要塞
    //定义删除物品,[物品id]
    let removeLoot = [
        ['legendary_monsters:ancient_dripstone_bricks'],//荒古滴水石砖
        ['minecraft:saddle'],//鞍
        ['minecraft:bone'],//骨头
        ['minecraft:beetroot_seeds'],//甜菜种子
    ]
    //定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['lightmanscurrency:coin_gold',3],//硬币与物品 金币
        ['minecraft:sniffer_egg', 1],//嗅探兽蛋
        ['manors_bounty:super_ancient_mushroom',1],//庄园 超古代蘑菇
    ]

    let lootItem = [
        ['confluence:eye_of_the_golem', 0.2],//泰拉饰品 石巨人之眼
        ['confluence:warrior_emblem', 0.2],//泰拉饰品 战士徽章
        ['confluence:cobalt_shield', 0.2],//泰拉饰品 钴护盾
        ['enigmaticaddons:artificial_flower', 0.1],//神秘遗物+ 魔法石英花
        ['composite_material:primitive_tenacity',0.1],//复合材料 荒古坚材
    ]

    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('legendary_monsters:chests/ancient_stronghold_luxury_loot_table')//荒古要塞
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([2, 3], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('legendary_monsters:chests/ancient_stronghold_luxury_loot_table')
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('legendary_monsters:chests/ancient_stronghold_luxury_loot_table')//荒古要塞
            .removeLoot(item)//删除遍历removeLoot的物品 

     })
})


//荒古要塞2
LootJS.modifiers(event => {///荒古要塞2
    //定义删除物品,[物品id]
    let removeLoot = [
        ['legendary_monsters:ancient_dripstone_bricks'],//荒古滴水石砖
        ['minecraft:saddle'],//鞍
        ['minecraft:bone'],//骨头
        ['minecraft:beetroot_seeds'],//甜菜种子
    ]

    //定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['lightmanscurrency:coin_gold',3],//硬币与物品 金币
        ['minecraft:sniffer_egg', 1],//嗅探兽蛋
        ['manors_bounty:super_ancient_mushroom',1],//庄园 超古代蘑菇
    ]

    let lootItem = [
        ['confluence:eye_of_the_golem', 0.2],// 泰拉饰品 石巨人之眼
        ['confluence:warrior_emblem', 0.2],//泰拉饰品 战士徽章
        ['confluence:cobalt_shield', 0.2],//泰拉饰品 钴护盾
        ['enigmaticaddons:artificial_flower', 0.1],//神秘佳肴 魔法石英花
        ['composite_material:primitive_tenacity',0.1],//复合材料 荒古坚材
    ]

    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('legendary_monsters:chests/ancient_stronghold_loot_table')//荒古要塞2
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([2, 3], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('legendary_monsters:chests/ancient_stronghold_loot_table')
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('legendary_monsters:chests/ancient_stronghold_loot_table')//荒古要塞2
            .removeLoot(item)//删除遍历removeLoot的物品 

     })
})
//废弃墓穴
LootJS.modifiers(event => {///废弃墓穴
    //定义删除物品,[物品id]
    let removeLoot = [
        ['minecraft:iron_helmet'],//铁头盔
        ['minecraft:iron_chestplate'],//铁胸甲
        ['minecraft:iron_leggings'],//铁护腿
        ['minecraft:iron_boots'],//铁靴子
        ['minecraft:iron_sword'],//铁剑
        ['minecraft:chainmail_helmet'],//锁链头盔
        ['minecraft:chainmail_chestplate'],//锁链胸甲
        ['minecraft:chainmail_leggings'],//锁链护腿
        ['minecraft:chainmail_boots'],//锁链靴子
        ['minecraft:bone_meal'],//骨粉
    ]
    //定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['lightmanscurrency:coin_gold',3],//硬币与物品 金币
        ['royalvariations:royal_armor_fragments', 1],//皇家变种 骑士碎片
        ['royalvariations:spiritual_crown_shard',1],//皇家变种 灵性王冠碎片
    ]
     let lootItem = [
        ['enigmaticdelicacy:enigmatic_seed', 0.2],//神秘佳肴 神秘种子
        ['confluence:paladins_shield', 0.2],//泰拉饰品 圣骑士护盾
        ['confluence:magic_mirror', 0.2],//泰拉饰品 魔镜
        ['royalvariations:spiritual_crown_shard',0.3],//皇家变种 灵性王冠碎片
    ]

    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('legendary_monsters:chests/abandoned_crypt_loot_table')//废弃墓穴
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([2, 3], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('legendary_monsters:chests/abandoned_crypt_loot_table')
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('legendary_monsters:chests/abandoned_crypt_loot_table')//废弃墓穴
            .removeLoot(item)//删除遍历removeLoot的物品 

     })
})


//废弃传送门
LootJS.modifiers(event => {///废弃传送门
     let removeLoot = [
        ['additionaladditions:gilded_netherite_upgrade'],//锻造模版
        [Item.of('minecraft:flint_and_steel', '{Damage:0}')],//打火石
        ['minecraft:iron_nugget'],//铁粒
        [Item.of('minecraft:golden_leggings', '{Damage:0}')],//金护腿
        [Item.of('minecraft:golden_pickaxe', '{Damage:0}')],//金稿
        [Item.of('minecraft:golden_axe', '{Damage:0}')],//金斧
        [Item.of('minecraft:golden_chestplate', '{Damage:0}')],//金胸甲
        [Item.of('minecraft:golden_sword', '{Damage:0}')],//金剑
        ['minecraft:iron_horse_armor'],//铁马恺
        ['enigmaticaddons:hell_blade_charm'],
        [Item.of('minecraft:golden_shovel', '{Damage:0}')],//金铲
    ]
    //定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['lightmanscurrency:coin_gold',3],//硬币与物品 金币
        ['midashunger:cooked_golden_mutton',1],//金羊肉
        ['midashunger:cooked_golden_chicken',1],//金鸡肉
        ['midashunger:cooked_golden_rabbit',1],//金兔肉
        ['midashunger:cooked_golden_beef',1],//金牛排
    ]
    let lootItem = [
        ['confluence:shackle', 0.2],//泰拉饰品 脚镣
        ['confluence:platinum_watch', 0.2],//泰拉饰品 铂金表
        ['enigmaticdelicacy:enigmatic_seed', 0.2],//泰拉饰品 神秘种子
    ]

    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('minecraft:chests/ruined_portal')///废弃传送门
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([2, 3], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('minecraft:chests/ruined_portal')
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('minecraft:chests/ruined_portal')//废弃传送门
            .removeLoot(item)//删除遍历removeLoot的物品 

     })
})

//丛林神庙
LootJS.modifiers(event => {//丛林神庙
    //定义删除物品,[物品id]
    let removeLoot = [
        ['minecraft:coal'],//煤炭
        ['minecraft:glow_berries'],//发光浆果
        ['minecraft:compass'],//指南针
        ['minecraft:beetroot_seeds'],//甜菜种子
        ['minecraft:melon_seeds'],//西瓜种子
        ['minecraft:rail'],//铁轨
        ['minecraft:powered_rail'],//动力铁轨
        ['minecraft:activator_rail'],//激活铁轨
        ['minecraft:detector_rail'],//探测铁轨
        ['minecraft:leather'],//皮革
        ['minecraft:iron_ingot'],//铁
        ['minecraft:gold_ingot'],//金
        ['minecraft:emerald'],//绿宝石
        ['minecraft:diamond'],//钻石
        ['minecraft:lapis_lazuli'],//青金石
        ['minecraft:redstone'],//红石
        ['additionaladditions:rope'],//绳子
        ['supplementaries:rope'],//绳索
        ['farmersdelight:rope'],//绳子
        ['additionaladditions:glow_stick'],//荧光棒
        ['muffins_thaidelight:pepper_seeds'],//辣椒种子
        ['minecraft:torch'],//火把
        ['dumplings_delight:chinese_cabbage_seeds'],//白菜种子
        [('minecraft:clock')],//钟
        [Item.of('minecraft:iron_axe')],//铁斧头
        ['farmersdelight:cabbage_seeds'],//卷心菜种子
        ['additionaladditions:rose_gold_upgrade'],//锻造模板
        ['minecraft:pumpkin_seeds'],//南瓜种子
        ['galosphere:silver_upgrade_smithing_template'],//锻造模板
        [Item.of('minecraft:potion', '{Potion:"ars_nouveau:mana_regen_potion_long"}')],//药水
        ['ars_nouveau:music_disc_aria_biblio'],//唱片
    ]

    //定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['lightmanscurrency:coin_gold',3],//硬币与物品 金币
        ['abnormals_delight:chocolate_cake_slice',1],//巧克力蛋糕切片
        ['manors_bounty:chocolate_chips',1],//巧克力碎
        ['manors_bounty:white_chocolate_chips',1],//白巧克力碎
        ['manors_bounty:dark_chocolate_chips',1],//黑巧克力碎
    ]
    let lootItem = [
        ['pasterdream:heart_chocolate_0', 0.3],//帕斯特之梦 心形巧克力0
        ['pasterdream:heart_chocolate_1', 0.3],//帕斯特之梦 心形巧克力1
        ['enigmaticdelicacy:enigmatic_seed', 0.2],//神秘佳肴 神秘种子
        ['pasterdream:heart_chocolate_2',0.3],//帕斯特之梦 心形巧克力2
    ]
    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('minecraft:chests/jungle_temple')///丛林神庙
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([1, 2], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('minecraft:chests/jungle_temple')
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('minecraft:chests/jungle_temple')//丛林神庙
            .removeLoot(item)//删除遍历removeLoot的物品 

     })
})


//巫妖塔（祸乱鬼魅）
LootJS.modifiers(event => {//巫妖塔（祸乱鬼魅）
    let removeLoot = [
        ['minecraft:coal'],//煤炭
        ['minecraft:glow_berries'],//发光浆果
        ['minecraft:compass'],//指南针
        ['minecraft:beetroot_seeds'],//甜菜种子
        ['minecraft:melon_seeds'],//西瓜种子
        ['minecraft:rail'],//铁轨
        ['minecraft:powered_rail'],//动力铁轨
        ['minecraft:activator_rail'],//激活铁轨
        ['minecraft:detector_rail'],//探测铁轨
        ['minecraft:leather'],//皮革
        ['minecraft:iron_ingot'],//铁
        ['minecraft:gold_ingot'],//金
        ['minecraft:emerald'],//绿宝石
        ['minecraft:diamond'],//钻石
        ['minecraft:lapis_lazuli'],//青金石
        ['minecraft:redstone'],//红石
        ['additionaladditions:rope'],//绳子
        ['supplementaries:rope'],//绳索
        ['farmersdelight:rope'],//绳子
        ['additionaladditions:glow_stick'],//荧光棒
        ['muffins_thaidelight:pepper_seeds'],//辣椒种子
        ['minecraft:torch'],//火把
        ['dumplings_delight:chinese_cabbage_seeds'],//白菜种子
        [('minecraft:clock')],//钟
        [Item.of('minecraft:iron_axe')],//铁斧头
        ['farmersdelight:cabbage_seeds'],//卷心菜种子
        ['additionaladditions:rose_gold_upgrade'],//锻造模板
        ['minecraft:pumpkin_seeds'],//南瓜种子
        ['galosphere:silver_upgrade_smithing_template'],//锻造模板
        [Item.of('minecraft:potion', '{Potion:"ars_nouveau:mana_regen_potion_long"}')],//药水
        ['ars_nouveau:music_disc_aria_biblio'],//唱片
        ['minecraft:saddle'],//鞍
        ['touhou_little_maid:power_point'],//p点
        ['minecraft:basalt'],//玄武岩
        ['minecraft:gunpowder'],//火药
        ['minecraft:bone'],//骨头
        ['minecraft:string'],//线
        ['minecraft:music_disc_wait'],//disco
    ]
    //定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['lightmanscurrency:coin_gold',3],//硬币与物品 金币
        ['neapolitan:strawberry_banana_smoothie',1],//那不勒斯 草莓冰沙
        ['peculiars:aloe_berry_smoothie',1],//独特风味 芦荟冰沙
        ['collectorsreap:pomegranate_smoothie',1],//collector 石榴冰沙
        ['fruitsdelight:hamimelon_shaved_ice',1],//果园乐事 蜜瓜冰沙
    ]
    let lootItem = [
        ['enigmaticaddons:forgotten_ice', 0.3],//神秘遗物 忘却冰晶
        ['youkaishomecoming:big_popsicle', 0.3],//妖归 大冰棍
        ['enigmaticdelicacy:enigmatic_seed', 0.2],//神秘佳肴 神秘种子
        ['youkaishomecoming:shaved_ice_over_rice',0.3],//妖归 儿童刨冰盖饭
    ]
     //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('bosses_of_mass_destruction:chests/lich_tower')///巫妖塔（祸乱鬼魅）
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([1, 2], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('bosses_of_mass_destruction:chests/lich_tower')
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('bosses_of_mass_destruction:chests/lich_tower')//巫妖塔（祸乱鬼魅）
            .removeLoot(item)//删除遍历removeLoot的物品 

     })
})

//巫妖塔2(补)
LootJS.modifiers(event => {//巫妖塔2
    //定义删除物品,[物品id]
    let removeLoot = [
        ['touhou_little_maid:shrine'],//神龛
        ['touhou_little_maid:power_point'],//P点
        ['minecraft:arrow'],//箭
        ['minecraft:dandelion'],//蒲公英
        ['minecraft:gunpowder'],//火药
        ['minecraft:sugar_cane'],//甘蔗
        ['minecraft:bone_meal'],//骨粉
        ['minecraft:flint'],//小麦种子
        ['minecraft:sand'],//沙子
        ['minecraft:torch'],//火把
        ['twilightforest:ironwood_pickaxe'],//铁木稿
        ['minecraft:pumpkin_pie'],//南瓜派
        ['twilightforest:steeleaf_ingot'],//钢叶
        ['minecraft:potato'],//马铃薯
        ['minecraft:gold_nugget'],//金粒
        ['minecraft:feather'],//羽毛
        ['minecraft:cod'],//鱼
        ['minecraft:wheat_seeds'],//小麦种子
        ['minecraft:cactus'],//仙人掌
        ['minecraft:flower_pot'],//花盆
        ['minecraft:bow'],//弓
        ['minecraft:stone_sword'],//石剑
        ['minecraft:wooden_sword'],//木剑
        ['minecraft:iron_sword'],//铁剑
        ['minecraft:iron_leggings'],//铁护腿
        ['minecraft:paper'],//纸
        ['minecraft:ladder'],//梯子
        ['minecraft:fire_charge'],//火焰弹
        ['minecraft:map'],//地图
        ['minecraft:bone'],//骨头
        ['minecraft:clay_ball'],//黏土
        ['minecraft:glass_bottle'],//玻璃瓶
        ['minecraft:book'],//书
        ['minecraft:potion'],//水瓶
        ['minecraft:golden_pickaxe'],//金稿
    ]

     //定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['twilightforest:torchberries',5],//暮色森林 火炬浆果
        ['twilightforest:fiddlehead',2],//暮色森林 暮色蕨
        ['twilightdelight:torchberry_cookie',1],//暮色乐事 火炬浆果曲奇
        ['lightmanscurrency:coin_gold',1],//硬币与物品 金币
        ['arsdelight:neutralized_bombegrante_jam',1],//新生乐事 果酱
        ['arsdelight:activated_mendosteen_jam',1],//新生乐事 果酱
        ['arsdelight:activated_bastion_jam',1],//新生乐事 果酱
        ['arsdelight:neutralized_frostaya_jam',1],//新生乐事 果酱
    ]
    let lootItem = [
        ['twilightdelight:torchberry_cake_slice',0.3],//暮色乐事 火炬浆果蛋糕切片
        ['twilightdelight:torchberry_pie_slice',0.3],//暮色乐事 火炬浆果派切片
        ['arsdelight:arch_sauce',0.1],//新生乐事 至高酱
    ]
    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('twilightforest:chests/tower_room')//巫妖怪塔2
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([1, 2], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('twilightforest:chests/tower_room')
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('twilightforest:chests/tower_room')//巫妖怪塔2
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})


//旷野之息高塔
LootJS.modifiers(event => {//旷野之息高塔
    //定义删除物品,[物品id]
    let removeLoot = [
        ['minecraft:feather'],
        ['minecraft:gold_nugget'],
        ['minecraft:map'],
        ['minecraft:compass'],
        ['minecraft:iron_ingot'],
        ['minecraft:ender_pearl'],
        ['touhou_little_maid:power_point'],
]

     //定义添加权重物品[物品id,概率]
    let weightLootItem = [
        [Item.of('minecraft:firework_rocket', '{Fireworks:{Flight:3b}}'),1],//烟花火箭
        ['minecraft:phantom_membrane',3],//幻翼膜
        ['smc:ice_tea',1],//星喵 冰红茶
        ['cosmopolitan:llama_marshmallow',2],
        ['cosmopolitan:llama_marshmallow_brown',2],
        ['cosmopolitan:llama_marshmallow_trader',2],
        ['cosmopolitan:travelers_panini',2],
        ['cosmopolitan:wandering_gelato',2],
    ]
     let lootItem = [
        ['artifacts:umbrella',0.2],//奇异饰品 雨伞
        ['confluence:lucky_horseshoe',0.2]//泰拉饰品 幸运马掌
    ]

    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('totw_modded:tower_chest')//旷野之息高塔
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([2, 4], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('totw_modded:tower_chest')//旷野之息高塔
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('totw_modded:tower_chest')//旷野之息高塔
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})


//森林小教堂
LootJS.modifiers(event => {//森林小教堂
    //定义删除物品,[物品id]
    let removeLoot = [
       ['minecraft:bread'],
       ['minecraft:iron_sword'],
       ['touhou_little_maid:power_point'],
       ['minecraft:iron_helmet'],
       ['minecraft:apple'],
       ['minecraft:saddle'],
       [Item.of('minecraft:iron_boots', '{Damage:0}')],
       ['minecraft:rose_bush'],
       [Item.of('minecraft:iron_pickaxe', '{Damage:0}')],
       ['minecraft:blue_orchid'],
       ['minecraft:oak_sapling'],
       ['minecraft:obsidian'],
       ['minecraft:lapis_lazuli'],
       [Item.of('minecraft:chainmail_leggings', '{Damage:0}')],
       [Item.of('minecraft:iron_leggings', '{Damage:0}')],
       ['minecraft:moss_block'],
       ['minecraft:slime_ball'],
       ['minecraft:iron_horse_armor'],
       [Item.of('minecraft:iron_chestplate', '{Damage:0}')],
]
//定义添加权重物品[物品id,概率]
    let weightLootItem = [
       ['lightmanscurrency:coin_gold',1],//硬币与物品 金币
       ['neapolitan:banana_bread',3],//农夫乐事 箱装洋葱
       ['bountifulfares:artisan_bread',3],//农夫乐事 箱装胡萝卜
       ['supplementaries:pancake',3],//农夫乐事 箱装土豆
       ['farmersdelight:tomato_crate',3],//农夫乐事 箱装番茄
       ['atmospheric:orange_pudding',3],//农夫乐事 箱装茄子
]
     let lootItem = [
        ['whimsy_deco:gatcha_capsule',0.3],//扭蛋胶囊
]
    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('simply_houses:chests/forest_chapel/forest_chapel_normal')//森林小教堂
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([2, 3], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('simply_houses:chests/forest_chapel/forest_chapel_normal')//森林小教堂
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('simply_houses:chests/forest_chapel/forest_chapel_normal')//森林小教堂
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})

//森林小教堂（木桶）
LootJS.modifiers(event => {//森林小教堂
    //定义删除物品,[物品id]
    let removeLoot = [
       ['minecraft:bread'],
       [Item.of('minecraft:iron_sword', '{Damage:0}')],
       ['touhou_little_maid:power_point'],
       [Item.of('minecraft:iron_helmet', '{Damage:0}')],
       ['minecraft:apple'],
       ['minecraft:saddle'],
       [Item.of('minecraft:iron_boots', '{Damage:0}')],
       ['minecraft:rose_bush'],
       [Item.of('minecraft:iron_pickaxe', '{Damage:0}')],
       ['minecraft:blue_orchid'],
       ['minecraft:oak_sapling'],
       ['minecraft:obsidian'],
       ['minecraft:lapis_lazuli'],
       [Item.of('minecraft:chainmail_leggings', '{Damage:0}')],
       [Item.of('minecraft:iron_leggings', '{Damage:0}')],
       ['minecraft:moss_block'],
       ['minecraft:slime_ball'],
       ['minecraft:iron_horse_armor'],
       [Item.of('minecraft:iron_chestplate', '{Damage:0}')],
]
//定义添加权重物品[物品id,概率]
    let weightLootItem = [
       ['lightmanscurrency:coin_gold',1],//硬币与物品 金币
       ['farmersdelight:onion_crate',3],//农夫乐事 箱装洋葱
       ['bountifulfares:mushroom_stuffed_potato',3],//农夫乐事 箱装胡萝卜
       ['bountifulfares:maize_stuffed_potato',3],//农夫乐事 箱装土豆
       ['bountifulfares:berry_stuffed_potato',3],//农夫乐事 箱装番茄
       ['neapolitan:adzuki_bun',3],//农夫乐事 箱装茄子
]
     let lootItem = [
        ['whimsy_deco:gatcha_capsule',0.15],//扭蛋胶囊
]
    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('simply_houses:chests/forest_chapel/forest_chapel_barrels')//森林小教堂 木桶
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([1, 2], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('simply_houses:chests/forest_chapel/forest_chapel_barrels')//森林小教堂 木桶
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('simply_houses:chests/forest_chapel/forest_chapel_barrels')//森林小教堂 木桶
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})

//森林房屋
LootJS.modifiers(event => {//森林房屋
    //定义删除物品,[物品id]
    let removeLoot = [
       ['minecraft:bread'],
       [Item.of('minecraft:iron_sword', '{Damage:0}')],
       ['touhou_little_maid:power_point'],
       [Item.of('minecraft:iron_helmet', '{Damage:0}')],
       ['minecraft:apple'],
       ['minecraft:saddle'],
       [Item.of('minecraft:iron_boots', '{Damage:0}')],
       ['minecraft:rose_bush'],
       [Item.of('minecraft:iron_pickaxe', '{Damage:0}')],
       ['minecraft:blue_orchid'],
       ['minecraft:oak_sapling'],
       ['minecraft:obsidian'],
       ['minecraft:lapis_lazuli'],
       [Item.of('minecraft:chainmail_leggings', '{Damage:0}')],
       [Item.of('minecraft:iron_leggings', '{Damage:0}')],
       ['minecraft:moss_block'],
       ['minecraft:slime_ball'],
       ['minecraft:iron_horse_armor'],
       [Item.of('minecraft:iron_chestplate', '{Damage:0}')],
       [Item.of('minecraft:stone_shovel', '{Damage:0}')],
]
//定义添加权重物品[物品id,概率]
    let weightLootItem = [
       ['lightmanscurrency:coin_gold',1],
       ['galosphere:lichen_cordyceps',3],
       ['bountifulfares:lapisberries',3],
       ['supplementaries:antique_ink',3],
       ['species:wicked_wax',3],
       ['culturaldelights:eggplant_crate',3],//农夫乐事 箱装茄子
]
     let lootItem = [
        ['whimsy_deco:gatcha_capsule',0.15],//扭蛋胶囊
]
    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('simply_houses:chests/forest_house/forest_house_barrels')//森林房屋 木桶
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([1, 2], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('simply_houses:chests/forest_house/forest_house_barrels')//森林房屋 木桶
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('simply_houses:chests/forest_house/forest_house_barrels')//森林房屋 木桶
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})

//森林石匠铺
LootJS.modifiers(event => {//森林石匠铺
    //定义删除物品,[物品id]
    let removeLoot = [
       ['minecraft:bread'],
       [Item.of('minecraft:iron_sword', '{Damage:0}')],
       ['touhou_little_maid:power_point'],
       [Item.of('minecraft:iron_helmet', '{Damage:0}')],
       ['minecraft:apple'],
       ['minecraft:saddle'],
       [Item.of('minecraft:iron_boots', '{Damage:0}')],
       ['minecraft:rose_bush'],
       [Item.of('minecraft:iron_pickaxe', '{Damage:0}')],
       ['minecraft:blue_orchid'],
       ['minecraft:oak_sapling'],
       ['minecraft:obsidian'],
       ['minecraft:lapis_lazuli'],
       [Item.of('minecraft:chainmail_leggings', '{Damage:0}')],
       [Item.of('minecraft:iron_leggings', '{Damage:0}')],
       ['minecraft:moss_block'],
       ['minecraft:slime_ball'],
       ['minecraft:iron_horse_armor'],
       [Item.of('minecraft:iron_chestplate', '{Damage:0}')],
       [Item.of('minecraft:stone_shovel', '{Damage:0}')],
]
//定义添加权重物品[物品id,概率]
    let weightLootItem = [
       ['lightmanscurrency:coin_gold',1],//硬币与物品 金币
       ['braziliandelight:cassava_crate',3],
       ['braziliandelight:collard_greens_crate',3],
       ['quark:ancient_fruit',1],
       ['farmersdelight:tomato_crate',3],
       ['veggiesdelight:cauliflower',3],
]
     let lootItem = [
        ['whimsy_deco:gatcha_capsule',0.3],//扭蛋胶囊
]
    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('simply_houses:chests/forest_stonemason/forest_stonemason_normal')//森林房屋 
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([1, 2], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('simply_houses:chests/forest_stonemason/forest_stonemason_normal')//森林石匠铺
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('simply_houses:chests/forest_stonemason/forest_stonemason_normal')//森林石匠铺
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})

//森林城堡
LootJS.modifiers(event => {//森林城堡
    //定义删除物品,[物品id]
    let removeLoot = [
       ['minecraft:bread'],
       [Item.of('minecraft:iron_sword', '{Damage:0}')],
       ['touhou_little_maid:power_point'],
       [Item.of('minecraft:iron_helmet', '{Damage:0}')],
       ['minecraft:apple'],
       ['minecraft:saddle'],
       [Item.of('minecraft:iron_boots', '{Damage:0}')],
       ['minecraft:rose_bush'],
       [Item.of('minecraft:iron_pickaxe', '{Damage:0}')],
       ['minecraft:blue_orchid'],
       ['minecraft:oak_sapling'],
       ['minecraft:obsidian'],
       ['minecraft:lapis_lazuli'],
       [Item.of('minecraft:chainmail_leggings', '{Damage:0}')],
       [Item.of('minecraft:iron_leggings', '{Damage:0}')],
       ['minecraft:moss_block'],
       ['minecraft:slime_ball'],
       ['minecraft:iron_horse_armor'],
       [Item.of('minecraft:iron_chestplate', '{Damage:0}')],
       [Item.of('minecraft:stone_shovel', '{Damage:0}')],
]
//定义添加权重物品[物品id,概率]
    let weightLootItem = [
       ['lightmanscurrency:coin_gold',1],//硬币与物品 金币
       ['farmersdelight:onion_crate',3],//农夫乐事 箱装洋葱
       ['farmersdelight:carrot_crate',3],//农夫乐事 箱装胡萝卜
       ['farmersdelight:potato_crate',3],//农夫乐事 箱装土豆
       ['farmersdelight:tomato_crate',3],//农夫乐事 箱装番茄
       ['culturaldelights:eggplant_crate',3],//农夫乐事 箱装茄子
       ['meadow:wooden_warped_milk_bucket',3],
       ['cosmopolitan:strawberry_gulime',3],
]
     let lootItem = [
        ['whimsy_deco:gatcha_capsule',0.3],//扭蛋胶囊
]
    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('simply_houses:chests/forest_fort/forest_fort_normal')//森林城堡
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([2, 3], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('simply_houses:chests/forest_fort/forest_fort_normal')//森林城堡
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('simply_houses:chests/forest_fort/forest_fort_normal')//森林石匠铺
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})


//森林城堡 木桶
LootJS.modifiers(event => {//森林城堡 木桶
    //定义删除物品,[物品id]
    let removeLoot = [
       ['minecraft:bread'],
       [Item.of('minecraft:iron_sword', '{Damage:0}')],
       ['touhou_little_maid:power_point'],
       [Item.of('minecraft:iron_helmet', '{Damage:0}')],
       ['minecraft:apple'],
       ['minecraft:saddle'],
       [Item.of('minecraft:iron_boots', '{Damage:0}')],
       ['minecraft:rose_bush'],
       [Item.of('minecraft:iron_pickaxe', '{Damage:0}')],
       ['minecraft:blue_orchid'],
       ['minecraft:oak_sapling'],
       ['minecraft:obsidian'],
       ['minecraft:lapis_lazuli'],
       [Item.of('minecraft:chainmail_leggings', '{Damage:0}')],
       [Item.of('minecraft:iron_leggings', '{Damage:0}')],
       ['minecraft:moss_block'],
       ['minecraft:slime_ball'],
       ['minecraft:iron_horse_armor'],
       [Item.of('minecraft:iron_chestplate', '{Damage:0}')],
       [Item.of('minecraft:stone_shovel', '{Damage:0}')],
]
//定义添加权重物品[物品id,概率]
    let weightLootItem = [
       ['lightmanscurrency:coin_gold',1],//硬币与物品 金币
       ['farmersdelight:onion_crate',3],//农夫乐事 箱装洋葱
       ['meadow:wooden_warped_milk_bucket',3],
       ['cosmopolitan:strawberry_gulime',3],
       ['farmersdelight:tomato_crate',3],//农夫乐事 箱装番茄
       ['culturaldelights:eggplant_crate',3],//农夫乐事 箱装茄子
]
     let lootItem = [
        ['whimsy_deco:gatcha_capsule',0.15],//扭蛋胶囊
]
    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('simply_houses:chests/forest_fort/forest_fort_barrels')//森林城堡 木桶
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([1, 2], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('simply_houses:chests/forest_fort/forest_fort_barrels')//森林城堡 木桶 
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('simply_houses:chests/forest_fort/forest_fort_barrels')//森林石匠铺 木桶
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})

//针叶林铁匠铺 木桶
LootJS.modifiers(event => {//针叶林铁匠铺 木桶
    //定义删除物品,[物品id]
    let removeLoot = [
       ['minecraft:bread'],
       [Item.of('minecraft:iron_sword', '{Damage:0}')],
       ['touhou_little_maid:power_point'],
       [Item.of('minecraft:iron_helmet', '{Damage:0}')],
       ['minecraft:apple'],
       ['minecraft:saddle'],
       [Item.of('minecraft:iron_boots', '{Damage:0}')],
       ['minecraft:rose_bush'],
       [Item.of('minecraft:iron_pickaxe', '{Damage:0}')],
       ['minecraft:blue_orchid'],
       ['minecraft:oak_sapling'],
       ['minecraft:obsidian'],
       ['minecraft:lapis_lazuli'],
       [Item.of('minecraft:chainmail_leggings', '{Damage:0}')],
       [Item.of('minecraft:iron_leggings', '{Damage:0}')],
       ['minecraft:moss_block'],
       ['minecraft:slime_ball'],
       ['minecraft:iron_horse_armor'],
       [Item.of('minecraft:iron_chestplate', '{Damage:0}')],
       [Item.of('minecraft:stone_shovel', '{Damage:0}')],
]
//定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['farmersplus:sweet_berry_bag',3],//农夫增强 浆果袋
        ['exquisito:jelly_ring_crate',1],//果园 箱装苹果
        ['fruitsdelight:pear_crate',3],//果园 箱装李子
        ['fruitsdelight:persimmon_crate',3],//果园 箱装柿子
        ['lightmanscurrency:coin_gold',1],//硬币与物品 金币
    ]
 let lootItem = [
        ['whimsy_deco:gatcha_capsule',0.15],//扭蛋胶囊
]
    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('simply_houses:chests/taiga_forge/taiga_forge_barrels')////针叶林铁匠铺 木桶
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([1, 2], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('simply_houses:chests/taiga_forge/taiga_forge_barrels')////针叶林铁匠铺 木桶
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('simply_houses:chests/taiga_forge/taiga_forge_barrels')////针叶林铁匠铺 木桶
            .removeLoot(item)//删除遍历removeLoot的物品 

     })
})

//针叶林酒馆 木桶
LootJS.modifiers(event => {//针叶林铁匠铺 木桶
    //定义删除物品,[物品id]
    let removeLoot = [
       ['minecraft:bread'],
       [Item.of('minecraft:iron_sword', '{Damage:0}')],
       ['touhou_little_maid:power_point'],
       [Item.of('minecraft:iron_helmet', '{Damage:0}')],
       ['minecraft:apple'],
       ['minecraft:saddle'],
       [Item.of('minecraft:iron_boots', '{Damage:0}')],
       ['minecraft:rose_bush'],
       [Item.of('minecraft:iron_pickaxe', '{Damage:0}')],
       ['minecraft:blue_orchid'],
       ['minecraft:oak_sapling'],
       ['minecraft:obsidian'],
       ['minecraft:lapis_lazuli'],
       [Item.of('minecraft:chainmail_leggings', '{Damage:0}')],
       [Item.of('minecraft:iron_leggings', '{Damage:0}')],
       ['minecraft:moss_block'],
       ['minecraft:slime_ball'],
       ['minecraft:iron_horse_armor'],
       [Item.of('minecraft:iron_chestplate', '{Damage:0}')],
       [Item.of('minecraft:stone_shovel', '{Damage:0}')],
]
//定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['kitchenkarrot:rum',3],//朗姆酒
        ['kitchenkarrot:acorn_wine',3],//橡子酒
        ['kitchenkarrot:mead',3],//蜜酒
        ['lightmanscurrency:coin_gold',1],//硬币与物品 金币
    ]
 let lootItem = [
        ['whimsy_deco:gatcha_capsule',0.15],//扭蛋胶囊
]
    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('simply_houses:chests/taiga_inn/taiga_inn_barrels')////针叶林小酒馆 木桶
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([1, 2], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('simply_houses:chests/taiga_inn/taiga_inn_barrels')////针叶林小酒馆 木桶
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('simply_houses:chests/taiga_inn/taiga_inn_barrels')////针叶小酒馆 木桶
            .removeLoot(item)//删除遍历removeLoot的物品 

     })
})

//针叶林小酒馆 木桶
LootJS.modifiers(event => {//针叶林铁匠铺 木桶
    //定义删除物品,[物品id]
    let removeLoot = [
       ['minecraft:bread'],
       [Item.of('minecraft:iron_sword', '{Damage:0}')],
       ['touhou_little_maid:power_point'],
       [Item.of('minecraft:iron_helmet', '{Damage:0}')],
       ['minecraft:apple'],
       ['minecraft:saddle'],
       [Item.of('minecraft:iron_boots', '{Damage:0}')],
       ['minecraft:rose_bush'],
       [Item.of('minecraft:iron_pickaxe', '{Damage:0}')],
       ['minecraft:blue_orchid'],
       ['minecraft:oak_sapling'],
       ['minecraft:obsidian'],
       ['minecraft:lapis_lazuli'],
       [Item.of('minecraft:chainmail_leggings', '{Damage:0}')],
       [Item.of('minecraft:iron_leggings', '{Damage:0}')],
       ['minecraft:moss_block'],
       ['minecraft:slime_ball'],
       ['minecraft:iron_horse_armor'],
       [Item.of('minecraft:iron_chestplate', '{Damage:0}')],
       [Item.of('minecraft:stone_shovel', '{Damage:0}')],
]
//定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['farmersplus:sweet_berry_bag',3],//农夫增强 浆果袋
        ['fruitsdelight:apple_crate',3],//果园 箱装苹果
        ['fruitsdelight:pear_crate',3],//果园 箱装李子
        ['fruitsdelight:persimmon_crate',3],//果园 箱装柿子
        ['lightmanscurrency:coin_gold',1],//硬币与物品 金币
    ]
 let lootItem = [
        ['whimsy_deco:gatcha_capsule',0.15],//扭蛋胶囊
]
    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('simply_houses:chests/taiga_house/taiga_house_barrels')////针叶林房屋 木桶
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([1, 2], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('simply_houses:chests/taiga_house/taiga_house_barrels')////针叶林房屋 木桶
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('simply_houses:chests/taiga_house/taiga_house_barrels')////针叶林房屋 木桶
            .removeLoot(item)//删除遍历removeLoot的物品 

     })
})

//针叶林伐木场 木桶
LootJS.modifiers(event => {//针叶林伐木场 木桶
    //定义删除物品,[物品id]
    let removeLoot = [
       ['minecraft:bread'],
       [Item.of('minecraft:iron_sword', '{Damage:0}')],
       ['touhou_little_maid:power_point'],
       [Item.of('minecraft:iron_helmet', '{Damage:0}')],
       ['minecraft:apple'],
       ['minecraft:saddle'],
       [Item.of('minecraft:iron_boots', '{Damage:0}')],
       ['minecraft:rose_bush'],
       [Item.of('minecraft:iron_pickaxe', '{Damage:0}')],
       ['minecraft:blue_orchid'],
       ['minecraft:oak_sapling'],
       ['minecraft:obsidian'],
       ['minecraft:lapis_lazuli'],
       [Item.of('minecraft:chainmail_leggings', '{Damage:0}')],
       [Item.of('minecraft:iron_leggings', '{Damage:0}')],
       ['minecraft:moss_block'],
       ['minecraft:slime_ball'],
       ['minecraft:iron_horse_armor'],
       [Item.of('minecraft:iron_chestplate', '{Damage:0}')],
       [Item.of('minecraft:stone_shovel', '{Damage:0}')],
]
//定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['farmersplus:sweet_berry_bag',3],//农夫增强 浆果袋
        ['fruitsdelight:apple_crate',3],//果园 箱装苹果
        ['fruitsdelight:pear_crate',3],//果园 箱装李子
        ['fruitsdelight:persimmon_crate',3],//果园 箱装柿子
        ['lightmanscurrency:coin_gold',1],//硬币与物品 金币
    ]
 let lootItem = [
        ['whimsy_deco:gatcha_capsule',0.15],//扭蛋胶囊
]
    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('simply_houses:chests/taiga_woodcutter/taiga_woodcutter_barrels')////针叶伐木场 木桶
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([1, 2], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('simply_houses:chests/taiga_woodcutter/taiga_woodcutter_barrels')////针叶伐木场 木桶
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('simply_houses:chests/taiga_woodcutter/taiga_woodcutter_barrels')////针叶林房屋 木桶
            .removeLoot(item)//删除遍历removeLoot的物品 

     })
})

//平原房屋 木桶
LootJS.modifiers(event => {//平原房屋 木桶
    //定义删除物品,[物品id]
    let removeLoot = [
       ['minecraft:bread'],
       [Item.of('minecraft:iron_sword', '{Damage:0}')],
       ['touhou_little_maid:power_point'],
       [Item.of('minecraft:iron_helmet', '{Damage:0}')],
       ['minecraft:apple'],
       ['minecraft:saddle'],
       [Item.of('minecraft:iron_boots', '{Damage:0}')],
       ['minecraft:rose_bush'],
       [Item.of('minecraft:iron_pickaxe', '{Damage:0}')],
       ['minecraft:blue_orchid'],
       ['minecraft:oak_sapling'],
       ['minecraft:obsidian'],
       ['minecraft:lapis_lazuli'],
       [Item.of('minecraft:chainmail_leggings', '{Damage:0}')],
       [Item.of('minecraft:iron_leggings', '{Damage:0}')],
       ['minecraft:moss_block'],
       ['minecraft:slime_ball'],
       ['minecraft:iron_horse_armor'],
       [Item.of('minecraft:iron_chestplate', '{Damage:0}')],
       [Item.of('minecraft:stone_shovel', '{Damage:0}')],
]
//定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['incubation:chicken_egg_crate',3],//箱装鸡蛋
        ['rusticdelight:bell_pepper_green_crate',3],
        ['rusticdelight:bell_pepper_red_crate',3],
        ['rusticdelight:bell_pepper_yellow_crate',3],
        ['lightmanscurrency:coin_gold',1],//硬币与物品 金币
    ]
 let lootItem = [
        ['whimsy_deco:gatcha_capsule',0.15],//扭蛋胶囊
]
    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('simply_houses:chests/plains_house/plains_house_barrels')////平原房屋 木桶
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([1, 2], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('simply_houses:chests/plains_house/plains_house_barrels')//平原房屋 木桶
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('simply_houses:chests/plains_house/plains_house_barrels')//平原房屋 木桶
            .removeLoot(item)//删除遍历removeLoot的物品 

     })
})


//平原房屋
LootJS.modifiers(event => {//平原房屋
    //定义删除物品,[物品id]
    let removeLoot = [
       ['minecraft:bread'],
       [Item.of('minecraft:iron_sword', '{Damage:0}')],
       ['touhou_little_maid:power_point'],
       [Item.of('minecraft:iron_helmet', '{Damage:0}')],
       ['minecraft:apple'],
       ['minecraft:saddle'],
       [Item.of('minecraft:iron_boots', '{Damage:0}')],
       ['minecraft:rose_bush'],
       [Item.of('minecraft:iron_pickaxe', '{Damage:0}')],
       ['minecraft:blue_orchid'],
       ['minecraft:oak_sapling'],
       ['minecraft:obsidian'],
       ['minecraft:lapis_lazuli'],
       [Item.of('minecraft:chainmail_leggings', '{Damage:0}')],
       [Item.of('minecraft:iron_leggings', '{Damage:0}')],
       ['minecraft:moss_block'],
       ['minecraft:slime_ball'],
       ['minecraft:iron_horse_armor'],
       [Item.of('minecraft:iron_chestplate', '{Damage:0}')],
       [Item.of('minecraft:stone_shovel', '{Damage:0}')],
]
//定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['incubation:chicken_egg_crate',3],//箱装鸡蛋
        ['atmospheric:currant_crate',3],
        ['culturaldelights:white_eggplant_crate',3],
        ['atmospheric:currant_crate',3],
        ['lightmanscurrency:coin_gold',1],//硬币与物品 金币
    ]
 let lootItem = [
        ['whimsy_deco:gatcha_capsule',0.3],//扭蛋胶囊
        ['additionaladditions:rose_gold_alloy',0.15],//玫瑰金
        ['minecraft:firework_star',0.15],//烟火之星 
]
    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('simply_houses:chests/plains_house/plains_house_normal')////平原房屋
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([1, 2], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('simply_houses:chests/plains_house/plains_house_normal')//平原房屋
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('simply_houses:chests/plains_house/plains_house_normal')//平原房屋
            .removeLoot(item)//删除遍历removeLoot的物品 

     })
})

//平原府邸
LootJS.modifiers(event => {//平原房屋
    //定义删除物品,[物品id]
    let removeLoot = [
       ['minecraft:bread'],
       [Item.of('minecraft:iron_sword', '{Damage:0}')],
       ['touhou_little_maid:power_point'],
       [Item.of('minecraft:iron_helmet', '{Damage:0}')],
       ['minecraft:apple'],
       ['minecraft:saddle'],
       [Item.of('minecraft:iron_boots', '{Damage:0}')],
       ['minecraft:rose_bush'],
       [Item.of('minecraft:iron_pickaxe', '{Damage:0}')],
       ['minecraft:blue_orchid'],
       ['minecraft:oak_sapling'],
       ['minecraft:obsidian'],
       ['minecraft:lapis_lazuli'],
       [Item.of('minecraft:chainmail_leggings', '{Damage:0}')],
       [Item.of('minecraft:iron_leggings', '{Damage:0}')],
       ['minecraft:moss_block'],
       ['minecraft:slime_ball'],
       ['minecraft:iron_horse_armor'],
       [Item.of('minecraft:iron_chestplate', '{Damage:0}')],
       [Item.of('minecraft:stone_shovel', '{Damage:0}')],
]
//定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['incubation:turtle_egg_crate',3],//箱装海龟蛋
        ['vintagedelight:gearo_berry_bag',3],//
        ['ubesdelight:lemongrass_crate',3],//柠檬香草
        ['trailandtales_delight:pitcher_taro_crate',3],//箱装瓶子芋
        ['lightmanscurrency:coin_gold',1],//硬币与物品 金币
    ]
 let lootItem = [
        ['whimsy_deco:gatcha_capsule',0.3],//扭蛋胶囊
        ['additionaladditions:rose_gold_alloy',0.15],//玫瑰金
        ['minecraft:firework_star',0.15],//烟火之星 
]
    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('simply_houses:chests/plains_mansion/plains_mansion_treasure')////平原府邸
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([1, 2], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('simply_houses:chests/plains_mansion/plains_mansion_treasure')//平原府邸
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('simply_houses:chests/plains_mansion/plains_mansion_treasure')//平原府邸
            .removeLoot(item)//删除遍历removeLoot的物品 

     })
})

//平原府邸 木桶
LootJS.modifiers(event => {//平原房屋
    //定义删除物品,[物品id]
    let removeLoot = [
       ['minecraft:bread'],
       [Item.of('minecraft:iron_sword', '{Damage:0}')],
       ['touhou_little_maid:power_point'],
       [Item.of('minecraft:iron_helmet', '{Damage:0}')],
       ['minecraft:apple'],
       ['minecraft:saddle'],
       [Item.of('minecraft:iron_boots', '{Damage:0}')],
       ['minecraft:rose_bush'],
       [Item.of('minecraft:iron_pickaxe', '{Damage:0}')],
       ['minecraft:blue_orchid'],
       ['minecraft:oak_sapling'],
       ['minecraft:obsidian'],
       ['minecraft:lapis_lazuli'],
       [Item.of('minecraft:chainmail_leggings', '{Damage:0}')],
       [Item.of('minecraft:iron_leggings', '{Damage:0}')],
       ['minecraft:moss_block'],
       ['minecraft:slime_ball'],
       ['minecraft:iron_horse_armor'],
       [Item.of('minecraft:iron_chestplate', '{Damage:0}')],
       [Item.of('minecraft:stone_shovel', '{Damage:0}')],
]
//定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['incubation:chicken_egg_crate',3],//箱装鸡蛋
        ['braziliandelight:green_coconut_crate',3],//箱装椰青
        ['braziliandelight:guarana_fruit_crate',3],//箱装瓜拉纳果
        ['veggiesdelight:turnip_crate',3],//箱装芜菁
        ['lightmanscurrency:coin_gold',1],//硬币与物品 金币
    ]
 let lootItem = [
        ['whimsy_deco:gatcha_capsule',0.15],//扭蛋胶囊
]
    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('simply_houses:chests/plains_mansion/plains_mansion_barrels')////平原府邸 木桶
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([1, 2], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('simply_houses:chests/plains_mansion/plains_mansion_barrels')//平原府邸
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('simply_houses:chests/plains_mansion/plains_mansion_barrels')//平原府邸 木桶
            .removeLoot(item)//删除遍历removeLoot的物品 

     })
})

//要塞走廊
LootJS.modifiers(event => {//要塞走廊
    //定义删除物品,[物品id]
    let removeLoot = [
        ['minecraft:coal'],//煤炭
        ['minecraft:glow_berries'],//发光浆果
        ['minecraft:compass'],//指南针
        ['minecraft:beetroot_seeds'],//甜菜种子
        ['minecraft:melon_seeds'],//西瓜种子
        ['minecraft:rail'],//铁轨
        ['minecraft:powered_rail'],//动力铁轨
        ['minecraft:activator_rail'],//激活铁轨
        ['minecraft:detector_rail'],//探测铁轨
        ['minecraft:leather'],//皮革
        ['minecraft:iron_ingot'],//铁
        ['minecraft:gold_ingot'],//金
        ['minecraft:emerald'],//绿宝石
        ['minecraft:diamond'],//钻石
        ['minecraft:lapis_lazuli'],//青金石
        ['minecraft:redstone'],//红石
        ['additionaladditions:rope'],//绳子
        ['supplementaries:rope'],//绳索
        ['farmersdelight:rope'],//绳子
        ['additionaladditions:glow_stick'],//荧光棒
        ['muffins_thaidelight:pepper_seeds'],//辣椒种子
        ['minecraft:torch'],//火把
        ['dumplings_delight:chinese_cabbage_seeds'],//白菜种子
        [('minecraft:clock')],//钟
        [Item.of('minecraft:iron_axe')],//铁斧头
        ['farmersdelight:cabbage_seeds'],//卷心菜种子
        ['additionaladditions:rose_gold_upgrade'],//锻造模板
        ['minecraft:pumpkin_seeds'],//南瓜种子
        ['galosphere:silver_upgrade_smithing_template'],//锻造模板
        [Item.of('minecraft:potion', '{Potion:"ars_nouveau:mana_regen_potion_long"}')],//药水
        ['ars_nouveau:music_disc_aria_biblio'],//唱片
         ['minecraft:coal'],//煤炭
        ['minecraft:stone_axe'],//石斧
        ['minecraft:wheat'],//小麦
        ['minecraft:rotten_flesh'],//腐肉
        ['minecraft:leather_chestplate'],//皮革外套
        ['minecraft:leather'],//皮革
        ['minecraft:iron_nugget'],//铁粒
        ['minecraft:gold_nugget'],//金粒
        ['minecraft:emerald'],//绿宝石
        ['minecraft:gold_ingot'],//金
        ['minecraft:iron_ingot'],//铁
        ['additionaladditions:rose_gold_upgrade'],//锻造模板
        [Item.of('beachparty:rubber_ring_pelican', '{Damage:0}')],//泳圈
        ['beachparty:overgrown_disc'],//唱片
        ['minecraft:coast_armor_trim_smithing_template'],//锻造模板
        ['minecraft:lapis_lazuli'],//青金石
        ['rustic_engineer:book_abyssal_submarine'],//书
        ['ars_nouveau:pierce_arrow'],//箭
        [Item.of('minecraft:potion', '{Potion:"ars_nouveau:mana_regen_potion"}')],//药水
        ['ars_nouveau:amplify_arrow'],//强化箭
        [Item.of('minecraft:iron_pickaxe', '{Damage:0}')],
        [Item.of('minecraft:iron_pickaxe', '{Damage:0}')],
        ['ars_nouveau:split_arrow'],
        [Item.of('minecraft:iron_sword', '{Damage:0}')],
        ['touhou_little_maid:power_point'],
        [Item.of('minecraft:iron_chestplate', '{Damage:0}')],
        ['enigmaticlegacy:eye_of_nebula'],
    ]
    //定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['miners_delight:silverfish_eggs',1],//矿工乐事 蠹虫卵
        ['incubation:turtle_egg_crate',1],//箱装海龟蛋
        ['dungeonsdelight:silverfish_abdomen',2],//地牢乐事 蠹虫胸肉
        ['alexsmobs:cockroach_ootheca',2],//alex生物 蟑螂卵
        ['alexsmobs:leafcutter_ant_pupa',2],//alex生物 切叶蚁卵
        ['lightmanscurrency:coin_gold',5],//硬币与物品 金币
        ['alexsmobs:maggot',3],//alex生物 蛆
    ]
 let lootItem = [
        ['dungeonsdelight:silverfish_fried_rice',0.2],//地牢乐事 蠹虫炒饭
        ['dungeonsdelight:candied_silverfish_sucker',0.2],//地牢乐事 糖渍蠹虫棒棒糖
]
 //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('minecraft:chests/stronghold_corridor')//要塞走廊
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([2, 3], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('minecraft:chests/stronghold_corridor')//要塞走廊
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('minecraft:chests/stronghold_corridor')//要塞走廊
            .removeLoot(item)//删除遍历removeLoot的物品 

     })
})

//宝藏箱
LootJS.modifiers(event => {//宝藏箱
    //定义删除物品,[物品id]
    let removeLoot = [
        ['minecraft:iron_nugget'],//铁粒
        ['minecraft:gold_nugget'],//金粒
        ['minecraft:gold_ingot'],//金
        ['minecraft:iron_ingot'],//铁
        ['minecraft:emerald'],//绿宝石
        ['minecraft:diamond'],//钻石
        ['simplehats:hatbag_common'],//帽子袋
        ['ecologics:music_disc_coconut'],//唱片
        ['minecraft:tnt'],//tnt
        [Item.of('beachparty:rubber_ring_pelican', '{Damage:0}')],//泳圈
        ['touhou_little_maid:power_point'],//p点
        ['beachparty:overgrown_disc'],//唱片
        [Item.of('beachparty:rubber_ring_axolotl', '{Damage:0}')],//泳圈
        [Item.of('jellyfishing:jellyfish_net', '{Damage:0}')],//水母网
        ['touhou_little_maid:shrine'],//神龛
        [Item.of('minecraft:leather_chestplate', '{Damage:0}')],//皮革外套
        [Item.of('minecraft:iron_sword', '{Damage:0}')],//铁剑
    ]
 //定义添加权重物品[物品id,概率]
    let weightLootItem = [
       ['aquamirae:sea_stew',3],//海灵 海之炖菜
       ['aquamirae:sea_casserole',3],//海灵 海味砂锅
       ['aquaculture:neptunium_ingot',9],//水产 海王锭
       ['collectorsreap:sea_wrap',3],//海洋卷

    ]
 let lootItem = [
       ['aquamirae:poseidons_breakfast',0.2],//海灵 波塞冬早餐
       ['crockpot:moqueca',0.2],//烹饪锅 海鲜杂烩
       ['aquaculturedelight:turtle_meat_dish',0.2],//海味乐事 海龟肉料理
       ['aquaculture:neptunium_ingot',0.4]//水产 海王锭
]
 //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('minecraft:chests/buried_treasure')//宝藏箱
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([2, 3], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('minecraft:chests/buried_treasure')//宝藏箱
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('minecraft:chests/buried_treasure')//宝藏箱
            .removeLoot(item)//删除遍历removeLoot的物品 

     })
})

//冰寒迷宫木桶（海灵物语）
LootJS.modifiers(event => {//冰寒迷宫木桶（海灵物语）
    //定义删除物品,[物品id]
    let removeLoot = [
        ['minecraft:leather'],//皮革
        ['minecraft:stick'],//木棍
        ['touhou_little_maid:power_point'],//p点
    ]
    //定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['aquamirae:sharp_bones',1],//刺骨
        ['aquamirae:fin',1],//鳍
        ['aquamirae:spinefish',2],//棘鱼
        ['aquamirae:wisteria_niveis',2],//覆雪紫藤
        ['lightmanscurrency:coin_gold',3],//硬币与物品 金币 
        ['smc:broccoli',1],//西兰花
    ]
    let lootItem = [
        ['aquamirae:anglers_fang',0.1],//胺康尖牙
        ['aquamirae:sea_stew',0.05],//海之炖菜
    ]
//遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('aquamirae:chests/maze_camp_chest')//冰寒迷宫木桶（海灵物语）
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([1, 2], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('aquamirae:chests/maze_camp_chest')//冰寒迷宫木桶（海灵物语）
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('aquamirae:chests/maze_camp_chest')//冰寒迷宫木桶（海灵物语）
            .removeLoot(item)//删除遍历removeLoot的物品 

     })
})

//冰塔（trek）
LootJS.modifiers(event => {//冰塔（trek）
    //定义删除物品,[物品id]
    let removeLoot = [
        ['minecraft:string'],//线
        ['minecraft:arrow'],//箭
        ['minecraft:gold_nugget'],//金粒
        ['minecraft:spectral_arrow'],//光灵箭
        ['minecraft:iron_nugget'],//铁粒
        ['minecraft:chain'],//锁链
        ['minecraft:lava_bucket'],//熔岩桶
        ['minecraft:crossbow'],//弩
        ['minecraft:obsidian'],//黑曜石
        ['minecraft:bone_block'],//骨块
        ['minecraft:coal'],//煤炭
        ['minecraft:leather'],//皮革
        ['minecraft:wheat'],//小麦
        [Item.of('minecraft:tipped_arrow', '{Potion:"minecraft:weakness"}')],//虚弱箭
        ['touhou_little_maid:power_point'],//p点
    ]
    //定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['farmersdelight:melon_popsicle', 2],//西瓜冰棍
        ['aquamirae:wisteria_niveis', 2],//覆雪紫腾
        ['aquamirae:oxygelium', 2],//氧素草
        ['farmersdelight:melon_juice', 2],//西瓜汁
        ['twilightdelight:twilight_spring', 1],//暮色山泉
        ['lightmanscurrency:coin_gold',1],//硬币与物品 金币
    ]

    let lootItem = [
        ['manors_bounty:vanilla_chocolate_ice_cream', 0.2],//庄园馀事 经典双拼冰激凌
        ['manors_bounty:starfruit_ice_cream', 0.2],//庄园馀事 杨桃冰激凌
        ['manors_bounty:vanilla_ice_cream',0.2],//庄园馀事 香草冰激凌
        ['manors_bounty:chocolate_ice_cream',0.2],//庄园馀事 巧克力冰激凌
        ['manors_bounty:blueberry_ice_cream',0.2],//庄园馀事 蓝莓冰激凌
        ['manors_bounty:cherries_ice_cream',0.2],//庄园馀事 车厘子冰激凌
        ['manors_bounty:jalapeno_ice_cream',0.2],//庄园馀事 墨西哥辣椒冰激凌
        ['manors_bounty:blueberry_cherries_ice_cream',0.2],//庄园馀事 莓果双拼冰激凌
        ['manors_bounty:starfruit_jalapeno_ice_cream',0.2],//庄园馀事 命运双拼冰激凌
    ]
    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('trek:overworld/medium/tower_of_ice')//冰塔（trek）
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([1, 2], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('trek:overworld/medium/tower_of_ice')//冰塔（trek）
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('trek:overworld/medium/tower_of_ice')//冰塔（trek）
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})

///中型废弃聚落（trek）
LootJS.modifiers(event => {//冰塔（trek）
    //定义删除物品,[物品id]
    let removeLoot = [
        ['minecraft:wheat_seeds'],//小麦种子
        ['minecraft:iron_nugget'],//铁粒
        [Item.of('minecraft:stone_pickaxe', '{Damage:0}')],//石稿
        [Item.of('minecraft:leather_leggings', '{Damage:0}')],//皮革腿
    ]
    //定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['kitchenkarrot:canned_beef_potato',1],//土豆牛肉罐头
        ['kitchenkarrot:canned_mutton_pumpkin',1],//羊肉南瓜罐头
        ['kitchenkarrot:canned_candied_apple',1],//蜜蜂苹果罐头
        ['lightmanscurrency:coin_gold',3],//硬币与物品 金币 
    ]
    let lootItem = [

    ]
    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('trek:overworld/medium/all_abandoned')//中型废弃聚落（trek）
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([1, 2], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('trek:overworld/medium/all_abandoned')//中型废弃聚落（trek）
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('trek:overworld/medium/all_abandoned')//中型废弃聚落（trek）
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})

//掠夺者前哨站
LootJS.modifiers(event => {//掠夺者前哨站
    //定义删除物品,[物品id]
    let removeLoot = [
        ['galosphere:silver_upgrade_smithing_template'],//
        ['additionaladditions:rose_gold_upgrade'],//
        ['minecraft:wheat'],//
        ['minecraft:dark_oak_log'],//
        [Item.of('minecraft:iron_axe')],//
        ['simplehats:hatbag_common'],//
        [Item.of('minecraft:goat_horn')],//
        ['ars_nouveau:music_disc_firel_the_wild_hunt'],//
        [Item.of('minecraft:crossbow', '{Damage:0}')],//
        ['minecraft:string'],//
        ['minecraft:arrow'],//
        [Item.of('minecraft:iron_sword')],//
        ['touhou_little_maid:power_point'],//
        ['ars_nouveau:music_disc_aria_biblio'],//
        ['mischief_illagers:crazy_dynamite'],//
        ['bountifulfares:ceramic_clay'],//
        ['minecraft:sentry_armor_trim_smithing_template'],//
        ['minecraft:leather'],//
    ]
//定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['ltc2:illage_lime',3],//灾厄青柠
        ['kitchenkarrot:pillager_pie',1],//掠夺者派
        ['lightmanscurrency:coin_gold',3],//硬币与物品 金币 

    ]
    let lootItem = [
        ['ltc2:illage_sundae',0.2],//灾厄大圣代
        ['crockpot:bacon_eggs',0.2],//培根煎蛋
        ['veggiesdelight:sweet_potato_pancakes',0.2],//红薯煎饼
    ]
    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('minecraft:chests/pillager_outpost')////掠夺者前哨站
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([1, 2], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })
    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('minecraft:chests/pillager_outpost')//掠夺者前哨站
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('minecraft:chests/pillager_outpost')//中型废弃聚落（trek）
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})

//中型营地（trek）
LootJS.modifiers(event => {//中型营地（trek）
    //定义删除物品,[物品id]
    let removeLoot = [
    
]
    //定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['buzzier_bees:honey_bread',3],//蜂蜜面包
        [Item.of('fruitsdelight:jelly_bread', '{JellyEffectRoot:["APPLE"]}'),3],//苹果酱面包
        ['upgrade_aquatic:mulberry_bread',3],//桑葚面包
        ['lightmanscurrency:coin_gold',3],//硬币与物品 金币 

]
    let lootItem = [
        ['more_critters:bunbug_burger',0.2],//圆面包虫
]
    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('trek:overworld/medium/camp_1')//中型营地（trek）
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([1, 2], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })
    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('trek:overworld/medium/camp_1')//中型营地（trek）
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('trek:overworld/medium/camp_1')//中型营地（trek）
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})

//寒带藏身处（trek）
LootJS.modifiers(event => {//（trek）
    //定义删除物品,[物品id]
    let removeLoot = [
        ['minecraft:arrow'],
        [Item.of('minecraft:tipped_arrow', '{Potion:"minecraft:invisibility"}')],
        [Item.of('minecraft:tipped_arrow', '{Potion:"minecraft:slow_falling"}')],
        [Item.of('minecraft:bow')],
]
    //定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['neapolitan:strawberry_banana_smoothie',1],//那不勒斯 草莓冰沙
        ['peculiars:aloe_berry_smoothie',1],//独特风味 芦荟冰沙
        ['lightmanscurrency:coin_gold',3],//硬币与物品 金币 
    ]
    let lootItem = [
        ['kaleidoscope_cookery:frost_lamb_chop',0.2],//凛冬羊排
]
    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('trek:overworld/medium/ice_fort/bottom')//寒带藏身处（trek）
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([1, 2], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })
    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('trek:overworld/medium/ice_fort/bottom')//寒带藏身处（trek）
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('trek:overworld/medium/ice_fort/bottom')//寒带藏身处（trek）
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})


//寒带绯红交易所（trek）
LootJS.modifiers(event => {//（trek）
    //定义删除物品,[物品id]
    let removeLoot = [
        ['minecraft:hay_block'],
        ['minecraft:blue_ice'],
        ['touhou_little_maid:power_point'],
        ['minecraft:wheat'],
]
    //定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['aquaculturedelight:bass_stew',1],//鲈鱼炖菜
        ['crockpot:ceviche',1],//酸橘汁腌鱼
        ['crockpot:fish_sticks',1],//炸鱼
        ['minecraft:salmon',4],//生鲑鱼
        ['minecraft:cod',4],//生鳕鱼
        ['lightmanscurrency:coin_gold',3],//硬币与物品 金币 
    ]
    let lootItem = [
        ['kaleidoscope_cookery:stargazy_pie',0.2],//仰望星空派
        ['veggiesdelight:fish_and_chips',0.2],//炸鱼薯条
]
    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('trek:overworld/medium/cold_red_trade/capitan')//寒带绯红交易所（trek）
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([1, 2], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })
    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('trek:overworld/medium/cold_red_trade/capitan')//寒带绯红交易所（trek）
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('trek:overworld/medium/cold_red_trade/capitan')//寒带绯红交易所（trek）
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})


//旷野之塔（海上）
LootJS.modifiers(event => {//（trek）
    //定义删除物品,[物品id]
    let removeLoot = [
        ['minecraft:hay_block'],
        ['minecraft:blue_ice'],
        ['touhou_little_maid:power_point'],
        ['minecraft:wheat'],
]
    //定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['aquaculture:turtle_soup',1],//海龟汤
        ['aquaculturedelight:small_turtle_meat',4],//海龟肉片
        ['minecraft:turtle_egg',4],//海龟蛋
        ['lightmanscurrency:coin_gold',3],//硬币与物品 金币 
    ]
    let lootItem = [
        
]
    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('totw_modded:ocean_tower_chest')//旷野之塔（海上）
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([1, 2], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })
    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('totw_modded:ocean_tower_chest')//旷野之塔（海上）
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })
    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('totw_modded:ocean_tower_chest')//旷野之塔（海上）
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})


//深色橡木交易所（trek）
LootJS.modifiers(event => {//（trek）
    //定义删除物品,[物品id]
    let removeLoot = [
        ['minecraft:writable_book'],
        ['minecraft:paper'],
        ['touhou_little_maid:power_point'],
]
    //定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['oceanic_delight:sea_grape',4],//海葡萄
        ['jellyfishing:seanut',4],//海花生
        ['oceanic_delight:sea_salad',1],//海沙拉
        ['lightmanscurrency:coin_gold',3],//硬币与物品 金币 
    ]
    let lootItem = [
        ['crockpot:surf_n_turf',0.2],//海鲜牛排
        ['oceanic_delight:sea_grape',0.5],//海葡萄
        ['jellyfishing:seanut',0.5],//海花生
]
    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('trek:overworld/medium/dark_oak_trade')//深色橡木交易所（trek）
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([1, 2], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })
    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('trek:overworld/medium/dark_oak_trade')//深色橡木交易所（trek）
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })
    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('trek:overworld/medium/dark_oak_trade')//深色橡木交易所（trek）
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})


//沙漠前哨站（trek）
LootJS.modifiers(event => {//沙漠前哨站（trek）
    //定义删除物品,[物品id]
    let removeLoot = [
       ['minecraft:lantern'],
       ['minecraft:cut_sandstone'],
       ['touhou_little_maid:power_point'],
    ]
//定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['ltc2:illage_lime',3],//灾厄青柠
        ['kitchenkarrot:pillager_pie',1],//掠夺者派
        ['lightmanscurrency:coin_gold',3],//硬币与物品 金币 
    ]
    let lootItem = [
        ['ltc2:illage_sundae',0.2],//灾厄大圣代
        ['kaleidoscope_cookery:desert_style_sashimi',0.2],//沙漠风味刺身
    ]
    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('trek:pillagers/outpost_desert')//沙漠前哨站（trek）
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([2, 3], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })
    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('trek:pillagers/outpost_desert')//沙漠前哨站（trek）
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('trek:pillagers/outpost_desert')//沙漠前哨站（trek）
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})

//探险者小屋（trek）
LootJS.modifiers(event => {//沙漠前哨站（trek）
    //定义删除物品,[物品id]
    let removeLoot = [
       ['minecraft:iron_nugget'],
       ['touhou_little_maid:power_point'],
       ['minecraft:bone_meal'],
       ['minecraft:feather'],
    ]
//定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['collectorsreap:black_tea_gummy',3],//红茶软糖
        ['collectorsreap:coffee_gummy',3],//咖啡软糖
        ['collectorsreap:yellow_tea_gummy',3],//黄茶软糖
        ['minecraft:golden_apple',1],//金苹果
        ['lightmanscurrency:coin_gold',3],//硬币与物品 金币 
    ]
    let lootItem = [
        ['confluence:anklet_of_the_wind',0.2],//疾风脚镯
        ['confluence:aglet',0.2],//金属带扣
    ]
    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('trek:overworld/medium/explorer_cabin/default_2')//探险者小屋（trek）
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([2, 3], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })
    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('trek:overworld/medium/explorer_cabin/default_2')//探险者小屋（trek）
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('trek:overworld/medium/explorer_cabin/default_2')//探险者小屋（trek）
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})

//堡垒（trek）
LootJS.modifiers(event => {///堡垒（trek）
    //定义删除物品,[物品id]
    let removeLoot = [
       ['minecraft:wheat'],
       ['minecraft:rotten_flesh'],
       [Item.of('minecraft:bow', '{Damage:0}')],
       ['touhou_little_maid:power_point'],
       ['minecraft:gunpowder'],
       ['minecraft:lantern'],
       ['minecraft:tnt'],
    ]
//定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['ltc2:illage_lime',5],//灾厄青柠
        ['kitchenkarrot:pillager_pie',1],//掠夺者派
        ['farmersplus:pork_patty',2],//猪肉饼
        ['kitchenkarrot:beef_grains',2],//牛肉粒
        ['lightmanscurrency:coin_gold',3],//硬币与物品 金币 
    ]
    let lootItem = [
       ['ltc2:illage_sundae',0.2],//灾厄大圣代
       ['youkaishomecoming:pork_rice_ball',0.2],//猪肉饭团
       ['barbequesdelight:grilled_pork_sausage_skewer',0.2],//烤猪肉香肠
    ]
    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('trek:overworld/medium/fort')//堡垒（trek）
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([2, 3], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })
    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('trek:overworld/medium/fort')//堡垒（trek）
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('trek:overworld/medium/fort')//堡垒（trek）
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})

//泥屋（trek）
LootJS.modifiers(event => {//泥屋（trek）
    //定义删除物品,[物品id]
    let removeLoot = [
       
    ]
//定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['smc:cooked_dirt',2],//烤泥土
        ['slime_delight:slice_of_grass_block_cake',1],//草方块蛋糕切片
        ['lightmanscurrency:coin_gold',3],//硬币与物品 金币 
    ]
    let lootItem = [
       ['smc:grass_block_pie',0.2],//草方派
    ]
    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('trek:overworld/medium/dirt_hut')//泥屋（trek）
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([1, 2], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })
    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('trek:overworld/medium/dirt_hut')//泥屋（trek）
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('trek:overworld/medium/dirt_hut')///泥屋（trek）
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})

//橡木流浪商人营地（trek）1
LootJS.modifiers(event => {//橡木流浪商人营地（trek）1
    //定义删除物品,[物品id]
    let removeLoot = [
       ['minecraft:beetroot_seeds'],
    ]
//定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['cosmopolitan:llama_marshmallow_trader',2],//行商羊驼棉花糖
        ['cosmopolitan:llama_marshmallow_trader',1],//流浪吉拉朵
        ['lightmanscurrency:coin_gold',3],//硬币与物品 金币 
    ]
    let lootItem = [
       
    ]
    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('trek:overworld/medium/wandering_traders/1')///橡木流浪商人营地（trek）1
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([1, 2], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })
    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('trek:overworld/medium/wandering_traders/1')//橡木流浪商人营地（trek）1
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('trek:overworld/medium/wandering_traders/1')//橡木流浪商人营地（trek）1
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})


//橡木流浪商人营地（trek）2
LootJS.modifiers(event => {//橡木流浪商人营地（trek）3
    //定义删除物品,[物品id]
    let removeLoot = [
       ['minecraft:beetroot_seeds'],
    ]
//定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['cosmopolitan:llama_marshmallow_trader',2],//行商羊驼棉花糖
        ['cosmopolitan:llama_marshmallow_trader',1],//流浪吉拉朵
        ['lightmanscurrency:coin_gold',3],//硬币与物品 金币 
    ]
    let lootItem = [
       
    ]
    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('trek:overworld/medium/wandering_traders/2')///橡木流浪商人营地（trek）2
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([1, 2], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })
    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('trek:overworld/medium/wandering_traders/2')//橡木流浪商人营地（trek）2
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('trek:overworld/medium/wandering_traders/2')//橡木流浪商人营地（trek）2
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})

//橡木流浪商人营地（trek）3
LootJS.modifiers(event => {//橡木流浪商人营地（trek）3
    //定义删除物品,[物品id]
    let removeLoot = [
       ['minecraft:beetroot_seeds'],
    ]
//定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['cosmopolitan:llama_marshmallow_trader',2],//行商羊驼棉花糖
        ['cosmopolitan:llama_marshmallow_trader',1],//流浪吉拉朵
        ['lightmanscurrency:coin_gold',3],//硬币与物品 金币 
    ]
    let lootItem = [
       
    ]
    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('trek:overworld/medium/wandering_traders/3')///橡木流浪商人营地（trek）3
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([1, 2], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })
    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('trek:overworld/medium/wandering_traders/3')//橡木流浪商人营地（trek）3
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('trek:overworld/medium/wandering_traders/3')//橡木流浪商人营地（trek）2
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})


//水井（trek）
LootJS.modifiers(event => {//水井（trek）
    //定义删除物品,[物品id]
    let removeLoot = [
       ['minecraft:beetroot_seeds'],
    ]
//定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['dungeonsdelight:brined_flesh',2],//盐水肉
        ['lightmanscurrency:coin_gold',3],//硬币与物品 金币 
    ]
    let lootItem = [
       ['dungeonsdelight:salt_soaked_stew',0.3],//盐水炖
    ]
    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('trek:overworld/common/well')//水井（trek）
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([1, 2], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })
    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('trek:overworld/common/well')//水井（trek）
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('trek:overworld/common/well')//水井（trek）
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})

//墓地（trek）
LootJS.modifiers(event => {//墓地（trek）
    //定义删除物品,[物品id]
    let removeLoot = [
       ['minecraft:beetroot_seeds'],
    ]
//定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['immortalers_delight:rotten_flesh_cuts',2],//腐肉碎
        ['lightmanscurrency:coin_gold',3],//硬币与物品 金币 
    ]
    let lootItem = [
       [Item.of('galosphere:preserved_flesh', '{Damage:0}'),0.3],//腌腐肉
       ['crockpot:bone_soup',0.2],//骨头汤
    ]
    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('trek:overworld/medium/graveyard')//墓地（trek）
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([1, 2], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })
    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('trek:overworld/medium/graveyard')//墓地（trek）
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('trek:overworld/medium/graveyard')//墓地（trek）
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})


//地洞居所
LootJS.modifiers(event => {//地洞居所
    //定义删除物品,[物品id]
    let removeLoot = [
       
    ]
//定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['smc:cooked_dirt',2],//烤泥土
        ['slime_delight:slice_of_grass_block_cake',1],//草方块蛋糕切片
        ['lightmanscurrency:coin_gold',3],//硬币与物品 金币 
    ]
    let lootItem = [
       ['smc:grass_block_pie',0.2],//草方派
    ]
    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('trek:overworld/medium/hobbit_hole')////地洞居所
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([1, 2], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })
    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('trek:overworld/medium/hobbit_hole')//地洞居所
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('trek:overworld/medium/hobbit_hole')//地洞居所
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})


//鬼屋（trek）
LootJS.modifiers(event => {//鬼屋（trek）
    //定义删除物品,[物品id]
    let removeLoot = [
       
    ]
//定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['farm_and_charm:farmers_bread',1],//农夫面包
        ['veggiesdelight:cauliflower_bread',1],//花椰菜面包
        ['lightmanscurrency:coin_gold',3],//硬币与物品 金币 
    ]
    let lootItem = [
       ['alexsdelight:gongylidia_bruschetta',0.2],//蜈蚣面包片
    ]
    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('trek:overworld/medium/haunted_house')//鬼屋（trek）
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([1, 2], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })
    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('trek:overworld/medium/haunted_house')//鬼屋（trek）
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('trek:overworld/medium/haunted_house')//鬼屋（trek）
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})


//冰堡（trek） top
LootJS.modifiers(event => {//冰堡（trek）
    //定义删除物品,[物品id]
    let removeLoot = [
       
    ]
//定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['cosmopolitan:snow_cone',1],//
        ['cosmopolitan:vanilla_ice_cream_cone',1],//
        ['cosmopolitan:starcloud_ice_cream_cone',1],//
        ['cosmopolitan:jelly_ring_ice_cream_cone',1],//
        ['cosmopolitan:azure_berry_ice_cream_cone',1],//甜筒
        ['lightmanscurrency:coin_gold',3],//硬币与物品 金币 
    
    ]
    let lootItem = [
       ['ltc2:rare_pepper_frost_latiao',0.3],//
       ['ltc2:superior_pepper_frost_latiao',0.2],//冰镇辣条
    ]
    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('trek:overworld/medium/ice_fort/top')//冰堡（trek）top
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([1, 2], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })
    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('trek:overworld/medium/ice_fort/top')//冰堡（trek）top
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('trek:overworld/medium/ice_fort/top')//冰堡（trek）top
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})


//丛林前哨站（trek）
LootJS.modifiers(event => {//丛林前哨站（trek）
    //定义删除物品,[物品id]
    let removeLoot = [
       ['minecraft:wheat'],
       ['minecraft:rotten_flesh'],
       [Item.of('minecraft:bow', '{Damage:0}')],
       ['touhou_little_maid:power_point'],
       ['minecraft:gunpowder'],
       ['minecraft:lantern'],
       ['minecraft:tnt'],
    ]
//定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['ltc2:illage_lime',5],//灾厄青柠
        ['kitchenkarrot:pillager_pie',1],//掠夺者派
        ['farmersplus:pork_patty',2],//猪肉饼
        ['kitchenkarrot:beef_grains',2],//牛肉粒
        ['lightmanscurrency:coin_gold',3],//硬币与物品 金币 
    ]
    let lootItem = [
       ['ltc2:illage_sundae',0.2],//灾厄大圣代
       ['youkaishomecoming:pork_rice_ball',0.2],//猪肉饭团
       ['barbequesdelight:grilled_pork_sausage_skewer',0.2],//烤猪肉香肠
    ]
    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('trek:pillagers/outpost_jungle')//丛林前哨站（trek）
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([2, 3], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })
    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('trek:pillagers/outpost_jungle')//丛林前哨站（trek）
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('trek:pillagers/outpost_jungle')//丛林前哨站（trek）
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})


//丛林树屋（trek）
LootJS.modifiers(event => {//丛林树屋（trek）
    //定义删除物品,[物品id]
    let removeLoot = [
      
    ]
//定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['alexscaves:hot_chocolate_bottle',1],//热巧克力瓶
        ['lightmanscurrency:coin_gold',3],//硬币与物品 金币 

    ]
    let lootItem = [
       ['youkaishomecoming:higi_chocolate',0.3],//秘仪巧克力
       ['immortalers_delight:scarlet_devils_cake',0.1],//红魔鬼蛋糕
    ]
    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('trek:overworld/medium/jungle_treehouse')//丛林树屋（trek）
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([2, 3], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })
    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('trek:overworld/medium/jungle_treehouse')//丛林树屋（trek）
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('trek:overworld/medium/jungle_treehouse')//丛林树屋（trek））
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})


//林间府邸（trek）
LootJS.modifiers(event => {//林间府邸（trek）
    //定义删除物品,[物品id]
    let removeLoot = [
      
    ]
//定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['minecraft:beetroot_soup',1],//甜菜汤
        ['minecraft:mushroom_stew',1],//蘑菇煲
        ['minecraft:rabbit_stew',1],//兔肉煲
        ['lightmanscurrency:coin_gold',3],//硬币与物品 金币 

    ]
    let lootItem = [
       ['vanillacookbook:sword_lollipop',0.3],//棒棒糖剑

    ]
    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('trek:overworld/medium/maison')//林间府邸（trek）
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([2, 3], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })
    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('trek:overworld/medium/maison')//林间府邸（trek）
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('trek:overworld/medium/maison')//林间府邸（trek））
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})


//红树林瞭望塔（trek）
LootJS.modifiers(event => {//红树林瞭望塔（trek）
    //定义删除物品,[物品id]
    let removeLoot = [
       ['minecraft:wheat'],
       ['minecraft:rotten_flesh'],
       [Item.of('minecraft:bow', '{Damage:0}')],
       ['touhou_little_maid:power_point'],
       ['minecraft:gunpowder'],
       ['minecraft:lantern'],
       ['minecraft:tnt'],
       ['minecraft:rotten_flesh'],
    ]
//定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['ltc2:illage_lime',5],//灾厄青柠
        ['kitchenkarrot:pillager_pie',1],//掠夺者派
        ['farmersplus:pork_patty',2],//猪肉饼
        ['kitchenkarrot:beef_grains',2],//牛肉粒
        ['lightmanscurrency:coin_gold',3],//硬币与物品 金币 
    ]
    let lootItem = [
       ['ltc2:illage_sundae',0.2],//灾厄大圣代
       ['youkaishomecoming:pork_rice_ball',0.2],//猪肉饭团
       ['barbequesdelight:grilled_pork_sausage_skewer',0.2],//烤猪肉香肠
    ]
    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('trek:overworld/medium/mangrove_watchtowers')//红树林瞭望塔（trek）
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([2, 3], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })
    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('trek:overworld/medium/mangrove_watchtowers')//红树林瞭望塔trek）
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('trek:overworld/medium/mangrove_watchtowers')//红树林瞭望塔（trek）
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})


//海上掠夺者营地（trek）
LootJS.modifiers(event => {//海上掠夺者营地（trek）
    //定义删除物品,[物品id]
    let removeLoot = [
       ['minecraft:wheat'],
       ['minecraft:rotten_flesh'],
       [Item.of('minecraft:bow', '{Damage:0}')],
       ['touhou_little_maid:power_point'],
       ['minecraft:gunpowder'],
       ['minecraft:lantern'],
       ['minecraft:tnt'],
       ['minecraft:rotten_flesh'],
    ]
//定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['ltc2:illage_lime',5],//灾厄青柠
        ['kitchenkarrot:pillager_pie',1],//掠夺者派
        ['oceanic_delight:sea_grape',4],//海葡萄
        ['jellyfishing:seanut',4],//海花生
        ['oceanic_delight:sea_salad',1],//海沙拉
        ['lightmanscurrency:coin_gold',3],//硬币与物品 金币 
    ]
    let lootItem = [
       ['ltc2:illage_sundae',0.2],//灾厄大圣代
       ['kaleidoscope_cookery:stargazy_pie',0.2],//仰望星空派
       ['veggiesdelight:fish_and_chips',0.2],//炸鱼薯条
    ]
    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('trek:pillagers/ocean')//海上掠夺者营地（trek）
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([2, 3], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })
    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('trek:pillagers/ocean')//海上掠夺者营地（trek）
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('trek:pillagers/ocean')//海上掠夺者营地（trek）
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})


//平原小屋（trek）
LootJS.modifiers(event => {//平原小屋（trek）
    //定义删除物品,[物品id]
    let removeLoot = [
      
    ]
//定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['minecraft:beetroot_soup',1],//甜菜汤
        ['minecraft:mushroom_stew',1],//蘑菇煲
        ['minecraft:rabbit_stew',1],//兔肉煲
        ['lightmanscurrency:coin_gold',3],//硬币与物品 金币 

    ]
    let lootItem = [
       ['vanillacookbook:sword_lollipop',0.3],//棒棒糖剑

    ]
    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('trek:overworld/medium/plains_cottage/1_floor')//平原小屋（trek）
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([2, 3], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })
    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('trek:overworld/medium/plains_cottage/1_floor')//平原小屋（trek）
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('trek:overworld/medium/plains_cottage/1_floor')//平原小屋（trek）
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})


//平原小屋（trek）2bed
LootJS.modifiers(event => {//平原小屋（trek）2
    //定义删除物品,[物品id]
    let removeLoot = [
      
    ]
//定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['kitchenkarrot:fresh_salad',3],//清新沙拉
        ['kitchenkarrot:flower_cake',1],//鲜花饼
        ['lightmanscurrency:coin_gold',3],//硬币与物品 金币 
        
    ]
    let lootItem = [    

    ]
    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('trek:overworld/medium/plains_cottage/2_floor_bed')//平原小屋（trek）2bed
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([2, 3], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })
    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('trek:overworld/medium/plains_cottage/2_floor_bed')//平原小屋（trek）2bed
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('trek:overworld/medium/plains_cottage/2_floor_bed')//平原小屋（trek）2bed
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})


//废弃矿道（trek）
LootJS.modifiers(event => {//废弃矿道（trek）
    //定义删除物品,[物品id]
    let removeLoot = [
      
    ]
//定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['galospheric_delight:lumiere_cupcake',1],//幽蓝晶杯糕
        ['galospheric_delight:allurite_cupcake',1],//荧黄晶杯糕
        ['galospheric_delight:amethyst_cupcake',1],//紫晶杯糕
        ['lightmanscurrency:coin_gold',3],//硬币与物品 金币 
    ]
    let lootItem = [    

    ]
    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('trek:overworld/medium/railroad/coal')//废弃矿道（trek）
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([2, 3], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })
    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('trek:overworld/medium/railroad/coal')////废弃矿道（trek）
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('trek:overworld/medium/railroad/coal')//废弃矿道（trek）
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})


//船骸废墟（trek）
LootJS.modifiers(event => {//船骸废墟（trek）
    //定义删除物品,[物品id]
    let removeLoot = [
       
    ]
//定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['oceanic_delight:sea_grape',4],//海葡萄
        ['jellyfishing:seanut',4],//海花生
        ['oceanic_delight:sea_salad',1],//海沙拉
        ['lightmanscurrency:coin_gold',3],//硬币与物品 金币 
    ]
    let lootItem = [
       ['kaleidoscope_cookery:stargazy_pie',0.2],//仰望星空派
    ]
    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('trek:overworld/medium/ruine_bateaux')////船骸废墟（trek）
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([2, 3], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })
    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('trek:overworld/medium/ruine_bateaux')//船骸废墟（trek）
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('trek:overworld/medium/ruine_bateaux')//船骸废墟（trek）
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})


//毁坏的小屋(trek)
LootJS.modifiers(event => {//毁坏的小屋(trek)
    //定义删除物品,[物品id]
    let removeLoot = [
       
    ]
//定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['simple_cream:rotten_ice_cream',1],//腐败冰激凌
        ['crabbersdelight:jar_of_pickles',1],//海泡菜
        ['lightmanscurrency:coin_gold',3],//硬币与物品 金币 
    ]
    let lootItem = [

    ]
    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('trek:overworld/medium/ruine_cabane')//毁坏的小屋(trek)
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([2, 3], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })
    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('trek:overworld/medium/ruine_cabane')//毁坏的小屋(trek)
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('trek:overworld/medium/ruine_cabane')//船骸废墟（trek）
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})


//小型绯红交易所（trek）
LootJS.modifiers(event => {//小型绯红交易所（trek）
    //定义删除物品,[物品id]
    let removeLoot = [
        ['minecraft:hay_block'],
        ['minecraft:blue_ice'],
        ['touhou_little_maid:power_point'],
        ['minecraft:wheat'],
]
    //定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['aquaculturedelight:bass_stew',1],//鲈鱼炖菜
        ['crockpot:ceviche',1],//酸橘汁腌鱼
        ['crockpot:fish_sticks',1],//炸鱼
        ['minecraft:salmon',4],//生鲑鱼
        ['minecraft:cod',4],//生鳕鱼
        ['lightmanscurrency:coin_gold',3],//硬币与物品 金币 
    ]
    let lootItem = [
        ['kaleidoscope_cookery:stargazy_pie',0.2],//仰望星空派
        ['veggiesdelight:fish_and_chips',0.2],//炸鱼薯条
]
    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('trek:overworld/medium/small_red_trade')//小型绯红交易所（trek）
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([1, 2], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })
    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('trek:overworld/medium/small_red_trade')//小型绯红交易所（trek）
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('trek:overworld/medium/small_red_trade')//小型绯红交易所（trek）
            .removeLoot(item)//删除遍历removeLoot的物品

     })
}) 



//巨型雪人（trek）
LootJS.modifiers(event => {//巨型雪人（trek）
    //定义删除物品,[物品id]
    let removeLoot = [
       
    ]
//定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['cosmopolitan:snow_cone',1],//
        ['cosmopolitan:vanilla_ice_cream_cone',1],//
        ['cosmopolitan:starcloud_ice_cream_cone',1],//
        ['cosmopolitan:jelly_ring_ice_cream_cone',1],//
        ['cosmopolitan:azure_berry_ice_cream_cone',1],//甜筒
        ['lightmanscurrency:coin_gold',3],//硬币与物品 金币 
    
    ]
    let lootItem = [
       ['ltc2:rare_pepper_frost_latiao',0.3],//
       ['ltc2:superior_pepper_frost_latiao',0.2],//冰镇辣条
    ]
    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('trek:overworld/medium/snowman')//巨型雪人（trek）
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([1, 2], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })
    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('trek:overworld/medium/snowman')//巨型雪人（trek）
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('trek:overworld/medium/snowman')//巨型雪人（trek）
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})


//巫师小屋(trek)
LootJS.modifiers(event => {//巫师小屋(trek)
    //定义删除物品,[物品id]
    let removeLoot = [
       
    ]
//定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['neapolitan:chocolate_spider_eye',1],//巧克力蛛眼
        ['lightmanscurrency:coin_gold',3],//硬币与物品 金币 
    
    ]
    let lootItem = [
       ['dungeonsdelight:spider_tanghulu',0.3],//蜘蛛眼糖葫芦
       ['crockpot:hot_chili',0.2],//辣炖肉
    ]
    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('trek:overworld/medium/sorcerers_house')//巫师小屋(trek)
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([1, 2], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })
    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('trek:overworld/medium/sorcerers_house')//巫师小屋(trek)
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('trek:overworld/medium/sorcerers_house')//巫师小屋(trek)
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})


//高脚屋群（trek）
LootJS.modifiers(event => {//高脚屋群（trek）
    //定义删除物品,[物品id]
    let removeLoot = [
        ['minecraft:feather'],
        ['minecraft:gold_nugget'],
        ['minecraft:map'],
        ['minecraft:compass'],
        ['minecraft:iron_ingot'],
        ['minecraft:ender_pearl'],
        ['touhou_little_maid:power_point'],
]

     //定义添加权重物品[物品id,概率]
    let weightLootItem = [
        [Item.of('minecraft:firework_rocket', '{Fireworks:{Flight:3b}}'),1],//烟花火箭
        ['minecraft:phantom_membrane',3],//幻翼膜
        ['smc:ice_tea',1],//星喵 冰红茶
        ['cosmopolitan:llama_marshmallow',2],
        ['cosmopolitan:llama_marshmallow_brown',2],
        ['cosmopolitan:llama_marshmallow_trader',2],//棉花糖
        ['lightmanscurrency:coin_gold',3],//硬币与物品 金币 
    ]
     let lootItem = [
        ['artifacts:umbrella',0.2],//奇异饰品 雨伞
        ['confluence:lucky_horseshoe',0.2]//泰拉饰品 幸运马掌
    ]

    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('trek:overworld/medium/stelzens')////高脚屋群（trek）
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([2, 4], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('trek:overworld/medium/stelzens')//高脚屋群（trek）
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('trek:overworld/medium/stelzens')//高脚屋群（trek）
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})


//瞭望塔（trek）
LootJS.modifiers(event => {//瞭望塔（trek）
    //定义删除物品,[物品id]
    let removeLoot = [
        ['minecraft:feather'],
        ['minecraft:gold_nugget'],
        ['minecraft:map'],
        ['minecraft:compass'],
        ['minecraft:iron_ingot'],
        ['minecraft:ender_pearl'],
        ['touhou_little_maid:power_point'],
]

     //定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['kaleidoscope_cookery:mantou',2],//馒头
        ['kaleidoscope_cookery:baozi',2],//包子
        ['lightmanscurrency:coin_gold',3],//硬币与物品 金币 
    ]
     let lootItem = [
        ['kaleidoscope_cookery:delicious_egg_fried_rice',0.2],//美味蛋炒饭
    ]

    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('trek:overworld/medium/tours')//瞭望塔（trek）
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([2, 4], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('trek:overworld/medium/tours')//瞭望塔（trek）
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('trek:overworld/medium/tours')///瞭望塔（trek）
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})

//高塔（trek）
LootJS.modifiers(event => {//高塔（trek）
    //定义删除物品,[物品id]
    let removeLoot = [
        ['minecraft:feather'],
        ['minecraft:gold_nugget'],
        ['minecraft:map'],
        ['minecraft:compass'],
        ['minecraft:iron_ingot'],
        ['minecraft:ender_pearl'],
        ['touhou_little_maid:power_point'],
]

     //定义添加权重物品[物品id,概率]
    let weightLootItem = [
        [Item.of('minecraft:firework_rocket', '{Fireworks:{Flight:3b}}'),1],//烟花火箭
        ['minecraft:phantom_membrane',3],//幻翼膜
        ['smc:ice_tea',1],//星喵 冰红茶
        ['cosmopolitan:travelers_panini',2],//旅者帕尼尼
        ['cosmopolitan:wandering_gelat',2],//流浪吉拉朵
        ['lightmanscurrency:coin_gold',3],//硬币与物品 金币 
    ]
     let lootItem = [
        ['artifacts:umbrella',0.2],//奇异饰品 雨伞
        ['confluence:lucky_horseshoe',0.2]//泰拉饰品 幸运马掌
    ]

    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('trek:overworld/medium/tower')//高塔（trek）
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([2, 4], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('trek:overworld/medium/tower')//高塔（trek）
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('trek:overworld/medium/tower')//高塔（trek）
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})


//古代岩层（terramity）
LootJS.modifiers(event => {//古代岩层（terramity）
    //定义删除物品,[物品id]
    let removeLoot = [
       ['minecraft:oak_planks'],
       ['minecraft:torch'],
       ['minecraft:string'],
       ['minecraft:gunpowder'],
]

     //定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['lightmanscurrency:coin_gold',3],//硬币与物品 金币 
        ['terramity:chthonic_crystal',1],//幽冥水晶
        ['enlightened_end:ancient_root',1],//古根
    ]
     let lootItem = [
        ['lethality:mate',0.3],//苦马黛茶
        ['lethality:mate_dulce',0.3],//甜马黛茶       
    ]

    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('terramity:chests/subterranean_shrine_loot')//古代岩层（terramity）
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([2, 4], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('terramity:chests/subterranean_shrine_loot')//古代岩层（terramity）
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('terramity:chests/subterranean_shrine_loot')//古代岩层（terramity）
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})


//幽冥地牢（terramity）
LootJS.modifiers(event => {////幽冥地牢（terramity）
    //定义删除物品,[物品id]
    let removeLoot = [
       ['minecraft:oak_planks'],
       ['minecraft:torch'],
       ['minecraft:string'],
       ['minecraft:gunpowder'],
       ['minecraft:blackstone'],
       ['minecraft:basalt'],
       ['terramity:stygian_bud'],
]

     //定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['lightmanscurrency:coin_gold',3],//硬币与物品 金币 
        ['terramity:chthonic_crystal',1],//幽冥水晶
        ['minecraft:rabbit_foot',5],//兔子脚
        ['terramity:empty_essence',2],//虚无本质
    ]
     let lootItem = [
        ['lethality:mate',0.3],//苦马黛茶
        ['lethality:mate_dulce',0.3],//甜马黛茶
        ['terramity:lucky_dice',0.2],//幸运骰子
        ['terramity:devils_dice',0.1],//魔鬼骰子
        ['terramity:nullifying_dice',0.1],//无效化骰子
    ]

    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('terramity:chests/chthonic_dungeon_loot')//幽冥地牢（terramity）
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([2, 4], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('terramity:chests/chthonic_dungeon_loot')///幽冥地牢（terramity）
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('terramity:chests/chthonic_dungeon_loot')//幽冥地牢（terramity）
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})


//飞行末地船（不同寻常的末地）
LootJS.modifiers(event => {//飞行末地船（不同寻常的末地）
    //定义删除物品,[物品id]
    let removeLoot = [
       ['minecraft:oak_planks'],
       ['minecraft:torch'],
       ['minecraft:string'],
       ['minecraft:gunpowder'],
       ['minecraft:blackstone'],
       ['minecraft:basalt'],
       ['terramity:stygian_bud'],
       ['minecraft:iron_ingot'],
       ['unusualend:chorus_nest_planks'],
]

     //定义添加权重物品[物品id,概率]
    let weightLootItem = [
       ['legendary_monsters:infected_chorus_fruit',1],//侵染紫颂果
       ['lightmanscurrency:coin_gold',3],//硬币与物品 金币 
       ['unusualend:chorus_petal',2],//紫颂花瓣
       ['unusualend:chorus_cane_flower',1],//紫颂竹花
       ['unusualend:chorus_juice',2],//紫颂汽水
    ]
     let lootItem = [
        ['unusualend:ender_stew',0.2],//末影炖菜
        ['exquisito:starcloud_bulbs',0.1],//以太球果
    ]

    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('unusualend:chests/flying_ship')//飞行末地船（不同寻常的末地）
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([2, 4], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('unusualend:chests/flying_ship')//飞行末地船（不同寻常的末地）
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('unusualend:chests/flying_ship')///飞行末地船（不同寻常的末地）
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})


//流浪商人之岛（不同寻常的末地）
LootJS.modifiers(event => {//流浪商人之岛（不同寻常的末地）
    //定义删除物品,[物品id]
    let removeLoot = [
       ['minecraft:oak_planks'],
       ['minecraft:torch'],
       ['minecraft:string'],
       ['minecraft:gunpowder'],
       ['minecraft:blackstone'],
       ['minecraft:basalt'],
       ['terramity:stygian_bud'],
       ['minecraft:iron_ingot'],
       ['unusualend:chorus_nest_planks'],
]

     //定义添加权重物品[物品id,概率]
    let weightLootItem = [
       ['lightmanscurrency:coin_gold',3],//硬币与物品 金币 
       ['unusualend:chorus_juice',2],//紫颂汽水
       ['cosmopolitan:travelers_panini',1],//旅者帕尼尼
       ['cosmopolitan:wandering_gelat',1],//流浪吉拉朵
    ]
     let lootItem = [
        ['unusualend:ender_stew',0.2],//末影炖菜
    ]

    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('unusualend:chests/wandering_house')//流浪商人之岛（不同寻常的末地）
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([1, 3], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('unusualend:chests/wandering_house')//流浪商人之岛（不同寻常的末地）
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('unusualend:chests/wandering_house')//流浪商人之岛（不同寻常的末地）
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})


//远古末地塔（不同寻常的末地）
LootJS.modifiers(event => {//远古末地塔（不同寻常的末地）
    //定义删除物品,[物品id]
    let removeLoot = [
       ['minecraft:oak_planks'],
       ['minecraft:torch'],
       ['minecraft:string'],
       ['minecraft:gunpowder'],
       ['minecraft:blackstone'],
       ['minecraft:basalt'],
       ['terramity:stygian_bud'],
       ['minecraft:iron_ingot'],
       ['unusualend:chorus_nest_planks'],
]

     //定义添加权重物品[物品id,概率]
    let weightLootItem = [
       ['lightmanscurrency:coin_gold',3],//硬币与物品 金币 
       ['kitchenkarrot:dragon_breath_coke',2],//龙息可乐
       ['minecraft:dragon_breath',2],//龙息
       ['enigmaticlegacy:etherium_ore',1],//以太矿石
    ]
     let lootItem = [
        ['unusualend:ender_stew',0.2],//末影炖菜
        ['exquisito:starcloud_bulbs',0.3],//以太球果
    ]

    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('minecraft:chests/ancient_end_city')//远古末地塔（不同寻常的末地）
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([2, 3], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('minecraft:chests/ancient_end_city')//远古末地塔（不同寻常的末地）
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('minecraft:chests/ancient_end_city')//远古末地塔（不同寻常的末地）
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})


//末地小屋（不同寻常的末地）
LootJS.modifiers(event => {//末地小屋（不同寻常的末地）
    //定义删除物品,[物品id]
    let removeLoot = [
       ['minecraft:oak_planks'],
       ['minecraft:torch'],
       ['minecraft:string'],
       ['minecraft:gunpowder'],
       ['minecraft:blackstone'],
       ['minecraft:basalt'],
       ['terramity:stygian_bud'],
       ['minecraft:iron_ingot'],
       ['unusualend:chorus_nest_planks'],
]

     //定义添加权重物品[物品id,概率]
    let weightLootItem = [
       ['lightmanscurrency:coin_gold',3],//硬币与物品 金币 
       ['kitchenkarrot:dragon_breath_coke',2],//龙息可乐
       ['minecraft:dragon_breath',2],//龙息
       ['enigmaticlegacy:etherium_ore',1],//以太矿石
    ]
     let lootItem = [
        ['unusualend:ender_stew',0.2],//末影炖菜
        ['exquisito:starcloud_bulbs',0.3],//以太球果
    ]

    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('minecraft:end_house_loot')//末地小屋（不同寻常的末地）
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([1, 3], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('minecraft:end_house_loot')//末地小屋（不同寻常的末地）
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('minecraft:end_house_loot')//远古末地塔（不同寻常的末地）
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})


//沉船
LootJS.modifiers(event => {//沉船
//定义删除物品,[物品id]
    let removeLoot = [
        ['minecraft:iron_nugget'],//铁粒
        ['minecraft:gold_nugget'],//金粒
        ['minecraft:emerald'],//绿宝石
        ['minecraft:gold_ingot'],//金
        ['minecraft:iron_ingot'],//铁
        ['additionaladditions:rose_gold_upgrade'],//锻造模板
        [Item.of('beachparty:rubber_ring_pelican', '{Damage:0}')],//泳圈
        ['beachparty:overgrown_disc'],//唱片
        ['minecraft:coast_armor_trim_smithing_template'],//锻造模板
        ['minecraft:lapis_lazuli'],//青金石
        [Item.of('jellyfishing:jellyfish_net', '{Damage:0}')],//水母网
        ['supplementaries:globe'],//地球仪
        ['touhou_little_maid:power_point'],//p点
        ['supplementaries:globe'],//地球仪
    ]
//定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['alexsmobs:lobster_tail', 2],//龙虾尾
        ['crabbersdelight:clawster', 2],//龙虾
        ['crabbersdelight:crab', 2],//螃蟹
        ['minecraft:nautilus_shell',2],//鹦鹉螺壳
        ['bountifulfares:citrus_essence',2],//柑橘精华
        ['lightmanscurrency:coin_gold',1],//硬币与物品 金币
        ['minecraft:sea_pickle',2],//海泡菜
    ]
    let lootItem = [
        ['crabbersdelight:kelp_shake', 0.3],//蟹农乐事 海带奶昔
        ['collectorsreap:lunar_pearl',0.05],//collectors reap  月光珍珠
        ['crabbersdelight:sea_pickle_juice',0.3],//蟹农乐事 海泡菜汁
        ['vanillacookbook:stuffed_sea_pickle', 0.2],//原版烹饪书 填馅海泡菜
        

    ]
    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('minecraft:chests/shipwreck_supply')//沉船
            //随机抽取2-4次weightLootItem里面的参数
            .addWeightedLoot([2, 3], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('minecraft:chests/shipwreck_supply')
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('minecraft:chests/shipwreck_supply')//沉船
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})


//要塞图书馆
LootJS.modifiers(event => {//要塞图书馆
//定义删除物品,[物品id]
    let removeLoot = [
        ['minecraft:iron_ingot'],//铁
        ['additionaladditions:rose_gold_upgrade'],//锻造模板
        ['beachparty:overgrown_disc'],//唱片
        ['minecraft:coast_armor_trim_smithing_template'],//锻造模板
        ['touhou_little_maid:power_point'],//p点
        [Item.of('minecraft:potion', '{Potion:"ars_nouveau:mana_regen_potion_long"}')],
        [Item.of('minecraft:compass')],
        ['ars_nouveau:split_arrow'],
        ['minecraft:paper'],
    ]
//定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['composite_material:duplichanted_book',1],//复魔书
        ['lightmanscurrency:coin_gold',1],//硬币与物品 金币
    ]
    let lootItem = [
        ['enigmaticaddons:antique_bag',0.2],//古旧书袋
        ['vanillacookbook:book_cake',0.2],//书蛋糕
        ['composite_material:reinforced_book',0.1],//强化书


    ]
    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('minecraft:chests/stronghold_library')//要塞图书馆
            //随机抽取2-4次weightLootItem里面的参数
            .addWeightedLoot([1, 3], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('minecraft:chests/stronghold_library')//要塞图书馆
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('minecraft:chests/stronghold_library')//要塞图书馆
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})
//要塞十字路口
LootJS.modifiers(event => {//要塞十字路口
//定义删除物品,[物品id]
    let removeLoot = [
        ['minecraft:iron_ingot'],//铁
        ['enigmaticlegacy:eye_of_nebula'],
    ]
//定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['minecraft:diamond',1],
        ['lightmanscurrency:coin_gold',1],//硬币与物品 金币
    ]
    let lootItem = [
        ['vanillacookbook:book_cake',0.2],//书蛋糕
        ['composite_material:reinforced_book',0.1],//强化书


    ]
    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('minecraft:chests/stronghold_crossing')//要塞十字路口
            //随机抽取2-4次weightLootItem里面的参数
            .addWeightedLoot([1, 3], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('minecraft:chests/stronghold_crossing')//要塞十字路口
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('minecraft:chests/stronghold_crossing')//要塞十字路口
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})
//沉船木桶
LootJS.modifiers(event => {//沉船木桶
//定义删除物品,[物品id]
    let removeLoot = [
        ['minecraft:iron_ingot'],//铁
        ['additionaladditions:rose_gold_upgrade'],//锻造模板
        ['beachparty:overgrown_disc'],//唱片
        ['minecraft:coast_armor_trim_smithing_template'],//锻造模板
        ['touhou_little_maid:power_point'],//p点
        [Item.of('minecraft:potion', '{Potion:"ars_nouveau:mana_regen_potion_long"}')],
        [Item.of('minecraft:compass')],
        ['ars_nouveau:split_arrow'],
        ['minecraft:paper'],
    ]
//定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['lightmanscurrency:coin_gold',1],//硬币与物品 金币
    ]
    let lootItem = [
        ['more_critters:captains_heart',0.15],//船长之心

    ]
    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('minecraft:chests/ship_barrel')//沉船木桶
            //随机抽取2-4次weightLootItem里面的参数
            .addWeightedLoot([1, 3], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('minecraft:chests/ship_barrel')//沉船木桶
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('minecraft:chests/ship_barrel')//沉船木桶
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})
//刻律涅牝鹿的尸骨
LootJS.modifiers(event => {//刻律涅牝鹿的尸骨
    //定义删除物品,[物品id]
    let removeLoot = [
        ['enigmaticlegacy:iron_ring'],//铁指环
        ['minecraft:bow'],//弓
        ['minecraft:golden_horse_armor'],//金马凯
        ['minecraft:iron_horse_armor'],//铁马凯
        ['minecraft:iron_helmet'],//铁头盔
        ['minecraft:iron_chestplate'],//铁胸甲
        ['minecraft:iron_leggings'],//铁护腿
        ['minecraft:iron_boots'],//铁靴子
        ['minecraft:iron_sword'],//铁剑
        ['minecraft:iron_axe'],//铁斧
        ['minecraft:saddle'],//马鞍
        ['minecraft:clock'],//钟
        ['minecraft:sand'],//沙子
    ]
    //定义添加权重物品[物品id,概率]
    let weightLootItem = [
       ['aquamirae:sea_stew',3],//海灵 海之炖菜
       ['aquamirae:sea_casserole',3],//海灵 海味砂锅
       ['aquaculture:neptunium_ingot',9],//水产 海王锭
       ['collectorsreap:sea_wrap',3],//海洋卷

    ]
 let lootItem = [
       ['aquamirae:poseidons_breakfast',0.2],//海灵 波塞冬早餐
       ['crockpot:moqueca',0.2],//烹饪锅 海鲜杂烩
       ['aquaculturedelight:turtle_meat_dish',0.2],//海味乐事 海龟肉料理
       ['aquaculture:neptunium_ingot',0.4]//水产 海王锭
]

    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('dungeons_arise:chests/ceryneian_hind/ceryneian_hind_treasure')//刻律涅牝鹿的尸骨
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([1, 2], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('dungeons_arise:chests/ceryneian_hind/ceryneian_hind_treasure')
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('dungeons_arise:chests/ceryneian_hind/ceryneian_hind_treasure')//刻律涅牝鹿的尸骨
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})

//创世神殿1
LootJS.modifiers(event => {//创世神殿1
    //定义删除物品,[物品id]
    let removeLoot = [
        ['minecraft:blue_orchid'],//兰花
        ['minecraft:azalea_leaves'],//杜鹃树叶
        ['minecraft:iron_ingot'],//铁
        ['minecraft:slime_ball'],//粘液球
        ['minecraft:gold_ingot'],//金锭
    ]
    //定义添加权重物品[物品id,概率]
    let weightLootItem = [
      ['minecraft:netherite_scrap',1],//下界合金碎片
      ['lightmanscurrency:coin_gold',3],//金币
      ['cosmopolitan:toffee_golden_apple',1],//糖浆金苹果
      ['minecraft:golden_apple',1],//金苹果
      ['terramity:gaianite_cluster',1],//盖亚矿簇
    ]

    let lootItem = [
        ['enigmaticlegacy:golem_heart', 0.03],//魔像之心
        ['enigmaticaddons:lost_engine', 0.03],//失落引擎
        ['enigmaticaddons:forgotten_ice', 0.03],//忘却冰晶
        ['enigmaticlegacy:angel_blessing', 0.03],//天使之祝
        ['enigmaticlegacy:blazing_core', 0.03],//烈焰之核
        ['enigmaticlegacy:ocean_stone', 0.03],//海洋意志
        [Item.of('legendary_monsters:golden_halbert', '{Damage:0}'),0.05],//金戟
        [Item.of('legendary_monsters:soul_great_sword', '{Damage:0}'),0.05],//灵魂巨剑
        [Item.of('meetyourfight:twilights_thorn', '{Damage:0}'),0.05],//胧暮荆棘
        [Item.of('meetyourfight:depth_star', '{Damage:0}'),0.05],//深度之星
        [Item.of('terramity:simmeredge', '{Damage:0}'),0.05],//预燃利刃
        [Item.of('terramity:hellspec_sword', '{Damage:0}'),0.05],//地狱合金剑
        [Item.of('composite_material:echoium_sword', '{Damage:0}'),0.05],//回响之剑
        [Item.of('terramity:stratus_storm_ruler', '{Damage:0}'),0.05],//天空与风暴统领
        [Item.of('terramity:conductite_sword', '{Damage:0}'),0.05],//聚电剑
        [Item.of('farmersdelight:toast_baguette', '{Damage:0}'),0.05],//烤长棍面包
        [Item.of('alexscaves:desolate_dagger', '{Damage:0}'),0.05],//荒芜匕首
        [Item.of('cataclysm:athame', '{Damage:0}'),0.05],//仪式匕首
        [Item.of('terramity:hellspec_axe', '{Damage:0}'),0.05],//地狱合金斧
        [Item.of('terramity:icebrand', '{Damage:0}'),0.05],//冻结烙印
        [Item.of('terramity:conductite_axe', '{Damage:0}'),0.05],//聚电斧
    ]

    

    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('dungeons_arise:chests/keep_kayra/keep_kayra_normal')//创世神殿1
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([1, 3], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('dungeons_arise:chests/keep_kayra/keep_kayra_normal')
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('dungeons_arise:chests/keep_kayra/keep_kayra_normal')//创世神殿1
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})

//创世神殿2
LootJS.modifiers(event => {//创世神殿2
    //定义删除物品,[物品id]
    let removeLoot = [
        ['minecraft:blue_orchid'],//兰花
        ['minecraft:azalea_leaves'],//杜鹃树叶
        ['minecraft:glow_lichen'],//发光地衣
        ['minecraft:soul_lantern'],//灵魂灯笼
        ['minecraft:glass_bottle'],//空瓶
        ['minecraft:iron_ingot'],//铁
        ['minecraft:slime_ball'],//粘液球
        ['minecraft:gold_ingot'],//金锭
    ]
    //定义添加权重物品[物品id,概率]
    let weightLootItem = [
         ['minecraft:netherite_scrap',1],//下界合金碎片
         ['lightmanscurrency:coin_gold',3],//金币
         ['crockpot:potato_tornado',1],//花式回旋块茎
         ['netherdepthsupgrade:baked_soulsucker_stew',1],//烘培魂吸炖
         ['terramity:gaianite_cluster',1],//盖亚矿簇

    ]

    let lootItem = [
        ['enigmaticlegacy:golem_heart', 0.03],//魔像之心
        ['enigmaticaddons:lost_engine', 0.03],//失落引擎
        ['enigmaticaddons:forgotten_ice', 0.03],//忘却冰晶
        ['enigmaticlegacy:angel_blessing', 0.03],//天使之祝
        ['enigmaticlegacy:blazing_core', 0.03],//烈焰之核
        ['enigmaticlegacy:ocean_stone', 0.03],//海洋意志
        [Item.of('legendary_monsters:golden_halbert', '{Damage:0}'),0.05],//金戟
        [Item.of('legendary_monsters:soul_great_sword', '{Damage:0}'),0.05],//灵魂巨剑
        [Item.of('meetyourfight:twilights_thorn', '{Damage:0}'),0.05],//胧暮荆棘
        [Item.of('meetyourfight:depth_star', '{Damage:0}'),0.05],//深度之星
        [Item.of('terramity:simmeredge', '{Damage:0}'),0.05],//预燃利刃
        [Item.of('terramity:hellspec_sword', '{Damage:0}'),0.05],//地狱合金剑
        [Item.of('composite_material:echoium_sword', '{Damage:0}'),0.05],//回响之剑
        [Item.of('terramity:stratus_storm_ruler', '{Damage:0}'),0.05],//天空与风暴统领
        [Item.of('terramity:conductite_sword', '{Damage:0}'),0.05],//聚电剑
        [Item.of('farmersdelight:toast_baguette', '{Damage:0}'),0.05],//烤长棍面包
        [Item.of('alexscaves:desolate_dagger', '{Damage:0}'),0.05],//荒芜匕首
        [Item.of('cataclysm:athame', '{Damage:0}'),0.05],//仪式匕首
        [Item.of('terramity:hellspec_axe', '{Damage:0}'),0.05],//地狱合金斧
        [Item.of('terramity:icebrand', '{Damage:0}'),0.05],//冻结烙印
        [Item.of('terramity:conductite_axe', '{Damage:0}'),0.05],//聚电斧
    ]

    

    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('dungeons_arise:chests/keep_kayra/keep_kayra_garden_normal')//创世神殿2
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([1, 3], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('dungeons_arise:chests/keep_kayra/keep_kayra_garden_normal')
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })
    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('dungeons_arise:chests/keep_kayra/keep_kayra_garden_normal')//创世神殿2
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})

//创世神殿3
LootJS.modifiers(event => {//创世神殿3
//定义删除物品,[物品id]
    let removeLoot = [
        ['minecraft:blue_orchid'],//兰花
        ['minecraft:azalea_leaves'],//杜鹃树叶
        ['minecraft:glow_lichen'],//发光地衣
        ['minecraft:soul_lantern'],//灵魂灯笼
        ['minecraft:glass_bottle'],//空瓶
        ['minecraft:iron_ingot'],//铁
        ['minecraft:slime_ball'],//粘液球
        ['minecraft:gold_ingot'],//金锭
    ]

    //定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['minecraft:netherite_scrap',1],//下界合金碎片
        ['lightmanscurrency:coin_gold',3],//金币
        ['bountifulfares:ancient_custard',1],//远古奶冻
        ['galospheric_delight:fruits_in_amethyst_dust',1],//紫金渍果
        ['terramity:gaianite_cluster',1],//盖亚矿簇
    ]

    let lootItem = [
        ['enigmaticlegacy:golem_heart', 0.03],//魔像之心
        ['enigmaticaddons:lost_engine', 0.03],//失落引擎
        ['enigmaticaddons:forgotten_ice', 0.03],//忘却冰晶
        ['enigmaticlegacy:angel_blessing', 0.03],//天使之祝
        ['enigmaticlegacy:blazing_core', 0.03],//烈焰之核
        ['enigmaticlegacy:ocean_stone', 0.03],//海洋意志
        [Item.of('legendary_monsters:golden_halbert', '{Damage:0}'),0.05],//金戟
        [Item.of('legendary_monsters:soul_great_sword', '{Damage:0}'),0.05],//灵魂巨剑
        [Item.of('meetyourfight:twilights_thorn', '{Damage:0}'),0.05],//胧暮荆棘
        [Item.of('meetyourfight:depth_star', '{Damage:0}'),0.05],//深度之星
        [Item.of('terramity:simmeredge', '{Damage:0}'),0.05],//预燃利刃
        [Item.of('terramity:hellspec_sword', '{Damage:0}'),0.05],//地狱合金剑
        [Item.of('composite_material:echoium_sword', '{Damage:0}'),0.05],//回响之剑
        [Item.of('terramity:stratus_storm_ruler', '{Damage:0}'),0.05],//天空与风暴统领
        [Item.of('terramity:conductite_sword', '{Damage:0}'),0.05],//聚电剑
        [Item.of('farmersdelight:toast_baguette', '{Damage:0}'),0.05],//烤长棍面包
        [Item.of('alexscaves:desolate_dagger', '{Damage:0}'),0.05],//荒芜匕首
        [Item.of('cataclysm:athame', '{Damage:0}'),0.05],//仪式匕首
        [Item.of('terramity:hellspec_axe', '{Damage:0}'),0.05],//地狱合金斧
        [Item.of('terramity:icebrand', '{Damage:0}'),0.05],//冻结烙印
        [Item.of('terramity:conductite_axe', '{Damage:0}'),0.05],//聚电斧
    ]

    

    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('dungeons_arise:chests/keep_kayra/keep_kayra_garden_treasure')//创世神殿3
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([1, 3], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('dungeons_arise:chests/keep_kayra/keep_kayra_garden_treasure')
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('dungeons_arise:chests/keep_kayra/keep_kayra_garden_treasure')//创世神殿3
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})

//创世神殿4
LootJS.modifiers(event => {//创世神殿4
//定义删除物品,[物品id]
    let removeLoot = [
        ['minecraft:blue_orchid'],//兰花
        ['minecraft:azalea_leaves'],//杜鹃树叶
        ['minecraft:glow_lichen'],//发光地衣
        ['minecraft:soul_lantern'],//灵魂灯笼
        ['minecraft:glass_bottle'],//空瓶
        ['minecraft:feather'],//羽毛
        ['minecraft:paper'],//纸
        ['minecraft:iron_ingot'],//铁
        ['minecraft:slime_ball'],//粘液球
        ['minecraft:gold_ingot'],//金锭
    ]

    //定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['minecraft:netherite_scrap',1],//下界合金碎片
        ['lightmanscurrency:coin_gold',3],//金币
        ['cosmopolitan:wild_risotto',1],//野味意式烩饭
        ['galospheric_delight:allurite_pie_slice',1],//幽蓝晶派切片
        ['terramity:gaianite_cluster',1],//盖亚矿簇
    ]

    let lootItem = [
         ['enigmaticlegacy:golem_heart', 0.03],//魔像之心
        ['enigmaticaddons:lost_engine', 0.03],//失落引擎
        ['enigmaticaddons:forgotten_ice', 0.03],//忘却冰晶
        ['enigmaticlegacy:angel_blessing', 0.03],//天使之祝
        ['enigmaticlegacy:blazing_core', 0.03],//烈焰之核
        ['enigmaticlegacy:ocean_stone', 0.03],//海洋意志
        [Item.of('legendary_monsters:golden_halbert', '{Damage:0}'),0.05],//金戟
        [Item.of('legendary_monsters:soul_great_sword', '{Damage:0}'),0.05],//灵魂巨剑
        [Item.of('meetyourfight:twilights_thorn', '{Damage:0}'),0.05],//胧暮荆棘
        [Item.of('meetyourfight:depth_star', '{Damage:0}'),0.05],//深度之星
        [Item.of('terramity:simmeredge', '{Damage:0}'),0.05],//预燃利刃
        [Item.of('terramity:hellspec_sword', '{Damage:0}'),0.05],//地狱合金剑
        [Item.of('composite_material:echoium_sword', '{Damage:0}'),0.05],//回响之剑
        [Item.of('terramity:stratus_storm_ruler', '{Damage:0}'),0.05],//天空与风暴统领
        [Item.of('terramity:conductite_sword', '{Damage:0}'),0.05],//聚电剑
        [Item.of('farmersdelight:toast_baguette', '{Damage:0}'),0.05],//烤长棍面包
        [Item.of('alexscaves:desolate_dagger', '{Damage:0}'),0.05],//荒芜匕首
        [Item.of('cataclysm:athame', '{Damage:0}'),0.05],//仪式匕首
        [Item.of('terramity:hellspec_axe', '{Damage:0}'),0.05],//地狱合金斧
        [Item.of('terramity:icebrand', '{Damage:0}'),0.05],//冻结烙印
        [Item.of('terramity:conductite_axe', '{Damage:0}'),0.05],//聚电斧
    ]

    

    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('dungeons_arise:chests/keep_kayra/keep_kayra_library_normal')//创世神殿4
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([1, 3], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('dungeons_arise:chests/keep_kayra/keep_kayra_library_normal')
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('dungeons_arise:chests/keep_kayra/keep_kayra_library_normal')//创世神殿4
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})

//创世神殿5
LootJS.modifiers(event => {//创世神殿5
    //定义删除物品,[物品id]
    let removeLoot = [
        ['minecraft:blue_orchid'],//兰花
        ['minecraft:azalea_leaves'],//杜鹃树叶
        ['minecraft:glow_lichen'],//发光地衣
        ['minecraft:soul_lantern'],//灵魂灯笼
        ['minecraft:glass_bottle'],//空瓶
        ['minecraft:feather'],//羽毛
        ['minecraft:paper'],//纸
        ['minecraft:iron_ingot'],//铁
        ['minecraft:slime_ball'],//粘液球
        ['minecraft:gold_ingot'],//金锭
    ]
    //定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['minecraft:netherite_scrap',1],//下界合金碎片
        ['lightmanscurrency:coin_gold',3],//金币
        ['fruitsdelight:mangosteen_cake',1],//山竹糕
        ['extrameat:buzzy_muffin',1],//嗡嗡纸杯蛋糕
        ['terramity:gaianite_cluster',1],//盖亚矿簇
    ]

    let lootItem = [
        ['enigmaticlegacy:golem_heart', 0.03],//魔像之心
        ['enigmaticaddons:lost_engine', 0.03],//失落引擎
        ['enigmaticaddons:forgotten_ice', 0.03],//忘却冰晶
        ['enigmaticlegacy:angel_blessing', 0.03],//天使之祝
        ['enigmaticlegacy:blazing_core', 0.03],//烈焰之核
        ['enigmaticlegacy:ocean_stone', 0.03],//海洋意志
        [Item.of('legendary_monsters:golden_halbert', '{Damage:0}'),0.05],//金戟
        [Item.of('legendary_monsters:soul_great_sword', '{Damage:0}'),0.05],//灵魂巨剑
        [Item.of('meetyourfight:twilights_thorn', '{Damage:0}'),0.05],//胧暮荆棘
        [Item.of('meetyourfight:depth_star', '{Damage:0}'),0.05],//深度之星
        [Item.of('terramity:simmeredge', '{Damage:0}'),0.05],//预燃利刃
        [Item.of('terramity:hellspec_sword', '{Damage:0}'),0.05],//地狱合金剑
        [Item.of('composite_material:echoium_sword', '{Damage:0}'),0.05],//回响之剑
        [Item.of('terramity:stratus_storm_ruler', '{Damage:0}'),0.05],//天空与风暴统领
        [Item.of('terramity:conductite_sword', '{Damage:0}'),0.05],//聚电剑
        [Item.of('farmersdelight:toast_baguette', '{Damage:0}'),0.05],//烤长棍面包
        [Item.of('alexscaves:desolate_dagger', '{Damage:0}'),0.05],//荒芜匕首
        [Item.of('cataclysm:athame', '{Damage:0}'),0.05],//仪式匕首
        [Item.of('terramity:hellspec_axe', '{Damage:0}'),0.05],//地狱合金斧
        [Item.of('terramity:icebrand', '{Damage:0}'),0.05],//冻结烙印
        [Item.of('terramity:conductite_axe', '{Damage:0}'),0.05],//聚电斧
    ]

    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('dungeons_arise:chests/keep_kayra/keep_kayra_library_treasure')//创世神殿5
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([1, 3], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('dungeons_arise:chests/keep_kayra/keep_kayra_library_treasure')
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('dungeons_arise:chests/keep_kayra/keep_kayra_library_treasure')//创世神殿5
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})

//创世神殿6
LootJS.modifiers(event => {//创世神殿6
    //定义删除物品,[物品id]
    let removeLoot = [
        ['minecraft:blue_orchid'],//兰花
        ['minecraft:azalea_leaves'],//杜鹃树叶
        ['minecraft:glow_lichen'],//发光地衣
        ['minecraft:soul_lantern'],//灵魂灯笼
        ['minecraft:glass_bottle'],//空瓶
        ['minecraft:feather'],//羽毛
        ['minecraft:paper'],//纸
        ['minecraft:iron_ingot'],//铁
        ['minecraft:slime_ball'],//粘液球
        ['minecraft:gold_ingot'],//金锭
    ]
    //定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['minecraft:netherite_scrap',1],//下界合金碎片
        ['lightmanscurrency:coin_gold',3],//金币
        ['crabbersdelight:surf_and_turf',1],//海陆大餐
        ['collectorsreap:land_and_sea_burger',1],//海陆堡
        ['terramity:gaianite_cluster',1],//盖亚矿簇
    ]

    let lootItem = [
         ['enigmaticlegacy:golem_heart', 0.03],//魔像之心
        ['enigmaticaddons:lost_engine', 0.03],//失落引擎
        ['enigmaticaddons:forgotten_ice', 0.03],//忘却冰晶
        ['enigmaticlegacy:angel_blessing', 0.03],//天使之祝
        ['enigmaticlegacy:blazing_core', 0.03],//烈焰之核
        ['enigmaticlegacy:ocean_stone', 0.03],//海洋意志
        [Item.of('legendary_monsters:golden_halbert', '{Damage:0}'),0.05],//金戟
        [Item.of('legendary_monsters:soul_great_sword', '{Damage:0}'),0.05],//灵魂巨剑
        [Item.of('meetyourfight:twilights_thorn', '{Damage:0}'),0.05],//胧暮荆棘
        [Item.of('meetyourfight:depth_star', '{Damage:0}'),0.05],//深度之星
        [Item.of('terramity:simmeredge', '{Damage:0}'),0.05],//预燃利刃
        [Item.of('terramity:hellspec_sword', '{Damage:0}'),0.05],//地狱合金剑
        [Item.of('composite_material:echoium_sword', '{Damage:0}'),0.05],//回响之剑
        [Item.of('terramity:stratus_storm_ruler', '{Damage:0}'),0.05],//天空与风暴统领
        [Item.of('terramity:conductite_sword', '{Damage:0}'),0.05],//聚电剑
        [Item.of('farmersdelight:toast_baguette', '{Damage:0}'),0.05],//烤长棍面包
        [Item.of('alexscaves:desolate_dagger', '{Damage:0}'),0.05],//荒芜匕首
        [Item.of('cataclysm:athame', '{Damage:0}'),0.05],//仪式匕首
        [Item.of('terramity:hellspec_axe', '{Damage:0}'),0.05],//地狱合金斧
        [Item.of('terramity:icebrand', '{Damage:0}'),0.05],//冻结烙印
        [Item.of('terramity:conductite_axe', '{Damage:0}'),0.05],//聚电
    ]

    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('dungeons_arise:chests/keep_kayra/keep_kayra_treasure')//创世神殿6
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([1, 3], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('dungeons_arise:chests/keep_kayra/keep_kayra_treasure')
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('dungeons_arise:chests/keep_kayra/keep_kayra_treasure')//创世神殿6
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})
//小型游艇宝藏
LootJS.modifiers(event => {//小型游艇宝藏
    //定义删除物品,[物品id]
    let removeLoot = [
        ['minecraft:feather'],//羽毛
        ['minecraft:paper'],//纸
        ['minecraft:iron_ingot'],//铁
        ['minecraft:slime_ball'],//粘液球
        ['minecraft:gunpowder'],//火药
        ['minecraft:gold_nugget'],//金粒

    ]
   //定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['oceanic_delight:sea_grape',4],//海葡萄
        ['jellyfishing:seanut',4],//海花生
        ['oceanic_delight:sea_salad',1],//海沙拉
        ['lightmanscurrency:coin_gold',3],//硬币与物品 金币 
    ]
    let lootItem = [
        ['crockpot:surf_n_turf',0.2],//海鲜牛排
        ['oceanic_delight:sea_grape',0.5],//海葡萄
        ['jellyfishing:seanut',0.5],//海花生
]
    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('dungeons_arise_seven_seas:chests/small_yacht/small_yacht_treasure')//小型游艇宝藏
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([1, 3], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('dungeons_arise_seven_seas:chests/small_yacht/small_yacht_treasure')
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('dungeons_arise_seven_seas:chests/small_yacht/small_yacht_treasure')//小型游艇宝藏
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})
//小型游艇
LootJS.modifiers(event => {//小型游艇
    //定义删除物品,[物品id]
    let removeLoot = [
        ['minecraft:feather'],//羽毛
        ['minecraft:paper'],//纸
        ['minecraft:iron_ingot'],//铁
        ['minecraft:slime_ball'],//粘液球
        ['minecraft:gunpowder'],//火药
        ['minecraft:gold_nugget'],//金粒

    ]
   //定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['oceanic_delight:sea_grape',4],//海葡萄
        ['jellyfishing:seanut',4],//海花生
        ['oceanic_delight:sea_salad',1],//海沙拉
        ['lightmanscurrency:coin_gold',3],//硬币与物品 金币 
    ]
    let lootItem = [
        ['crockpot:surf_n_turf',0.2],//海鲜牛排
        ['oceanic_delight:sea_grape',0.5],//海葡萄
        ['jellyfishing:seanut',0.5],//海花生
]
    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('dungeons_arise_seven_seas:chests/small_yacht/small_yacht_normal')//小型游艇
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([1, 3], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('dungeons_arise_seven_seas:chests/small_yacht/small_yacht_normal')
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('dungeons_arise_seven_seas:chests/small_yacht/small_yacht_normal')//小型游艇
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})
//海盗帆船
LootJS.modifiers(event => {//海盗帆船
    //定义删除物品,[物品id]
    let removeLoot = [
        ['minecraft:hay_block'],
        ['minecraft:blue_ice'],
        ['touhou_little_maid:power_point'],
        ['minecraft:wheat'],
]
    //定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['aquaculturedelight:bass_stew',1],//鲈鱼炖菜
        ['crockpot:ceviche',1],//酸橘汁腌鱼
        ['crockpot:fish_sticks',1],//炸鱼
        ['minecraft:salmon',4],//生鲑鱼
        ['minecraft:cod',4],//生鳕鱼
        ['lightmanscurrency:coin_gold',3],//硬币与物品 金币 
    ]
    let lootItem = [
        ['kaleidoscope_cookery:stargazy_pie',0.2],//仰望星空派
        ['veggiesdelight:fish_and_chips',0.2],//炸鱼薯条
]
    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('dungeons_arise_seven_seas:chests/pirate_junk/pirate_junk_normal')//海盗帆船
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([1, 2], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })
    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('dungeons_arise_seven_seas:chests/pirate_junk/pirate_junk_normal')//海盗帆船
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('dungeons_arise_seven_seas:chests/pirate_junk/pirate_junk_normal')//海盗帆船
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})

//海盗帆船宝藏
LootJS.modifiers(event => {//海盗帆船宝藏
    //定义删除物品,[物品id]
    let removeLoot = [
        ['minecraft:hay_block'],
        ['minecraft:blue_ice'],
        ['touhou_little_maid:power_point'],
        ['minecraft:wheat'],
]
    //定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['aquaculturedelight:bass_stew',1],//鲈鱼炖菜
        ['crockpot:ceviche',1],//酸橘汁腌鱼
        ['crockpot:fish_sticks',1],//炸鱼
        ['minecraft:salmon',4],//生鲑鱼
        ['minecraft:cod',4],//生鳕鱼
        ['lightmanscurrency:coin_gold',3],//硬币与物品 金币 
    ]
    let lootItem = [
        ['kaleidoscope_cookery:stargazy_pie',0.2],//仰望星空派
        ['veggiesdelight:fish_and_chips',0.2],//炸鱼薯条
]
    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('dungeons_arise_seven_seas:chests/pirate_junk/pirate_junk_treasure')//海盗帆船宝藏
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([1, 2], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })
    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('dungeons_arise_seven_seas:chests/pirate_junk/pirate_junk_treasure')//海盗帆船宝藏
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('dungeons_arise_seven_seas:chests/pirate_junk/pirate_junk_treasure')//海盗帆船宝藏
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})
//海盗护卫舰宝藏
LootJS.modifiers(event => {////海盗护卫舰宝藏
    //定义删除物品,[物品id]
    let removeLoot = [
        ['minecraft:hay_block'],
        ['minecraft:blue_ice'],
        ['touhou_little_maid:power_point'],
        ['minecraft:wheat'],
]
    //定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['aquaculturedelight:bass_stew',1],//鲈鱼炖菜
        ['crockpot:ceviche',1],//酸橘汁腌鱼
        ['crockpot:fish_sticks',1],//炸鱼
        ['minecraft:salmon',4],//生鲑鱼
        ['minecraft:cod',4],//生鳕鱼
        ['lightmanscurrency:coin_gold',3],//硬币与物品 金币 
    ]
    let lootItem = [
        ['kaleidoscope_cookery:stargazy_pie',0.2],//仰望星空派
        ['veggiesdelight:fish_and_chips',0.2],//炸鱼薯条
        ['aquamirae:sea_stew',0.3],//海灵 海之炖菜
        ['aquamirae:sea_casserole',0.3],//海灵 海味砂锅
]
    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('dungeons_arise_seven_seas:chests/corsair_corvette/corsair_corvette_treasure')//海盗护卫舰宝藏
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([1, 2], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })
    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('dungeons_arise_seven_seas:chests/corsair_corvette/corsair_corvette_treasure')//海盗护卫舰宝藏
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('dungeons_arise_seven_seas:chests/corsair_corvette/corsair_corvette_treasure')//海盗帆船宝藏
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})

//海盗护卫舰
LootJS.modifiers(event => {////海盗护卫舰宝藏
    //定义删除物品,[物品id]
    let removeLoot = [
        ['minecraft:hay_block'],
        ['minecraft:blue_ice'],
        ['touhou_little_maid:power_point'],
        ['minecraft:wheat'],
]
    //定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['aquaculturedelight:bass_stew',1],//鲈鱼炖菜
        ['crockpot:ceviche',1],//酸橘汁腌鱼
        ['crockpot:fish_sticks',1],//炸鱼
        ['minecraft:salmon',4],//生鲑鱼
        ['minecraft:cod',4],//生鳕鱼
        ['lightmanscurrency:coin_gold',3],//硬币与物品 金币 
    ]
    let lootItem = [
        ['kaleidoscope_cookery:stargazy_pie',0.2],//仰望星空派
        ['veggiesdelight:fish_and_chips',0.2],//炸鱼薯条
        ['aquamirae:sea_stew',0.3],//海灵 海之炖菜
        ['aquamirae:sea_casserole',0.3],//海灵 海味砂锅
]
    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('dungeons_arise_seven_seas:chests/corsair_corvette/corsair_corvette_normal')//海盗护卫舰
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([1, 2], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })
    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('dungeons_arise_seven_seas:chests/corsair_corvette/corsair_corvette_normal')//海盗护卫舰
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('dungeons_arise_seven_seas:chests/corsair_corvette/corsair_corvette_normal')//海盗帆船宝藏
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})
//独角兽大帆船
LootJS.modifiers(event => {//独角兽大帆船
    //定义删除物品,[物品id]
    let removeLoot = [
        ['minecraft:hay_block'],
        ['minecraft:blue_ice'],
        ['touhou_little_maid:power_point'],
        ['minecraft:wheat'],
]
    //定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['aquaculturedelight:bass_stew',1],//鲈鱼炖菜
        ['crockpot:ceviche',1],//酸橘汁腌鱼
        ['crockpot:fish_sticks',1],//炸鱼
        ['minecraft:salmon',4],//生鲑鱼
        ['minecraft:cod',4],//生鳕鱼
        ['lightmanscurrency:coin_gold',3],//硬币与物品 金币 
    ]
    let lootItem = [
        ['aquamirae:sea_stew',0.3],//海灵 海之炖菜
        ['aquamirae:sea_casserole',0.3],//海灵 海味砂锅
        ['aquaculture:neptunium_ingot', 0.1],//水产 海王锭
        ['collectorsreap:lunar_pearl',0.1],//collectors reap  月光珍珠
]
    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('dungeons_arise_seven_seas:chests/unicorn_galleon/unicorn_galleon_normal')//独角兽大帆船
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([1, 2], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })
    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('dungeons_arise_seven_seas:chests/unicorn_galleon/unicorn_galleon_normal')///独角兽大帆船
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('dungeons_arise_seven_seas:chests/unicorn_galleon/unicorn_galleon_normal')//独角兽大帆船
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})
//独角兽大帆船宝藏
LootJS.modifiers(event => {//独角兽大帆船
    //定义删除物品,[物品id]
    let removeLoot = [
        ['minecraft:hay_block'],
        ['minecraft:blue_ice'],
        ['touhou_little_maid:power_point'],
        ['minecraft:wheat'],
]
    //定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['aquaculturedelight:bass_stew',1],//鲈鱼炖菜
        ['crockpot:ceviche',1],//酸橘汁腌鱼
        ['crockpot:fish_sticks',1],//炸鱼
        ['minecraft:salmon',4],//生鲑鱼
        ['minecraft:cod',4],//生鳕鱼
        ['lightmanscurrency:coin_gold',3],//硬币与物品 金币 
    ]
    let lootItem = [
        ['aquamirae:sea_stew',0.3],//海灵 海之炖菜
        ['aquamirae:sea_casserole',0.3],//海灵 海味砂锅
        ['aquaculture:neptunium_ingot', 0.2],//水产 海王锭
        ['collectorsreap:lunar_pearl',0.2],//collectors reap  月光珍珠
]
    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('dungeons_arise_seven_seas:chests/unicorn_galleon/unicorn_galleon_treasure')//独角兽大帆船宝藏
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([1, 2], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })
    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('dungeons_arise_seven_seas:chests/unicorn_galleon/unicorn_galleon_treasure')///独角兽大帆船宝藏
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('dungeons_arise_seven_seas:chests/unicorn_galleon/unicorn_galleon_treasure')//独角兽大帆船宝藏
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})
//胜利护卫舰1
LootJS.modifiers(event => {//胜利护卫舰1
    //定义删除物品,[物品id]
    let removeLoot = [
        ['minecraft:hay_block'],
        ['minecraft:blue_ice'],
        ['touhou_little_maid:power_point'],
        ['minecraft:wheat'],
]
    //定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['alexsmobs:lobster_tail', 2],//龙虾尾
        ['crabbersdelight:clawster', 2],//龙虾
        ['crabbersdelight:crab', 2],//螃蟹
        ['minecraft:nautilus_shell',2],//鹦鹉螺壳
        ['bountifulfares:citrus_essence',2],//柑橘精华
        ['lightmanscurrency:coin_gold',1],//硬币与物品 金币
    ]
    let lootItem = [
        ['aquaculture:neptunium_ingot', 0.2],//水产 海王锭
        ['collectorsreap:lunar_pearl',0.2],//collectors reap  月光珍珠
        ['aquamirae:poseidons_breakfast',0.2],//海灵 波塞冬早餐
        ['crockpot:moqueca',0.2],//烹饪锅 海鲜杂烩
]
    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('dungeons_arise_seven_seas:chests/victory_frigate/victory_frigate_normal_upper')//胜利护卫舰1
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([2, 3], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })
    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('dungeons_arise_seven_seas:chests/victory_frigate/victory_frigate_normal_upper')//胜利护卫舰1
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('dungeons_arise_seven_seas:chests/victory_frigate/victory_frigate_normal_upper')////胜利护卫舰1
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})
//胜利护卫舰2
LootJS.modifiers(event => {//胜利护卫舰1
    //定义删除物品,[物品id]
    let removeLoot = [
        ['minecraft:hay_block'],
        ['minecraft:blue_ice'],
        ['touhou_little_maid:power_point'],
        ['minecraft:wheat'],
]
    //定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['aquaculturedelight:bass_stew',1],//鲈鱼炖菜
        ['crockpot:ceviche',1],//酸橘汁腌鱼
        ['crockpot:fish_sticks',1],//炸鱼
        ['minecraft:salmon',4],//生鲑鱼
        ['minecraft:cod',4],//生鳕鱼
        ['lightmanscurrency:coin_gold',1],//硬币与物品 金币
    ]
    let lootItem = [
        ['aquamirae:sea_stew',0.3],//海灵 海之炖菜
        ['aquamirae:sea_casserole',0.3],//海灵 海味砂锅
        ['aquaculture:neptunium_ingot', 0.2],//水产 海王锭
        ['collectorsreap:lunar_pearl',0.2],//collectors reap  月光珍珠
        ['aquamirae:poseidons_breakfast',0.2],//海灵 波塞冬早餐
        ['crockpot:moqueca',0.2],//烹饪锅 海鲜杂烩
]
    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('dungeons_arise_seven_seas:chests/victory_frigate/victory_frigate_normal_lower')//胜利护卫舰2
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([2, 3], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })
    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('dungeons_arise_seven_seas:chests/victory_frigate/victory_frigate_normal_lower')//胜利护卫舰2
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('dungeons_arise_seven_seas:chests/victory_frigate/victory_frigate_normal_lower')////胜利护卫舰2
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})
//胜利护卫舰3
LootJS.modifiers(event => {//胜利护卫舰3
//定义删除物品,[物品id]
    let removeLoot = [
        ['minecraft:iron_nugget'],//铁粒
        ['minecraft:gold_nugget'],//金粒
        ['minecraft:emerald'],//绿宝石
        ['minecraft:gold_ingot'],//金
        ['minecraft:iron_ingot'],//铁
        ['additionaladditions:rose_gold_upgrade'],//锻造模板
        [Item.of('beachparty:rubber_ring_pelican', '{Damage:0}')],//泳圈
        ['beachparty:overgrown_disc'],//唱片
        ['minecraft:coast_armor_trim_smithing_template'],//锻造模板
        ['minecraft:lapis_lazuli'],//青金石
        [Item.of('jellyfishing:jellyfish_net', '{Damage:0}')],//水母网
        ['supplementaries:globe'],//地球仪
        ['touhou_little_maid:power_point'],//p点
        ['supplementaries:globe'],//地球仪
    ]
//定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['alexsmobs:lobster_tail', 2],//龙虾尾
        ['crabbersdelight:clawster', 2],//龙虾
        ['crabbersdelight:crab', 2],//螃蟹
        ['minecraft:nautilus_shell',2],//鹦鹉螺壳
        ['bountifulfares:citrus_essence',2],//柑橘精华
        ['lightmanscurrency:coin_gold',1],//硬币与物品 金币
        ['minecraft:sea_pickle',2],//海泡菜
    ]
    let lootItem = [
        ['crabbersdelight:kelp_shake', 0.3],//蟹农乐事 海带奶昔
        ['collectorsreap:lunar_pearl',0.05],//collectors reap  月光珍珠
        ['crabbersdelight:sea_pickle_juice',0.3],//蟹农乐事 海泡菜汁
        ['vanillacookbook:stuffed_sea_pickle', 0.2],//原版烹饪书 填馅海泡菜
        

    ]
    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('dungeons_arise_seven_seas:chests/victory_frigate/victory_frigate_treasure')//胜利护卫舰3
            //随机抽取2-4次weightLootItem里面的参数
            .addWeightedLoot([2, 3], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('dungeons_arise_seven_seas:chests/victory_frigate/victory_frigate_treasure')
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('dungeons_arise_seven_seas:chests/victory_frigate/victory_frigate_treasure')//胜利护卫舰3
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})
//丛林树屋
LootJS.modifiers(event => {//丛林前哨站（trek）
    //定义删除物品,[物品id]
    let removeLoot = [
        ['minecraft:iron_nugget'],//铁粒
        ['minecraft:gold_nugget'],//金粒
        ['minecraft:emerald'],//绿宝石
        ['minecraft:gold_ingot'],//金
        ['minecraft:iron_ingot'],//铁
        ['additionaladditions:rose_gold_upgrade'],//锻造模板
        [Item.of('beachparty:rubber_ring_pelican', '{Damage:0}')],//泳圈
        ['beachparty:overgrown_disc'],//唱片
        ['minecraft:coast_armor_trim_smithing_template'],//锻造模板
        ['minecraft:lapis_lazuli'],//青金石
        ['minecraft:redstone'],//红石
        ['supplementaries:globe'],//地球仪
        ['touhou_little_maid:power_point'],//p点
        ['minecraft:oak_sapling'],//橡树树苗
        ['minecraft:iron_ore'],//铁矿石
    ]
//定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['farmersplus:pork_patty',2],//猪肉饼
        ['kitchenkarrot:beef_grains',2],//牛肉粒
        ['lightmanscurrency:coin_gold',3],//硬币与物品 金币 
    ]
    let lootItem = [
       ['youkaishomecoming:pork_rice_ball',0.2],//猪肉饭团
       ['barbequesdelight:grilled_pork_sausage_skewer',0.2],//烤猪肉香肠
    ]
    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('dungeons_arise:chests/jungle_tree_house/jungle_tree_house_normal')//丛林树屋
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([2, 3], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })
    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('dungeons_arise:chests/jungle_tree_house/jungle_tree_house_normal')//丛林树屋
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('dungeons_arise:chests/jungle_tree_house/jungle_tree_house_normal')//丛林树屋
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})
//丛林树屋2
LootJS.modifiers(event => {//丛林前哨站（trek）
    //定义删除物品,[物品id]
    let removeLoot = [
        ['minecraft:iron_nugget'],//铁粒
        ['minecraft:gold_nugget'],//金粒
        ['minecraft:emerald'],//绿宝石
        ['minecraft:gold_ingot'],//金
        ['minecraft:iron_ingot'],//铁
        ['additionaladditions:rose_gold_upgrade'],//锻造模板
        [Item.of('beachparty:rubber_ring_pelican', '{Damage:0}')],//泳圈
        ['beachparty:overgrown_disc'],//唱片
        ['minecraft:coast_armor_trim_smithing_template'],//锻造模板
        ['minecraft:lapis_lazuli'],//青金石
        ['minecraft:redstone'],//红石
        ['supplementaries:globe'],//地球仪
        ['touhou_little_maid:power_point'],//p点
        ['minecraft:oak_sapling'],//橡树树苗
        ['minecraft:iron_ore'],//铁矿石
        ['minecraft:jungle_leaves'],//丛林树叶
        ['supplementaries:bamboo_spikes'],//竹刺
    ]
//定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['farmersplus:pork_patty',2],//猪肉饼
        ['kitchenkarrot:beef_grains',2],//牛肉粒
        ['lightmanscurrency:coin_gold',3],//硬币与物品 金币 
    ]
    let lootItem = [
       ['youkaishomecoming:pork_rice_ball',0.2],//猪肉饭团
       ['barbequesdelight:grilled_pork_sausage_skewer',0.2],//烤猪肉香肠
    ]
    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('dungeons_arise:chests/jungle_tree_house/jungle_tree_house_treasure')//丛林树屋2
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([2, 3], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })
    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('dungeons_arise:chests/jungle_tree_house/jungle_tree_house_treasure')//丛林树屋2
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('dungeons_arise:chests/jungle_tree_house/jungle_tree_house_treasure')//丛林树屋2
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})
//修道院
LootJS.modifiers(event => {//修道院
    //定义删除物品,[物品id]
    let removeLoot = [
        ['minecraft:iron_nugget'],//铁粒
        ['minecraft:gold_nugget'],//金粒
        ['minecraft:emerald'],//绿宝石
        ['minecraft:gold_ingot'],//金
        ['minecraft:iron_ingot'],//铁
        ['additionaladditions:rose_gold_upgrade'],//锻造模板
        [Item.of('beachparty:rubber_ring_pelican', '{Damage:0}')],//泳圈
        ['beachparty:overgrown_disc'],//唱片
        ['minecraft:coast_armor_trim_smithing_template'],//锻造模板
        ['minecraft:lapis_lazuli'],//青金石
        ['minecraft:redstone'],//红石
        ['supplementaries:globe'],//地球仪
        ['touhou_little_maid:power_point'],//p点
        ['minecraft:oak_sapling'],//橡树树苗
        ['minecraft:iron_ore'],//铁矿石
        ['minecraft:jungle_leaves'],//丛林树叶
        ['supplementaries:bamboo_spikes'],//竹刺
    ]
//定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['farmersplus:pork_patty',2],//猪肉饼
        ['kitchenkarrot:beef_grains',2],//牛肉粒
        ['lightmanscurrency:coin_gold',3],//硬币与物品 金币 
    ]
    let lootItem = [
       ['youkaishomecoming:pork_rice_ball',0.2],//猪肉饭团
       ['lightmanscurrency:coin_emerald', 0.15],//硬币与物品 绿宝石币
    ]
    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('dungeons_arise:chests/monastery/monastery_map')///修道院
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([2, 3], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })
    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('dungeons_arise:chests/monastery/monastery_map')///修道院
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('dungeons_arise:chests/monastery/monastery_map')//修道院
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})
//商人营地
LootJS.modifiers(event => {//修道院
    //定义删除物品,[物品id]
    let removeLoot = [
        ['minecraft:iron_nugget'],//铁粒
        ['minecraft:gold_nugget'],//金粒
        ['minecraft:emerald'],//绿宝石
        ['minecraft:gold_ingot'],//金
        ['minecraft:iron_ingot'],//铁
        ['additionaladditions:rose_gold_upgrade'],//锻造模板
        [Item.of('beachparty:rubber_ring_pelican', '{Damage:0}')],//泳圈
        ['beachparty:overgrown_disc'],//唱片
        ['minecraft:coast_armor_trim_smithing_template'],//锻造模板
        ['minecraft:lapis_lazuli'],//青金石
        ['minecraft:redstone'],//红石
        ['supplementaries:globe'],//地球仪
        ['touhou_little_maid:power_point'],//p点
        ['minecraft:oak_sapling'],//橡树树苗
        ['minecraft:iron_ore'],//铁矿石
        ['minecraft:jungle_leaves'],//丛林树叶
        ['supplementaries:bamboo_spikes'],//竹刺
    ]
//定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['kitchenkarrot:canned_beef_potato',1],//土豆牛肉罐头
        ['kitchenkarrot:canned_mutton_pumpkin',1],//羊肉南瓜罐头
        ['kitchenkarrot:canned_candied_apple',1],//蜜蜂苹果罐头
        ['lightmanscurrency:coin_gold',3],//硬币与物品 金币 
    ]
    let lootItem = [
       
       ['lightmanscurrency:coin_emerald', 0.15],//硬币与物品 绿宝石币
    ]
    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('dungeons_arise:chests/merchant_campsite/merchant_campsite_tent')//商人营地
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([2, 3], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })
    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('dungeons_arise:chests/merchant_campsite/merchant_campsite_tent')//商人营地
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('dungeons_arise:chests/merchant_campsite/merchant_campsite_tent')//
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})
//大蘑菇屋
LootJS.modifiers(event => {//大蘑菇屋
    //定义删除物品,[物品id]
    let removeLoot = [
        ['minecraft:iron_nugget'],//铁粒
        ['minecraft:gold_nugget'],//金粒
        ['minecraft:emerald'],//绿宝石
        ['minecraft:gold_ingot'],//金
        ['minecraft:iron_ingot'],//铁
        ['additionaladditions:rose_gold_upgrade'],//锻造模板
        [Item.of('beachparty:rubber_ring_pelican', '{Damage:0}')],//泳圈
        ['beachparty:overgrown_disc'],//唱片
        ['minecraft:coast_armor_trim_smithing_template'],//锻造模板
        ['minecraft:lapis_lazuli'],//青金石
        ['minecraft:redstone'],//红石
        ['supplementaries:globe'],//地球仪
        ['touhou_little_maid:power_point'],//p点
        ['minecraft:oak_sapling'],//橡树树苗
        ['minecraft:iron_ore'],//铁矿石
        ['minecraft:jungle_leaves'],//丛林树叶
        ['supplementaries:bamboo_spikes'],//竹刺
    ]
//定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['kitchenkarrot:flower_cake',1],//鲜花饼
        ['lightmanscurrency:coin_gold',3],//硬币与物品 金币 
        ['minecraft:brown_mushroom',2],//棕蘑菇
        ['minecraft:red_mushroom',2],//红蘑菇
        
    ]
    let lootItem = [    
        ['farmersdelight:mushroom_rice',0.2],//蘑菇饭

    ]
    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('dungeons_arise:chests/mushroom_house/mushroom_house_treasure')//大蘑菇屋
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([2, 3], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })
    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('dungeons_arise:chests/mushroom_house/mushroom_house_treasure')//大蘑菇屋
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('dungeons_arise:chests/mushroom_house/mushroom_house_treasure')//大蘑菇屋
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})

//天际征服者战舰1
LootJS.modifiers(event => {///天际征服者战舰1
     //定义删除物品,[物品id]
    let removeLoot = [
        ['minecraft:golden_horse_armor'],//金马铠
        ['minecraft:iron_horse_armor'],//铁马铠
        ['minecraft:iron_nugget'],//铁粒
        ['minecraft:gold_nugget'],//金粒
        ['minecraft:emerald'],//绿宝石
        ['minecraft:gold_ingot'],//金
        ['minecraft:iron_ingot'],//铁
        ['additionaladditions:rose_gold_upgrade'],//锻造模板
        [Item.of('beachparty:rubber_ring_pelican', '{Damage:0}')],//泳圈
        ['beachparty:overgrown_disc'],//唱片
        ['minecraft:coast_armor_trim_smithing_template'],//锻造模板
        ['minecraft:lapis_lazuli'],//青金石
        ['minecraft:redstone'],//红石
        ['supplementaries:globe'],//地球仪
        ['touhou_little_maid:power_point'],//p点
        ['minecraft:oak_sapling'],//橡树树苗
        ['minecraft:iron_ore'],//铁矿石
        ['minecraft:jungle_leaves'],//丛林树叶
        ['supplementaries:bamboo_spikes'],//竹刺
    ]
    //定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['lightmanscurrency:coin_gold',3],//硬币与物品 金币 
    ]

    let lootItem = [
        ['immersive_aircraft:biplane', 0.2],//双翼机
        ['immersive_aircraft:nether_engine', 0.2],//下界发动机
        ['confluence:obsidian_horseshoe', 0.1],//黑曜石马掌
        ['minecraft:netherite_scrap', 0.1],//下界合金碎片
        ['mynethersdelight:hotdog_with_mixed_salad', 0.1],//下界乐事 混合沙拉热狗
        ['mynethersdelight:hotdog', 0.2],//下界乐事 热狗
        ['enigmaticlegacy:darkest_scroll', 0.1],//神秘遗物 至暗卷轴

    ]

   

    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('dungeons_arise:chests/heavenly_conqueror/heavenly_conqueror_normal')///天际征服者战舰1
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([1, 2], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('dungeons_arise:chests/heavenly_conqueror/heavenly_conqueror_normal')
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('dungeons_arise:chests/heavenly_conqueror/heavenly_conqueror_normal')//天际征服者战舰1
            .removeLoot(item)//删除遍历removeLoot的物品 

     })
})

//天际征服者战舰2
LootJS.modifiers(event => {///天际征服者战舰2
    //定义删除物品,[物品id]
    let removeLoot = [
        ['minecraft:golden_horse_armor'],//金马铠
        ['minecraft:iron_horse_armor'],//铁马铠
        ['minecraft:golden_helmet'],//金头盔
        ['minecraft:golden_chestplate'],//金胸甲
        ['minecraft:golden_leggings'],//金护腿
        ['minecraft:golden_boots'],//金靴子
        ['minecraft:saddle'],//鞍
    ]
    //定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['lightmanscurrency:coin_gold',3],//硬币与物品 金币 
    ]

    let lootItem = [
        ['confluence:obsidian_horseshoe', 0.2],//黑曜石马掌
        ['minecraft:netherite_scrap', 0.2],//下界合金碎片
        ['enigmaticlegacy:darkest_scroll', 0.1],//神秘遗物 至暗卷轴
        ['mynethersdelight:enchanted_golden_egg', 0.2],//下界乐事 附魔金蛋
        ['mynethersdelight:nether_burger', 0.2],//下界乐事 下界汉堡
    ]

    

    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('dungeons_arise:chests/heavenly_conqueror/heavenly_conqueror_treasure')///天际征服者战舰2
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([1, 1], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('dungeons_arise:chests/heavenly_conqueror/heavenly_conqueror_treasure')
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('dungeons_arise:chests/heavenly_conqueror/heavenly_conqueror_treasure')//天际征服者战舰2
            .removeLoot(item)//删除遍历removeLoot的物品 

     })
})
//天际骑士团战舰1
LootJS.modifiers(event => {///天际征服者战舰2
    //定义删除物品,[物品id]
    let removeLoot = [
        ['minecraft:golden_horse_armor'],//金马铠
        ['minecraft:iron_horse_armor'],//铁马铠
        ['minecraft:golden_helmet'],//金头盔
        ['minecraft:golden_chestplate'],//金胸甲
        ['minecraft:golden_leggings'],//金护腿
        ['minecraft:golden_boots'],//金靴子
        ['minecraft:saddle'],//鞍
    ]
    //定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['lightmanscurrency:coin_gold',3],//硬币与物品 金币 
    ]

    let lootItem = [
        ['immersive_aircraft:biplane', 0.2],//双翼机
        ['immersive_aircraft:nether_engine', 0.2],//下界发动机
        ['confluence:obsidian_horseshoe', 0.1],//黑曜石马掌
        ['minecraft:netherite_scrap', 0.1],//下界合金碎片
        ['mynethersdelight:hotdog_with_mixed_salad', 0.1],//下界乐事 混合沙拉热狗
        ['mynethersdelight:hotdog', 0.2],//下界乐事 热狗
        ['enigmaticlegacy:darkest_scroll', 0.1],//神秘遗物 至暗卷轴
    ]

    

    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('dungeons_arise:chests/heavenly_rider/heavenly_rider_normal')///天际骑士团战舰1
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([1, 1], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('dungeons_arise:chests/heavenly_rider/heavenly_rider_normal')
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('dungeons_arise:chests/heavenly_rider/heavenly_rider_normal')//天际骑士团战舰1
            .removeLoot(item)//删除遍历removeLoot的物品 

     })
})
//天际骑士团战舰2
LootJS.modifiers(event => {//天际骑士团战舰2
    //定义删除物品,[物品id]
    let removeLoot = [
        ['minecraft:golden_horse_armor'],//金马铠
        ['minecraft:iron_horse_armor'],//铁马铠
        ['minecraft:golden_helmet'],//金头盔
        ['minecraft:golden_chestplate'],//金胸甲
        ['minecraft:golden_leggings'],//金护腿
        ['minecraft:golden_boots'],//金靴子
        ['minecraft:saddle'],//鞍
    ]
    //定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['lightmanscurrency:coin_gold',3],//硬币与物品 金币 
    ]

    let lootItem = [
        ['confluence:obsidian_horseshoe', 0.2],//黑曜石马掌
        ['minecraft:netherite_scrap', 0.2],//下界合金碎片
        ['enigmaticlegacy:darkest_scroll', 0.1],//神秘遗物 至暗卷轴
        ['mynethersdelight:enchanted_golden_egg', 0.2],//下界乐事 附魔金蛋
        ['mynethersdelight:nether_burger', 0.2],//下界乐事 下界汉
        [Item.of('minecraft:netherite_pickaxe', "{Damage:0,RepairCost:0,display:{Name:'{\"text\":\"jqka的馈赠\"}'}}").enchant('minecraft:unbreaking', 3).enchant('minecraft:efficiency', 4).enchant('minecraft:fortune', 1),0.3],//下界合金稿
        ['minecraft:netherite_ingot', 0.1],//下界合金锭
        ['brewinandchewin:scarlet_cheese_wheel',0.2],//饮酒作乐 绯红奶酪轮
    ]

    

    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('dungeons_arise:chests/heavenly_rider/heavenly_rider_treasure')////天际骑士团战舰2
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([1, 2], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('dungeons_arise:chests/heavenly_rider/heavenly_rider_treasure')//天际骑士团战舰2
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('dungeons_arise:chests/heavenly_rider/heavenly_rider_treasure')//天际骑士团战舰2
            .removeLoot(item)//删除遍历removeLoot的物品 

     })
})
//天际挑战者1
LootJS.modifiers(event => {//天际挑战者
    //定义删除物品,[物品id]
    let removeLoot = [
        ['minecraft:golden_horse_armor'],//金马铠
        ['minecraft:iron_horse_armor'],//铁马铠
        ['minecraft:golden_helmet'],//金头盔
        ['minecraft:golden_chestplate'],//金胸甲
        ['minecraft:golden_leggings'],//金护腿
        ['minecraft:golden_boots'],//金靴子
        ['minecraft:saddle'],//鞍
    ]
    //定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['lightmanscurrency:coin_gold',3],//硬币与物品 金币 
    ]

    let lootItem = [
        ['immersive_aircraft:biplane', 0.2],//双翼机
        ['immersive_aircraft:nether_engine', 0.2],//下界发动机
        ['confluence:obsidian_horseshoe', 0.1],//黑曜石马掌
        ['minecraft:netherite_scrap', 0.1],//下界合金碎片
        ['mynethersdelight:hotdog_with_mixed_salad', 0.1],//下界乐事 混合沙拉热狗
        ['mynethersdelight:hotdog', 0.2],//下界乐事 热狗
        ['enigmaticlegacy:darkest_scroll', 0.1],//神秘遗物 至暗卷轴
    ]

    

    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('dungeons_arise:chests/heavenly_challenger/heavenly_challenger_normal')///天际挑战者1
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([1, 2], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('dungeons_arise:chests/heavenly_challenger/heavenly_challenger_normal')
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('dungeons_arise:chests/heavenly_challenger/heavenly_challenger_normal')//天际挑战者1
            .removeLoot(item)//删除遍历removeLoot的物品 

     })
})
//天际挑战者2
LootJS.modifiers(event => {//天际挑战者2
    //定义删除物品,[物品id]
    let removeLoot = [
        ['minecraft:golden_horse_armor'],//金马铠
        ['minecraft:iron_horse_armor'],//铁马铠
        ['minecraft:golden_helmet'],//金头盔
        ['minecraft:golden_chestplate'],//金胸甲
        ['minecraft:golden_leggings'],//金护腿
        ['minecraft:golden_boots'],//金靴子
        ['minecraft:saddle'],//鞍
    ]
    //定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['lightmanscurrency:coin_gold',3],//硬币与物品 金币 
    ]

    let lootItem = [
        ['immersive_aircraft:biplane', 0.2],//双翼机
        ['immersive_aircraft:nether_engine', 0.2],//下界发动机
        ['confluence:obsidian_horseshoe', 0.1],//黑曜石马掌
        ['minecraft:netherite_scrap', 0.1],//下界合金碎片
        ['mynethersdelight:hotdog_with_mixed_salad', 0.1],//下界乐事 混合沙拉热狗
        ['mynethersdelight:hotdog', 0.2],//下界乐事 热狗
        ['enigmaticlegacy:darkest_scroll', 0.1],//神秘遗物 至暗卷轴
    ]

    

    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('dungeons_arise:chests/heavenly_challenger/heavenly_challenger_theater')///天际挑战者2
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([1, 2], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('dungeons_arise:chests/heavenly_challenger/heavenly_challenger_theater')
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('dungeons_arise:chests/heavenly_challenger/heavenly_challenger_theater')//天际挑战者2
            .removeLoot(item)//删除遍历removeLoot的物品 

     })
})
//天际挑战者3
LootJS.modifiers(event => {//天际挑战者3
    //定义删除物品,[物品id]
    let removeLoot = [
        ['minecraft:quartz'],//下界石英
        ['minecraft:gold_nugget'],//金粒
        ['minecraft:spectral_arrow'],//光灵箭
        ['minecraft:crying_obsidian'],//哭泣黑曜石
        ['touhou_little_maid:power_point'],//p点
        ['minecraft:netherite_upgrade_smithing_template'],//锻造模板
        [Item.of('minecraft:diamond_sword', '{Damage:0}')],//钻石剑
        [Item.of('farmersdelight:diamond_knife', '{Damage:0}')],//钻石刀
        ['minecraft:iron_ingot'],//铁
        ['sophisticatedbackpacks:gold_backpack'],//金背包
        ['minecraft:iron_block'],//铁块
        ['touhou_little_maid:shrine',],//神龛
        [Item.of('minecraft:diamond_chestplate', '{Damage:91}')],//钻石甲
        ['ars_nouveau:wixie_shards'],//药水
        ['nethervinery:crimson_grape_seeds'],//种子
        ['sophisticatedbackpacks:feeding_upgrade'],//喂食升级
        [Item.of('minecraft:diamond_helmet', '{Damage:13}')],//钻石头盔
        ['minecraft:gold_block'],//金块
        ['minecraft:gold_ingot'],//金子
        [Item.of('minecraft:potion', '{Potion:"ars_nouveau:mana_regen_potion_long"}')],//药水
        ['ars_nouveau:amplify_arrow'],//箭
    ]
    //定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['lightmanscurrency:coin_emerald', 2],//硬币与物品 绿宝石币
        ['immortalers_delight:golden_kwat_toast_slice',3],//千古乐事 金瓦斯麦吐司碎片
    ]
    let lootItem = [
        ['minecraft:netherite_ingot', 0.1],//下界合金锭
        ['brewinandchewin:scarlet_cheese_wheel',0.2],//饮酒作乐 绯红奶酪轮]
        [Item.of('minecraft:netherite_pickaxe', "{Damage:0,RepairCost:0,display:{Name:'{\"text\":\"jqka的馈赠\"}'}}").enchant('minecraft:unbreaking', 3).enchant('minecraft:efficiency', 4).enchant('minecraft:fortune', 1),0.3],//下界合金稿
        ['confluence:obsidian_horseshoe', 0.1],//黑曜石马掌
        ['mynethersdelight:hotdog_with_mixed_salad', 0.1],//下界乐事 混合沙拉热狗
        ['mynethersdelight:hotdog', 0.2],//下界乐事 热狗
        ['enigmaticlegacy:darkest_scroll', 0.1],//神秘遗物 至暗卷轴
    ]
    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('dungeons_arise:chests/heavenly_challenger/heavenly_challenger_treasure')//天际挑战者3
            //随机抽取1-4次weightLootItem里面的参数
            .addWeightedLoot([2, 3], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('dungeons_arise:chests/heavenly_challenger/heavenly_challenger_treasure')//天际挑战者3
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('dungeons_arise:chests/heavenly_challenger/heavenly_challenger_treasure')//天际挑战者3
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})
//幽灵海盗船
LootJS.modifiers(event => {//幽灵海盗船
    //定义删除物品,[物品id]
    let removeLoot = [
        ['minecraft:golden_horse_armor'],//金马铠
        ['minecraft:iron_horse_armor'],//铁马铠
        ['minecraft:iron_nugget'],//铁粒
        ['minecraft:gold_nugget'],//金粒
        ['minecraft:emerald'],//绿宝石
        ['minecraft:gold_ingot'],//金
        ['minecraft:iron_ingot'],//铁
]
    //定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['aquaculturedelight:bass_stew',1],//鲈鱼炖菜
        ['crockpot:ceviche',1],//酸橘汁腌鱼
        ['crockpot:fish_sticks',1],//炸鱼
        ['minecraft:salmon',4],//生鲑鱼
        ['minecraft:cod',4],//生鳕鱼
        ['lightmanscurrency:coin_gold',3],//硬币与物品 金币 
    ]
    let lootItem = [
        ['kaleidoscope_cookery:stargazy_pie',0.2],//仰望星空派
        ['veggiesdelight:fish_and_chips',0.2],//炸鱼薯条
        ['aquamirae:sea_stew',0.3],//海灵 海之炖菜
        ['aquamirae:sea_casserole',0.3],//海灵 海味砂锅
]
    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('dungeons_arise:chests/undead_pirate_ship/undead_pirate_ship_treasure')//幽灵海盗船
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([1, 2], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })
    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('dungeons_arise:chests/undead_pirate_ship/undead_pirate_ship_treasure')///幽灵海盗船
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('dungeons_arise:chests/undead_pirate_ship/undead_pirate_ship_treasure')///幽灵海盗船
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})
//废弃寺庙1
LootJS.modifiers(event => {//废弃寺庙1
    //定义删除物品,[物品id]
    let removeLoot = [
      
    ]
//定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['minecraft:beetroot_soup',1],//甜菜汤
        ['minecraft:mushroom_stew',1],//蘑菇煲
        ['minecraft:rabbit_stew',1],//兔肉煲
        ['lightmanscurrency:coin_gold',3],//硬币与物品 金币 

    ]
    let lootItem = [
       ['vanillacookbook:sword_lollipop',0.3],//棒棒糖剑

    ]
    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('dungeons_arise:chests/abandoned_temple/abandoned_temple_map')///废弃寺庙1
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([2, 3], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })
    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('dungeons_arise:chests/abandoned_temple/abandoned_temple_map')//废弃寺庙1
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('dungeons_arise:chests/abandoned_temple/abandoned_temple_map')//废弃寺庙1
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})
//废弃寺庙2
LootJS.modifiers(event => {//废弃寺庙2
    //定义删除物品,[物品id]
    let removeLoot = [
      
    ]
//定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['minecraft:beetroot_soup',1],//甜菜汤
        ['minecraft:mushroom_stew',1],//蘑菇煲
        ['minecraft:rabbit_stew',1],//兔肉煲
        ['lightmanscurrency:coin_gold',3],//硬币与物品 金币 

    ]
    let lootItem = [
       ['vanillacookbook:sword_lollipop',0.3],//棒棒糖剑

    ]
    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('dungeons_arise:chests/abandoned_temple/abandoned_temple_entrance')///废弃寺庙2
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([2, 3], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })
    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('dungeons_arise:chests/abandoned_temple/abandoned_temple_entrance')//废弃寺庙2
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('dungeons_arise:chests/abandoned_temple/abandoned_temple_entrance')//废弃寺庙2
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})
//提丰遗迹
LootJS.modifiers(event => {//提丰遗迹
    //定义删除物品,[物品id]
    let removeLoot = [
        ['enigmaticlegacy:iron_ring'],//铁指环
        ['minecraft:bow'],//弓
        ['minecraft:golden_horse_armor'],//金马凯
        ['minecraft:iron_horse_armor'],//铁马凯
        ['minecraft:iron_helmet'],//铁头盔
        ['minecraft:iron_chestplate'],//铁胸甲
        ['minecraft:iron_leggings'],//铁护腿
        ['minecraft:iron_boots'],//铁靴子
        ['minecraft:iron_sword'],//铁剑
        ['minecraft:iron_axe'],//铁斧
        ['minecraft:saddle'],//马鞍
        ['minecraft:clock'],//钟
        ['minecraft:sand'],//沙子
    ]
    //定义添加权重物品[物品id,概率]
    let weightLootItem = [
       ['aquamirae:sea_stew',3],//海灵 海之炖菜
       ['aquamirae:sea_casserole',3],//海灵 海味砂锅
       ['aquaculture:neptunium_ingot',9],//水产 海王锭
       ['collectorsreap:sea_wrap',3],//海洋卷

    ]
 let lootItem = [
       ['aquamirae:poseidons_breakfast',0.2],//海灵 波塞冬早餐
       ['crockpot:moqueca',0.2],//烹饪锅 海鲜杂烩
       ['aquaculturedelight:turtle_meat_dish',0.2],//海味乐事 海龟肉料理
       ['aquaculture:neptunium_ingot',0.4]//水产 海王锭
]

    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('dungeons_arise:chests/typhon/typhon_treasure')///提丰遗迹
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([1, 2], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('dungeons_arise:chests/typhon/typhon_treasure')//提丰遗迹
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('dungeons_arise:chests/typhon/typhon_treasure')///提丰遗迹
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})
//光之塔
LootJS.modifiers(event => {//光之塔
    //定义删除物品,[物品id]
    let removeLoot = [
        ['minecraft:feather'],
        ['minecraft:gold_nugget'],
        ['minecraft:map'],
        ['minecraft:compass'],
        ['minecraft:iron_ingot'],
        ['minecraft:ender_pearl'],
        ['touhou_little_maid:power_point'],
]

     //定义添加权重物品[物品id,概率]
    let weightLootItem = [
        [Item.of('minecraft:firework_rocket', '{Fireworks:{Flight:3b}}'),1],//烟花火箭
        ['minecraft:phantom_membrane',3],//幻翼膜
        ['smc:ice_tea',1],//星喵 冰红茶
    ]
     let lootItem = [
        ['artifacts:umbrella',0.2],//奇异饰品 雨伞
        ['confluence:lucky_horseshoe',0.2]//泰拉饰品 幸运马掌
    ]

    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('dungeons_arise:chests/lighthouse/lighthouse_top')///光之塔
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([2, 4], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('dungeons_arise:chests/lighthouse/lighthouse_top')//光之塔
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('dungeons_arise:chests/lighthouse/lighthouse_top')///光之塔
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})
//祸水澡堂
LootJS.modifiers(event => {//祸水澡堂
      //定义删除物品,[物品id]
    let removeLoot = [
        ['minecraft:potion'],//药水
    ]

    //定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['vanillacookbook:spicy_meatball', 1],//辛辣肉丸
        ['lightmanscurrency:coin_gold',3],//硬币与物品 金币
        ['kaleidoscope_cookery:mantou',2],//馒头
        ['kaleidoscope_cookery:baozi',2],//包子
       
    ]

    let lootItem = [
        ['youkaishomecoming:higi_chocolate',0.3],//秘仪巧克力
        ['crockpot:hot_chili',0.2],//辣炖肉
    ]


    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('dungeons_arise:chests/bathhouse/bathhouse_barrels')//祸水澡堂
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([1, 2], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('dungeons_arise:chests/bathhouse/bathhouse_barrels')
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('dungeons_arise:chests/bathhouse/bathhouse_barrels')//祸水澡堂
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})
//绿荫酒吧
LootJS.modifiers(event => {//绿荫酒吧
    //定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['fruitsdelight:bellini_cocktail', 1],//贝里尼鸡尾酒
        ['vinery:creepers_crush', 1],//苦力怕葡萄酒
        ['vinery:red_wine', 1],//红葡萄酒
        ['vanillacookbook:honey_candy', 1],//蜜糖
        ['vinery:wine_bottle', 3],//酒瓶
        ['lightmanscurrency:coin_gold',3],//硬币与物品 金币
        
    ]

    let lootItem = [
        ['vinery:solaris_wine', 0.2],//果酱白葡萄蜜酒
        ['vinery:stal_wine', 0.2],//可可醇酿红葡萄酒
        ['vinery:red_wine', 0.2],//蔬菜鸡尾酒
    ]

    //定义删除物品,[物品id]
    let removeLoot = [
        ['minecraft:potion'],//药水
    ]

    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('dungeons_arise:chests/greenwood_pub/greenwood_pub_barrels_normal')//绿荫酒吧
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([1, 2], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('dungeons_arise:chests/greenwood_pub/greenwood_pub_barrels_normal')
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('dungeons_arise:chests/greenwood_pub/greenwood_pub_barrels_normal')//绿荫酒吧
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})
//绿荫酒吧2
LootJS.modifiers(event => {//绿荫酒吧2
    //定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['fruitsdelight:bellini_cocktail', 1],//贝里尼鸡尾酒
        ['vinery:creepers_crush', 1],//苦力怕葡萄酒
        ['vinery:red_wine', 1],//红葡萄酒
        ['vanillacookbook:honey_candy', 1],//蜜糖
        ['vinery:wine_bottle', 3],//酒瓶
        ['lightmanscurrency:coin_gold',3],//硬币与物品 金币
    ]

    let lootItem = [
        ['vinery:solaris_wine', 0.2],//果酱白葡萄蜜酒
        ['vinery:stal_wine', 0.2],//可可醇酿红葡萄酒
        ['vinery:red_wine', 0.2],//蔬菜鸡尾酒
    ]

    //定义删除物品,[物品id]
    let removeLoot = [
        ['minecraft:potion'],//药水
    ]

    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('dungeons_arise:chests/greenwood_pub/greenwood_pub_barrels_hallways')//绿荫酒吧2
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([1, 2], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('dungeons_arise:chests/greenwood_pub/greenwood_pub_barrels_hallways')
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('dungeons_arise:chests/greenwood_pub/greenwood_pub_barrels_hallways')//绿荫酒吧2
            .removeLoot(item)//删除遍历removeLoot的物品 

     })
})
//繁花之宫1
LootJS.modifiers(event => {//繁花之宫1
    //定义删除物品,[物品id]
    let removeLoot = [
        ['minecraft:coal'],//煤炭
        ['minecraft:glow_berries'],//发光浆果
        ['minecraft:compass'],//指南针
        ['minecraft:beetroot_seeds'],//甜菜种子
        ['minecraft:melon_seeds'],//西瓜种子
        ['minecraft:rail'],//铁轨
        ['minecraft:powered_rail'],//动力铁轨
        ['minecraft:activator_rail'],//激活铁轨
        ['minecraft:detector_rail'],//探测铁轨
        ['minecraft:leather'],//皮革
        ['minecraft:iron_ingot'],//铁
        ['minecraft:gold_ingot'],//金
        ['minecraft:emerald'],//绿宝石
        ['minecraft:diamond'],//钻石
        ['minecraft:lapis_lazuli'],//青金石
        ['minecraft:redstone'],//红石
        ['additionaladditions:rope'],//绳子
        ['supplementaries:rope'],//绳索
        ['farmersdelight:rope'],//绳子
        ['additionaladditions:glow_stick'],//荧光棒
        ['muffins_thaidelight:pepper_seeds'],//辣椒种子
        ['minecraft:torch'],//火把
        ['dumplings_delight:chinese_cabbage_seeds'],//白菜种子
        [('minecraft:clock')],//钟
        [Item.of('minecraft:iron_axe')],//铁斧头
        ['farmersdelight:cabbage_seeds'],//卷心菜种子
        ['additionaladditions:rose_gold_upgrade'],//锻造模板
        ['minecraft:pumpkin_seeds'],//南瓜种子
        ['galosphere:silver_upgrade_smithing_template'],//锻造模板
        [Item.of('minecraft:potion', '{Potion:"ars_nouveau:mana_regen_potion_long"}')],//药水
        ['ars_nouveau:music_disc_aria_biblio'],//唱片
    ]
//定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['minecraft:netherite_scrap',1],//下界合金碎片
      ['lightmanscurrency:coin_gold',3],//金币
      ['cosmopolitan:toffee_golden_apple',1],//糖浆金苹果
      ['minecraft:golden_apple',1],//金苹果
      ['terramity:gaianite_cluster',1],//盖亚矿簇
    ]
    let lootItem = [    
        ['enigmaticlegacy:golem_heart', 0.03],//魔像之心
        ['enigmaticaddons:lost_engine', 0.03],//失落引擎
        ['enigmaticaddons:forgotten_ice', 0.03],//忘却冰晶
        ['enigmaticlegacy:angel_blessing', 0.03],//天使之祝
        ['enigmaticlegacy:blazing_core', 0.03],//烈焰之核
        ['enigmaticlegacy:ocean_stone', 0.03],//海洋意志
        [Item.of('legendary_monsters:golden_halbert', '{Damage:0}'),0.05],//金戟
        [Item.of('legendary_monsters:soul_great_sword', '{Damage:0}'),0.05],//灵魂巨剑
        [Item.of('meetyourfight:twilights_thorn', '{Damage:0}'),0.05],//胧暮荆棘
        [Item.of('meetyourfight:depth_star', '{Damage:0}'),0.05],//深度之星
        [Item.of('terramity:simmeredge', '{Damage:0}'),0.05],//预燃利刃
        [Item.of('terramity:hellspec_sword', '{Damage:0}'),0.05],//地狱合金剑
        [Item.of('composite_material:echoium_sword', '{Damage:0}'),0.05],//回响之剑
        [Item.of('terramity:stratus_storm_ruler', '{Damage:0}'),0.05],//天空与风暴统领
        [Item.of('terramity:conductite_sword', '{Damage:0}'),0.05],//聚电剑
        [Item.of('farmersdelight:toast_baguette', '{Damage:0}'),0.05],//烤长棍面包
        [Item.of('alexscaves:desolate_dagger', '{Damage:0}'),0.05],//荒芜匕首
        [Item.of('cataclysm:athame', '{Damage:0}'),0.05],//仪式匕首
        [Item.of('terramity:hellspec_axe', '{Damage:0}'),0.05],//地狱合金斧
        [Item.of('terramity:icebrand', '{Damage:0}'),0.05],//冻结烙印
        [Item.of('terramity:conductite_axe', '{Damage:0}'),0.05],//聚电斧
    ]
    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('dungeons_arise:chests/shiraz_palace/shiraz_palace_library')//繁花之宫1
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([2, 3], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })
    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('dungeons_arise:chests/shiraz_palace/shiraz_palace_library')//繁花之宫1
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('dungeons_arise:chests/shiraz_palace/shiraz_palace_library')//繁花之宫1
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})
//繁花之宫2
LootJS.modifiers(event => {//繁花之宫2
    //定义删除物品,[物品id]
    let removeLoot = [
        ['minecraft:coal'],//煤炭
        ['minecraft:glow_berries'],//发光浆果
        ['minecraft:compass'],//指南针
        ['minecraft:beetroot_seeds'],//甜菜种子
        ['minecraft:melon_seeds'],//西瓜种子
        ['minecraft:rail'],//铁轨
        ['minecraft:powered_rail'],//动力铁轨
        ['minecraft:activator_rail'],//激活铁轨
        ['minecraft:detector_rail'],//探测铁轨
        ['minecraft:leather'],//皮革
        ['minecraft:iron_ingot'],//铁
        ['minecraft:gold_ingot'],//金
        ['minecraft:emerald'],//绿宝石
        ['minecraft:diamond'],//钻石
        ['minecraft:lapis_lazuli'],//青金石
        ['minecraft:redstone'],//红石
        ['additionaladditions:rope'],//绳子
        ['supplementaries:rope'],//绳索
        ['farmersdelight:rope'],//绳子
        ['additionaladditions:glow_stick'],//荧光棒
        ['muffins_thaidelight:pepper_seeds'],//辣椒种子
        ['minecraft:torch'],//火把
        ['dumplings_delight:chinese_cabbage_seeds'],//白菜种子
        [('minecraft:clock')],//钟
        [Item.of('minecraft:iron_axe')],//铁斧头
        ['farmersdelight:cabbage_seeds'],//卷心菜种子
        ['additionaladditions:rose_gold_upgrade'],//锻造模板
        ['minecraft:pumpkin_seeds'],//南瓜种子
        ['galosphere:silver_upgrade_smithing_template'],//锻造模板
        [Item.of('minecraft:potion', '{Potion:"ars_nouveau:mana_regen_potion_long"}')],//药水
        ['ars_nouveau:music_disc_aria_biblio'],//唱片
    ]
//定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['minecraft:netherite_scrap',1],//下界合金碎片
        ['lightmanscurrency:coin_gold',3],//金币
        ['crabbersdelight:surf_and_turf',1],//海陆大餐
        ['collectorsreap:land_and_sea_burger',1],//海陆堡
        ['terramity:gaianite_cluster',1],//盖亚矿簇
    ]
    let lootItem = [    
        ['enigmaticlegacy:golem_heart', 0.03],//魔像之心
        ['enigmaticaddons:lost_engine', 0.03],//失落引擎
        ['enigmaticaddons:forgotten_ice', 0.03],//忘却冰晶
        ['enigmaticlegacy:angel_blessing', 0.03],//天使之祝
        ['enigmaticlegacy:blazing_core', 0.03],//烈焰之核
        ['enigmaticlegacy:ocean_stone', 0.03],//海洋意志
        [Item.of('legendary_monsters:golden_halbert', '{Damage:0}'),0.05],//金戟
        [Item.of('legendary_monsters:soul_great_sword', '{Damage:0}'),0.05],//灵魂巨剑
        [Item.of('meetyourfight:twilights_thorn', '{Damage:0}'),0.05],//胧暮荆棘
        [Item.of('meetyourfight:depth_star', '{Damage:0}'),0.05],//深度之星
        [Item.of('terramity:simmeredge', '{Damage:0}'),0.05],//预燃利刃
        [Item.of('terramity:hellspec_sword', '{Damage:0}'),0.05],//地狱合金剑
        [Item.of('composite_material:echoium_sword', '{Damage:0}'),0.05],//回响之剑
        [Item.of('terramity:stratus_storm_ruler', '{Damage:0}'),0.05],//天空与风暴统领
        [Item.of('terramity:conductite_sword', '{Damage:0}'),0.05],//聚电剑
        [Item.of('farmersdelight:toast_baguette', '{Damage:0}'),0.05],//烤长棍面包
        [Item.of('alexscaves:desolate_dagger', '{Damage:0}'),0.05],//荒芜匕首
        [Item.of('cataclysm:athame', '{Damage:0}'),0.05],//仪式匕首
        [Item.of('terramity:hellspec_axe', '{Damage:0}'),0.05],//地狱合金斧
        [Item.of('terramity:icebrand', '{Damage:0}'),0.05],//冻结烙印
        [Item.of('terramity:conductite_axe', '{Damage:0}'),0.05],//聚电斧
    ]
    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('dungeons_arise:chests/shiraz_palace/shiraz_palace_towers')//繁花之宫2
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([2, 3], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })
    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('dungeons_arise:chests/shiraz_palace/shiraz_palace_towers')//繁花之宫2
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('dungeons_arise:chests/shiraz_palace/shiraz_palace_towers')//繁花之宫2
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})
//繁花之宫3
LootJS.modifiers(event => {//繁花之宫3
    //定义删除物品,[物品id]
    let removeLoot = [
        ['minecraft:coal'],//煤炭
        ['minecraft:glow_berries'],//发光浆果
        ['minecraft:compass'],//指南针
        ['minecraft:beetroot_seeds'],//甜菜种子
        ['minecraft:melon_seeds'],//西瓜种子
        ['minecraft:rail'],//铁轨
        ['minecraft:powered_rail'],//动力铁轨
        ['minecraft:activator_rail'],//激活铁轨
        ['minecraft:detector_rail'],//探测铁轨
        ['minecraft:leather'],//皮革
        ['minecraft:iron_ingot'],//铁
        ['minecraft:gold_ingot'],//金
        ['minecraft:emerald'],//绿宝石
        ['minecraft:diamond'],//钻石
        ['minecraft:lapis_lazuli'],//青金石
        ['minecraft:redstone'],//红石
        ['additionaladditions:rope'],//绳子
        ['supplementaries:rope'],//绳索
        ['farmersdelight:rope'],//绳子
        ['additionaladditions:glow_stick'],//荧光棒
        ['muffins_thaidelight:pepper_seeds'],//辣椒种子
        ['minecraft:torch'],//火把
        ['dumplings_delight:chinese_cabbage_seeds'],//白菜种子
        [('minecraft:clock')],//钟
        [Item.of('minecraft:iron_axe')],//铁斧头
        ['farmersdelight:cabbage_seeds'],//卷心菜种子
        ['additionaladditions:rose_gold_upgrade'],//锻造模板
        ['minecraft:pumpkin_seeds'],//南瓜种子
        ['galosphere:silver_upgrade_smithing_template'],//锻造模板
        [Item.of('minecraft:potion', '{Potion:"ars_nouveau:mana_regen_potion_long"}')],//药水
        ['ars_nouveau:music_disc_aria_biblio'],//唱片
    ]
//定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['minecraft:netherite_scrap',1],//下界合金碎片
        ['lightmanscurrency:coin_gold',3],//金币
        ['fruitsdelight:mangosteen_cake',1],//山竹糕
        ['extrameat:buzzy_muffin',1],//嗡嗡纸杯蛋糕
        ['terramity:gaianite_cluster',1],//盖亚矿簇
    ]
    let lootItem = [    
        ['enigmaticlegacy:golem_heart', 0.03],//魔像之心
        ['enigmaticaddons:lost_engine', 0.03],//失落引擎
        ['enigmaticaddons:forgotten_ice', 0.03],//忘却冰晶
        ['enigmaticlegacy:angel_blessing', 0.03],//天使之祝
        ['enigmaticlegacy:blazing_core', 0.03],//烈焰之核
        ['enigmaticlegacy:ocean_stone', 0.03],//海洋意志
        [Item.of('legendary_monsters:golden_halbert', '{Damage:0}'),0.05],//金戟
        [Item.of('legendary_monsters:soul_great_sword', '{Damage:0}'),0.05],//灵魂巨剑
        [Item.of('meetyourfight:twilights_thorn', '{Damage:0}'),0.05],//胧暮荆棘
        [Item.of('meetyourfight:depth_star', '{Damage:0}'),0.05],//深度之星
        [Item.of('terramity:simmeredge', '{Damage:0}'),0.05],//预燃利刃
        [Item.of('terramity:hellspec_sword', '{Damage:0}'),0.05],//地狱合金剑
        [Item.of('composite_material:echoium_sword', '{Damage:0}'),0.05],//回响之剑
        [Item.of('terramity:stratus_storm_ruler', '{Damage:0}'),0.05],//天空与风暴统领
        [Item.of('terramity:conductite_sword', '{Damage:0}'),0.05],//聚电剑
        [Item.of('farmersdelight:toast_baguette', '{Damage:0}'),0.05],//烤长棍面包
        [Item.of('alexscaves:desolate_dagger', '{Damage:0}'),0.05],//荒芜匕首
        [Item.of('cataclysm:athame', '{Damage:0}'),0.05],//仪式匕首
        [Item.of('terramity:hellspec_axe', '{Damage:0}'),0.05],//地狱合金斧
        [Item.of('terramity:icebrand', '{Damage:0}'),0.05],//冻结烙印
        [Item.of('terramity:conductite_axe', '{Damage:0}'),0.05],//聚电斧
    ]
    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('dungeons_arise:chests/shiraz_palace/shiraz_palace_rooms')//繁花之宫3
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([2, 3], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })
    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('dungeons_arise:chests/shiraz_palace/shiraz_palace_rooms')//繁花之宫3
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('dungeons_arise:chests/shiraz_palace/shiraz_palace_rooms')//繁花之宫3
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})
//繁花之宫4
LootJS.modifiers(event => {//繁花之宫4
    //定义删除物品,[物品id]
    let removeLoot = [
        ['minecraft:coal'],//煤炭
        ['minecraft:glow_berries'],//发光浆果
        ['minecraft:compass'],//指南针
        ['minecraft:beetroot_seeds'],//甜菜种子
        ['minecraft:melon_seeds'],//西瓜种子
        ['minecraft:rail'],//铁轨
        ['minecraft:powered_rail'],//动力铁轨
        ['minecraft:activator_rail'],//激活铁轨
        ['minecraft:detector_rail'],//探测铁轨
        ['minecraft:leather'],//皮革
        ['minecraft:iron_ingot'],//铁
        ['minecraft:gold_ingot'],//金
        ['minecraft:emerald'],//绿宝石
        ['minecraft:diamond'],//钻石
        ['minecraft:lapis_lazuli'],//青金石
        ['minecraft:redstone'],//红石
        ['additionaladditions:rope'],//绳子
        ['supplementaries:rope'],//绳索
        ['farmersdelight:rope'],//绳子
        ['additionaladditions:glow_stick'],//荧光棒
        ['muffins_thaidelight:pepper_seeds'],//辣椒种子
        ['minecraft:torch'],//火把
        ['dumplings_delight:chinese_cabbage_seeds'],//白菜种子
        [('minecraft:clock')],//钟
        [Item.of('minecraft:iron_axe')],//铁斧头
        ['farmersdelight:cabbage_seeds'],//卷心菜种子
        ['additionaladditions:rose_gold_upgrade'],//锻造模板
        ['minecraft:pumpkin_seeds'],//南瓜种子
        ['galosphere:silver_upgrade_smithing_template'],//锻造模板
        [Item.of('minecraft:potion', '{Potion:"ars_nouveau:mana_regen_potion_long"}')],//药水
        ['ars_nouveau:music_disc_aria_biblio'],//唱片
    ]
//定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['minecraft:netherite_scrap',1],//下界合金碎片
        ['lightmanscurrency:coin_gold',3],//金币
        ['cosmopolitan:wild_risotto',1],//野味意式烩饭
        ['galospheric_delight:allurite_pie_slice',1],//幽蓝晶派切片
        ['terramity:gaianite_cluster',1],//盖亚矿簇
    ]
    let lootItem = [    
        ['enigmaticlegacy:golem_heart', 0.03],//魔像之心
        ['enigmaticaddons:lost_engine', 0.03],//失落引擎
        ['enigmaticaddons:forgotten_ice', 0.03],//忘却冰晶
        ['enigmaticlegacy:angel_blessing', 0.03],//天使之祝
        ['enigmaticlegacy:blazing_core', 0.03],//烈焰之核
        ['enigmaticlegacy:ocean_stone', 0.03],//海洋意志
        [Item.of('legendary_monsters:golden_halbert', '{Damage:0}'),0.05],//金戟
        [Item.of('legendary_monsters:soul_great_sword', '{Damage:0}'),0.05],//灵魂巨剑
        [Item.of('meetyourfight:twilights_thorn', '{Damage:0}'),0.05],//胧暮荆棘
        [Item.of('meetyourfight:depth_star', '{Damage:0}'),0.05],//深度之星
        [Item.of('terramity:simmeredge', '{Damage:0}'),0.05],//预燃利刃
        [Item.of('terramity:hellspec_sword', '{Damage:0}'),0.05],//地狱合金剑
        [Item.of('composite_material:echoium_sword', '{Damage:0}'),0.05],//回响之剑
        [Item.of('terramity:stratus_storm_ruler', '{Damage:0}'),0.05],//天空与风暴统领
        [Item.of('terramity:conductite_sword', '{Damage:0}'),0.05],//聚电剑
        [Item.of('farmersdelight:toast_baguette', '{Damage:0}'),0.05],//烤长棍面包
        [Item.of('alexscaves:desolate_dagger', '{Damage:0}'),0.05],//荒芜匕首
        [Item.of('cataclysm:athame', '{Damage:0}'),0.05],//仪式匕首
        [Item.of('terramity:hellspec_axe', '{Damage:0}'),0.05],//地狱合金斧
        [Item.of('terramity:icebrand', '{Damage:0}'),0.05],//冻结烙印
        [Item.of('terramity:conductite_axe', '{Damage:0}'),0.05],//聚电斧
    ]
    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('dungeons_arise:chests/shiraz_palace/shiraz_palace_gardens')//繁花之宫4
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([2, 3], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })
    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('dungeons_arise:chests/shiraz_palace/shiraz_palace_gardens')//繁花之宫4
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('dungeons_arise:chests/shiraz_palace/shiraz_palace_gardens')//繁花之宫4
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})
//繁花之宫5
LootJS.modifiers(event => {//繁花之宫5
    //定义删除物品,[物品id]
    let removeLoot = [
        ['minecraft:coal'],//煤炭
        ['minecraft:glow_berries'],//发光浆果
        ['minecraft:compass'],//指南针
        ['minecraft:beetroot_seeds'],//甜菜种子
        ['minecraft:melon_seeds'],//西瓜种子
        ['minecraft:rail'],//铁轨
        ['minecraft:powered_rail'],//动力铁轨
        ['minecraft:activator_rail'],//激活铁轨
        ['minecraft:detector_rail'],//探测铁轨
        ['minecraft:leather'],//皮革
        ['minecraft:iron_ingot'],//铁
        ['minecraft:gold_ingot'],//金
        ['minecraft:emerald'],//绿宝石
        ['minecraft:diamond'],//钻石
        ['minecraft:lapis_lazuli'],//青金石
        ['minecraft:redstone'],//红石
        ['additionaladditions:rope'],//绳子
        ['supplementaries:rope'],//绳索
        ['farmersdelight:rope'],//绳子
        ['additionaladditions:glow_stick'],//荧光棒
        ['muffins_thaidelight:pepper_seeds'],//辣椒种子
        ['minecraft:torch'],//火把
        ['dumplings_delight:chinese_cabbage_seeds'],//白菜种子
        [('minecraft:clock')],//钟
        [Item.of('minecraft:iron_axe')],//铁斧头
        ['farmersdelight:cabbage_seeds'],//卷心菜种子
        ['additionaladditions:rose_gold_upgrade'],//锻造模板
        ['minecraft:pumpkin_seeds'],//南瓜种子
        ['galosphere:silver_upgrade_smithing_template'],//锻造模板
        [Item.of('minecraft:potion', '{Potion:"ars_nouveau:mana_regen_potion_long"}')],//药水
        ['ars_nouveau:music_disc_aria_biblio'],//唱片
    ]
//定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['minecraft:netherite_scrap',1],//下界合金碎片
        ['lightmanscurrency:coin_gold',3],//金币
        ['bountifulfares:ancient_custard',1],//远古奶冻
        ['galospheric_delight:fruits_in_amethyst_dust',1],//紫金渍果
        ['terramity:gaianite_cluster',1],//盖亚矿簇
    ]
    let lootItem = [    
        ['enigmaticlegacy:golem_heart', 0.03],//魔像之心
        ['enigmaticaddons:lost_engine', 0.03],//失落引擎
        ['enigmaticaddons:forgotten_ice', 0.03],//忘却冰晶
        ['enigmaticlegacy:angel_blessing', 0.03],//天使之祝
        ['enigmaticlegacy:blazing_core', 0.03],//烈焰之核
        ['enigmaticlegacy:ocean_stone', 0.03],//海洋意志
        [Item.of('legendary_monsters:golden_halbert', '{Damage:0}'),0.05],//金戟
        [Item.of('legendary_monsters:soul_great_sword', '{Damage:0}'),0.05],//灵魂巨剑
        [Item.of('meetyourfight:twilights_thorn', '{Damage:0}'),0.05],//胧暮荆棘
        [Item.of('meetyourfight:depth_star', '{Damage:0}'),0.05],//深度之星
        [Item.of('terramity:simmeredge', '{Damage:0}'),0.05],//预燃利刃
        [Item.of('terramity:hellspec_sword', '{Damage:0}'),0.05],//地狱合金剑
        [Item.of('composite_material:echoium_sword', '{Damage:0}'),0.05],//回响之剑
        [Item.of('terramity:stratus_storm_ruler', '{Damage:0}'),0.05],//天空与风暴统领
        [Item.of('terramity:conductite_sword', '{Damage:0}'),0.05],//聚电剑
        [Item.of('farmersdelight:toast_baguette', '{Damage:0}'),0.05],//烤长棍面包
        [Item.of('alexscaves:desolate_dagger', '{Damage:0}'),0.05],//荒芜匕首
        [Item.of('cataclysm:athame', '{Damage:0}'),0.05],//仪式匕首
        [Item.of('terramity:hellspec_axe', '{Damage:0}'),0.05],//地狱合金斧
        [Item.of('terramity:icebrand', '{Damage:0}'),0.05],//冻结烙印
        [Item.of('terramity:conductite_axe', '{Damage:0}'),0.05],//聚电斧
    ]
    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('dungeons_arise:chests/shiraz_palace/shiraz_palace_elite')//繁花之宫5
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([2, 3], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })
    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('dungeons_arise:chests/shiraz_palace/shiraz_palace_elite')//繁花之宫5
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('dungeons_arise:chests/shiraz_palace/shiraz_palace_elite')//繁花之宫5
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})
//繁花之宫6
LootJS.modifiers(event => {//繁花之宫6
    //定义删除物品,[物品id]
    let removeLoot = [
        ['minecraft:coal'],//煤炭
        ['minecraft:glow_berries'],//发光浆果
        ['minecraft:compass'],//指南针
        ['minecraft:beetroot_seeds'],//甜菜种子
        ['minecraft:melon_seeds'],//西瓜种子
        ['minecraft:rail'],//铁轨
        ['minecraft:powered_rail'],//动力铁轨
        ['minecraft:activator_rail'],//激活铁轨
        ['minecraft:detector_rail'],//探测铁轨
        ['minecraft:leather'],//皮革
        ['minecraft:iron_ingot'],//铁
        ['minecraft:gold_ingot'],//金
        ['minecraft:emerald'],//绿宝石
        ['minecraft:diamond'],//钻石
        ['minecraft:lapis_lazuli'],//青金石
        ['minecraft:redstone'],//红石
        ['additionaladditions:rope'],//绳子
        ['supplementaries:rope'],//绳索
        ['farmersdelight:rope'],//绳子
        ['additionaladditions:glow_stick'],//荧光棒
        ['muffins_thaidelight:pepper_seeds'],//辣椒种子
        ['minecraft:torch'],//火把
        ['dumplings_delight:chinese_cabbage_seeds'],//白菜种子
        [('minecraft:clock')],//钟
        [Item.of('minecraft:iron_axe')],//铁斧头
        ['farmersdelight:cabbage_seeds'],//卷心菜种子
        ['additionaladditions:rose_gold_upgrade'],//锻造模板
        ['minecraft:pumpkin_seeds'],//南瓜种子
        ['galosphere:silver_upgrade_smithing_template'],//锻造模板
        [Item.of('minecraft:potion', '{Potion:"ars_nouveau:mana_regen_potion_long"}')],//药水
        ['ars_nouveau:music_disc_aria_biblio'],//唱片
    ]
//定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['minecraft:netherite_scrap',1],//下界合金碎片
        ['lightmanscurrency:coin_gold',3],//金币
        ['crockpot:potato_tornado',1],//花式回旋块茎
         ['netherdepthsupgrade:baked_soulsucker_stew',1],//烘培魂吸炖
        ['terramity:gaianite_cluster',1],//盖亚矿簇
    ]
    let lootItem = [    
        ['enigmaticlegacy:golem_heart', 0.03],//魔像之心
        ['enigmaticaddons:lost_engine', 0.03],//失落引擎
        ['enigmaticaddons:forgotten_ice', 0.03],//忘却冰晶
        ['enigmaticlegacy:angel_blessing', 0.03],//天使之祝
        ['enigmaticlegacy:blazing_core', 0.03],//烈焰之核
        ['enigmaticlegacy:ocean_stone', 0.03],//海洋意志
        [Item.of('legendary_monsters:golden_halbert', '{Damage:0}'),0.05],//金戟
        [Item.of('legendary_monsters:soul_great_sword', '{Damage:0}'),0.05],//灵魂巨剑
        [Item.of('meetyourfight:twilights_thorn', '{Damage:0}'),0.05],//胧暮荆棘
        [Item.of('meetyourfight:depth_star', '{Damage:0}'),0.05],//深度之星
        [Item.of('terramity:simmeredge', '{Damage:0}'),0.05],//预燃利刃
        [Item.of('terramity:hellspec_sword', '{Damage:0}'),0.05],//地狱合金剑
        [Item.of('composite_material:echoium_sword', '{Damage:0}'),0.05],//回响之剑
        [Item.of('terramity:stratus_storm_ruler', '{Damage:0}'),0.05],//天空与风暴统领
        [Item.of('terramity:conductite_sword', '{Damage:0}'),0.05],//聚电剑
        [Item.of('farmersdelight:toast_baguette', '{Damage:0}'),0.05],//烤长棍面包
        [Item.of('alexscaves:desolate_dagger', '{Damage:0}'),0.05],//荒芜匕首
        [Item.of('cataclysm:athame', '{Damage:0}'),0.05],//仪式匕首
        [Item.of('terramity:hellspec_axe', '{Damage:0}'),0.05],//地狱合金斧
        [Item.of('terramity:icebrand', '{Damage:0}'),0.05],//冻结烙印
        [Item.of('terramity:conductite_axe', '{Damage:0}'),0.05],//聚电斧
    ]
    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('dungeons_arise:chests/shiraz_palace/shiraz_palace_treasure')//繁花之宫6
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([2, 3], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })
    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('dungeons_arise:chests/shiraz_palace/shiraz_palace_treasure')//繁花之宫6
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('dungeons_arise:chests/shiraz_palace/shiraz_palace_treasure')//繁花之宫6
            .removeLoot(item)//删除遍历removeLoot的物品
     })
})

//铁处女1
LootJS.modifiers(event => {///铁处女1
    //定义删除物品,[物品id]
    let removeLoot = [
        ['minecraft:blackstone'],//黑石
        ['minecraft:bone'],//骨头
        ['minecraft:rotten_flesh'],//腐肉
        ['minecraft:beetroot_seeds'],//甜菜种子
        ['minecraft:string'],//线  
        ['minecraft:gold_nugget'],//金粒
        ['minecraft:pumpkin_seeds'],//南瓜种子
        ['minecraft:melon_seeds'],//西瓜种子
        ['minecraft:wheat'],//小麦
        ['minecraft:basalt'],//玄武岩
    ]
    //定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['lightmanscurrency:coin_emerald', 2],//硬币与物品 绿宝石币
        ['composite_material:dungeon_steel_ingot', 3],//复合材料 地牢钢锭
        ['terramity:daemonium_chunk', 3],//terramity 恶魔碎块
        ['farmersdelight:ham',3],//农夫乐事 火腿
        ['immortalers_delight:golden_kwat_toast_slice',3],//千古乐事 金瓦斯麦吐司碎片
    ]

    let lootItem = [
        ['minecraft:netherite_ingot', 0.3],//下界合金锭
        ['brewinandchewin:scarlet_cheese_wheel',0.2],//饮酒作乐 绯红奶酪轮
    ]

    

    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('dungeons_arise:chests/foundry/foundry_passage_exterior')///铁处女1
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([2, 3], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('dungeons_arise:chests/foundry/foundry_passage_exterior')
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('dungeons_arise:chests/foundry/foundry_passage_exterior')//铁处女1
            .removeLoot(item)//删除遍历removeLoot的物品 

     })
})

//铁处女2
LootJS.modifiers(event => {///铁处女2
      //定义删除物品,[物品id]
    let removeLoot = [
        ['minecraft:blackstone'],//黑石
        ['minecraft:bone'],//骨头
        ['minecraft:rotten_flesh'],//腐肉
        ['minecraft:beetroot_seeds'],//甜菜种子
        ['minecraft:string'],//线  
        ['minecraft:gold_nugget'],//金粒
        ['minecraft:pumpkin_seeds'],//南瓜种子
        ['minecraft:melon_seeds'],//西瓜种子
        ['minecraft:wheat'],//小麦
        ['minecraft:basalt'],//玄武岩
        ['minecraft:iron_nugget'],//铁粒
        ['minecraft:chain'],//锁链
        ['minecraft:gold_nugget'],//金粒
        ['minecraft:gilded_blackstone'],//镶金黑石
        ['minecraft:bone_block'],//骨块
        ['minecraft:arrow'],//箭
    ]
    //定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['composite_material:dungeon_steel_ingot', 1],//复合材料 地牢钢锭
        ['mynethersdelight:golden_egg',5],//下界乐事 金蛋
        ['lightmanscurrency:coin_gold',5],//硬币与物品 金币
    ]
    let lootItem = [
        ['minecraft:netherite_scrap', 0.3],//下界合金碎片
        ['enigmaticlegacy:darkest_scroll', 0.3],//神秘遗物 至暗卷轴
        ['mynethersdelight:enchanted_golden_egg', 0.2],//下界乐事 附魔金蛋
        ['mynethersdelight:nether_burger', 0.2],//下界乐事 下界汉堡
    ]

    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('dungeons_arise:chests/foundry/foundry_normal')///铁处女2
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([2, 3], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('dungeons_arise:chests/foundry/foundry_normal')//铁处女2
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('dungeons_arise:chests/foundry/foundry_normal')//铁处女2
            .removeLoot(item)//删除遍历removeLoot的物品 

     })
})
//幻梦塔楼
LootJS.modifiers(event => {//幻梦塔楼
    //定义删除物品,[物品id]
    let removeLoot = [
        ['minecraft:beetroot_seeds'],//甜菜种子
        ['minecraft:iron_ingot'],//铁锭
        ['minecraft:gold_ingot'],//金锭
        ['minecraft:iron_horse_armor'],//铁马铠
        ['minecraft:golden_carrot'],//金胡萝卜
        ['minecraft:glistering_melon_slice'],//金西瓜
        ['touhou_little_maid:power_point'],//P点
        ['minecraft:saddle'],//鞍
        ['minecraft:cake'],//蛋糕
        ['minecraft:iron_pickaxe'],//铁镐
        ['minecraft:iron_shovel'],//铁铲
        ['minecraft:iron_sword'],//铁剑
        ['minecraft:iron_helmet'],//铁头盔
        ['minecraft:iron_chestplate'],//铁胸甲
        ['minecraft:iron_leggings'],//铁护腿
        ['minecraft:iron_boots'],//铁靴
        ['minecraft:enchanting_table'],//附魔台
        ['minecraft:ender_eye'],//末影之眼
        ['minecraft:ender_pearl'],//末影珍珠
        ['touhou_little_maid:shrine'],//神龛
        ['simplyswords:runic_tablet'],//符文石板
        ['enigmaticlegacy:recall_potion'],//召回药水
        ['minecraft:phantom_membrane'],//幻翼膜
        ['minecraft:diamond_horse_armor'],//钻石马铠
        ['enigmaticlegacy:lore_inscriber'],//设计师的墨水
        ['minecraft:golden_horse_armor'],//金马铠
        ['minecraft:end_crystal'],//末地水晶
        ['simplyswords:sword_on_a_stick'],//一把奇怪的武器
        ['minecraft:diamond_helmet'],//钻石头盔
        ['minecraft:diamond_chestplate'],//钻石胸甲
        ['minecraft:diamond_leggings'],//钻石护腿
        ['minecraft:diamond_boots'],//钻石靴
        ['minecraft:diamond_pickaxe'],//钻石镐
        ['minecraft:diamond_shovel'],//钻石铲
        ['minecraft:diamond_sword'],//钻石剑
        ['minecraft:experience_bottle'],//附魔之瓶
        ['minecraft:flint_and_steel'],//打火石
        ['minecraft:wither_rose'],//凋灵玫瑰
        ['minecraft:golden_sword'],//金剑
        ['minecraft:crossbow'],//弩
        ['minecraft:ghast_tear'],//恶魂之泪
        ['minecraft:golden_axe'],//金斧
        ['minecraft:potion'],//药水
        ['minecraft:lava_bucket'],//熔岩桶
        ['minecraft:rib_armor_trim_smithing_template'],//锻造模板
        ['minecraft:golden_apple'],//金苹果
        ['minecraft:golden_chestplate'],//金胸甲
        ['minecraft:nether_wart'],//下界疣

    ]
    //定义添加权重物品[物品id,概率]
    let weightLootItem = [
        ['minecraft:netherite_scrap',5],//下界合金碎片
        ['enigmaticlegacy:astral_dust',5],//星尘
        ['enigmaticlegacy:astral_potato',2],//传送薯
        ['enigmaticlegacy:astral_fruit',1],//天体果实
        ['kitchenkarrot:dragon_breath_coke',2],//龙息可乐
        ['lightmanscurrency:coin_emerald', 3],//硬币与物品 绿宝石币
        ['enigmaticdelicacy:astral_popsicle',2],//星辰冰棒
        ['delightful:chorus_muffin',1],//紫颂松饼
    ]

    let lootItem = [
        ['enigmaticlegacy:etherium_ore', 0.5],//以太矿石
        ['enigmaticaddons:artificial_flower',0.1],//神秘遗物扩展 魔法石英花
        ['enigmaticaddons:void_tome',0.05],//神秘遗物扩展 虚无之书
        ['enigmaticlegacy:forbidden_fruit',0.05],//神秘佳肴 禁忌之果
        ['enigmaticlegacy:unholy_grail',0.05],//神秘佳肴 不洁圣杯
        ['ends_delight:dragon_breath_and_chorus_soup',0.2],//龙息紫颂汤
    ]


    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('dungeons_arise:chests/aviary/aviary_normal')///幻梦塔楼
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([1, 4], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('dungeons_arise:chests/aviary/aviary_normal')
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('dungeons_arise:chests/aviary/aviary_normal')//幻梦塔楼
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})
//下僻巢穴
LootJS.modifiers(event => {//下僻巢穴
    //定义删除物品,[物品id]
    let removeLoot = [
        

    ]
    //定义添加权重物品[物品id,概率]
    let weightLootItem = [
       ['undergarden:froststeel_nugget',1],//霜钢粒
       ['lightmanscurrency:coin_gold',2],//硬币与物品 金币
       ['undergarden:blood_mushroom',1],//浆血蘑菇
       ['undergarden:ink_mushroom',1],//墨黑蘑菇
       ['undergarden:veil_mushroom',1],//纱障蘑菇
       ['undergarden:indigo_mushroom',1],//靛蓝蘑菇
    ]

    let lootItem = [
       ['undergarden:forgotten_nugget',0.2],//遗忆粒
       
    ]


    //遍历添加的权重物品,传入item,chance表示物品和概率
    weightLootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('undergarden:chests/catacombs')//下僻巢穴
            //随机抽取1-2次weightLootItem里面的参数
            .addWeightedLoot([2, 4], [
                //添加随机到的物品,然后分别对应上概率
                Item.of(item).withChance(chance)
            ])
    })

    lootItem.forEach(([item, chance]) => {
        event
            .addLootTableModifier('undergarden:chests/catacombs')//下僻巢穴
            .addLoot([
                LootEntry.of(item).when(c => c.randomChance(chance))
            ])
    })

    //遍历删除物品,传入item表示删除物品
     removeLoot.forEach(([item]) => {
         event
             .addLootTableModifier('undergarden:chests/catacombs')//下僻巢穴
            .removeLoot(item)//删除遍历removeLoot的物品

     })
})






